-- Dos function call #21 wrap up.
-- by Jacques Deschenes, Baie-Comeau, PQ, Canada, e-mail: Desja@quebectel.com
-- Creation date: September 28th, 1996
-- Why to bother about using dos for files I/O when euphoria can do that?
-- Because with Euphoria you have to read file to sequence and then to poke
-- the sequence in a buffer.
-- with Dos file I/O one can read and write direct to buffer which is faster.
--
-- revesion history
-- february 6th, 1997
--   added 2 functions to set date and time:
--      DosSetDate(sequence Date)
--      DosSetTime(sequence time)
-- February 9th, 1997
--   In DosCreate() redefined type of NameBuffer to atom, was mistakenly 
--   define as sequence.
-- May 6th, 1997
--   corrected bug:  Name buffers where not freed.
-- May 30th, 1997
--   added procedure DeleteFile()
--   added procedure RenameFile()
--   added global integer dos_error
--   added constant FAILED
-- June 7th, 1997
--   added global atom DosVersion and private function GetDosVersion
--   Modified DosCreate(), DosOpen(), DeletFile() and RenameFile() 
--     to accept long file names.
 
with trace
include machine.e
include ports.e
 
global integer dos_error
dos_error = 0
 
constant FAILED = -1
 
global atom DosVersion
 
function GetDosVersion()
sequence regs
  regs = repeat(0,10)
  regs[REG_AX] = #3000
  regs = dos_interrupt(#21,regs)
  return remainder(regs[REG_AX],256) + floor(regs[REG_AX]/256)/100
end function
 
DosVersion = GetDosVersion()
 
global constant READ = 0, WRITE = 1, READ_WRITE=2
 
global function DosCreate(sequence Name, integer attributes)
-- Create a new file.
-- parameters: Name is name of the new file.
--             attributes for the new file.
-- if succes return File handle else return -1
sequence regs
atom NameBuffer
dos_error = 0
regs = repeat(0,10)
NameBuffer = allocate_low(length(Name)+1)
if not NameBuffer then
    dos_error = FAILED
    return FAILED
end if
poke(NameBuffer,Name & 0)
if DosVersion < 7 then
  regs[REG_AX] = #3C00
  regs[REG_CX] = attributes
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_DX] = remainder(NameBuffer,16)
else
  regs[REG_AX] = #716C
  regs[REG_BX] = WRITE 
  regs[REG_CX] = attributes
  regs[REG_DX] = #10
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_SI] = remainder(NameBuffer,16)
  regs[REG_DI] = 1
end if
regs = dos_interrupt(#21,regs)
free_low(NameBuffer)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to create
end if
return regs[REG_AX]  -- return file handle
end function -- DosCreate()
 
global procedure DeleteFile(sequence FileName)
atom NameBuffer
sequence regs
   dos_error = 0
   NameBuffer=allocate_low(length(FileName)+1)
   if NameBuffer = 0 then
     dos_error = FAILED
     return
   end if
   poke(NameBuffer,FileName&0)
   regs = repeat(0,10)
   regs[REG_DS] = floor(NameBuffer/16)
   regs[REG_DX] = remainder(NameBuffer,16)
   if DosVersion < 7 then
     regs[REG_AX] = #4100
   else
     regs[REG_AX] = #7141
   end if
   regs = dos_interrupt(#21,regs)
  if and_bits(regs[REG_FLAGS],1) then
     dos_error = regs[REG_AX]
  end if
  free_low(NameBuffer)
end procedure
 
global function DosOpen(sequence FileName, integer Mode)
-- use DOS function #3D to open a file
-- return file handle or -1 if error
-- mode is 0 = read only
--         1 = write only
--         2 = read/write 
 
atom NameBuffer
sequence regs
dos_error = 0
regs = repeat(0,10)
NameBuffer = allocate_low(length(FileName)+1)
if not NameBuffer then
    dos_error = FAILED
    return FAILED
end if
poke(NameBuffer,FileName & 0)
if DosVersion < 7 then
  regs[REG_AX] = #3D00+Mode
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_DX] = remainder(NameBuffer,16)
else
  regs[REG_AX] = #716C
  regs[REG_BX] = Mode
  regs[REG_CX] = 0
  regs[REG_DX] = #01  -- action
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_SI] = remainder(NameBuffer,16)
  regs[REG_DI] = 1
end if
regs = dos_interrupt(#21,regs)
free_low(NameBuffer)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to open
end if
return regs[REG_AX]  -- return file handle
end function -- DosOpen()
 
global function DosClose(integer Handle)
-- close a file open with DosOpen()
-- return 1 if success else return 0
sequence regs
    dos_error = 0
    regs = repeat(0,10)
    regs[REG_AX] = #3E00
    regs[REG_BX] = Handle
    regs = dos_interrupt(#21,regs)
    if and_bits(regs[REG_FLAGS],1) then
	dos_error = regs[REG_AX]
	return 0
    end if
    return 1
end function -- DosClose()
 
global function BlockRead(integer Handle, atom buffer, atom NbBytes)
-- Read a given number of bytes from a file open with DosOpen() to a buffer 
-- if success return Number of bytes actually read else return -1
-- parameters:
--    Handle -> the file Handle returned by DosOpen()
--    buffer -> is a pointer returned byt allocate_low() where the data will be
--              read.
--    NbBytes -> is the number of bytes to read.
 
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #3F00
regs[REG_BX] = Handle
regs[REG_CX] = NbBytes
regs[REG_DS] = floor(buffer/16)
regs[REG_DX] = remainder(buffer,16)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to read
end if
return regs[REG_AX]
end function --BlockRead()
 
global function BlockWrite(integer Handle, atom buffer, atom NbBytes)
-- Write to a file open with DosOpen() from a buffer.
-- if succes return number of bytes actually written else return 0
-- parameters: Handle -> handle returned by DosOpen()
--             buffer -> buffer pointer returned by allocate_low() where data
--                       to write is stored.
--             NbBytes -> Number of bytes to write
 
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #4000
regs[REG_BX] = Handle
regs[REG_CX] = NbBytes
regs[REG_DS] = floor(buffer/16)
regs[REG_DX] = remainder(buffer,16)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to write
end if
return regs[REG_AX]
end function -- BlockWrite()
 
global constant -- seek origin constants
    START_OF_FILE = 0,
    CURRNENT_POS = 1,
    END_OF_FILE = 2
    
global function DosSeek(integer Handle, integer Distance, integer Origin)
-- Move the file read/write pointer to specified position
-- return new pointer position or -1 if error.
-- parameters: Handle is DosOpen() handle
--             Distance is distance to move to
--             Origin from where Distance is added
--              Origin = 0 beginning of file + Distance
--              Origin = 1 current location + Distance
--              Origin = 2 end of file + Distance
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #4200+Origin
regs[REG_BX] = Handle
regs[REG_CX] = floor(Distance/256)
regs[REG_DX] = remainder(Distance,256)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED 
end if
return regs[REG_AX]
end function --DosSeek()
 
global procedure DosSetDate(sequence Date)
-- Date format is {year, month, day)    
sequence r
  r = repeat(0,10)
  r[REG_AX] = #2B00
  r[REG_CX] = Date[1]
  r[REG_DX] = Date[2]*256+Date[3]
  r = dos_interrupt(#21,r)
end procedure -- DosSetDate()
 
global procedure DosSetTime(sequence Time)
-- Time format is {Hours, minutes, secondes}    
-- 24 hours format used.
sequence r
  r = repeat(0,10)
  r[REG_AX] = #2D00
  r[REG_CX] = Time[1]*256+Time[2]
  r[REG_DX] = Time[3]*256
  r = dos_interrupt(#21,r)
end procedure -- DosSetTime()
 
constant BUFF_SIZE = power(2,15)
 
global function CopyFile(sequence Source, -- source file name
			 sequence Dest    -- destination file name
			)
 
atom buffer
integer   FSrc, FDest, NbRead, junk
 
    dos_error = 0
    FSrc = DosOpen(Source,READ)
    if FSrc = -1 then
	return 0
    end if
    FDest = DosCreate(Dest,0)
    if FDest = -1 then
	return 0
    end if  
    buffer = allocate_low(BUFF_SIZE)
    if buffer = 0 then
	dos_error = FAILED
	return 0
    end if
    NbRead = BlockRead(FSrc,buffer,BUFF_SIZE)
    while NbRead > 0 do
	if BlockWrite(FDest,buffer,NbRead) = -1 then
	  junk = DosClose(FSrc)
	  junk = DosClose(FDest)
	  free_low(buffer)
	  return 0
	end if
       NbRead = BlockRead(FSrc,buffer,BUFF_SIZE)
    end while
    junk = DosClose(FSrc)
    junk = DosClose(FDest)
    free_low(buffer)
    return 1
end function
 
global procedure RenameFile(sequence Current, sequence New)
atom NameBufferCurrent, NameBufferNew
sequence regs
    
    dos_error = 0
    regs = repeat(0,10)
    NameBufferCurrent = allocate_low(length(Current)+1)
    if NameBufferCurrent = 0 then
	dos_error = FAILED
	return
    end if
    NameBufferNew = allocate_low(length(New)+1)
    if NameBufferNew = 0 then
	dos_error = FAILED
	free_low(NameBufferCurrent)
	return
    end if
    poke(NameBufferCurrent,Current&0)
    poke(NameBufferNew,New&0)
    regs[REG_DS] = floor(NameBufferCurrent/16)
    regs[REG_DX] = remainder(NameBufferCurrent,16)
    regs[REG_ES] = floor(NameBufferNew/16)
    regs[REG_DI] = remainder(NameBufferNew,16)
    if DosVersion < 7 then
      regs[REG_AX] = #5600
    else    
      regs[REG_AX] = #7156
    end if
    regs = dos_interrupt(#21,regs)
    if and_bits(regs[REG_FLAGS],1) then
	dos_error = regs[REG_AX]
    end if
    free_low(NameBufferCurrent)
    free_low(NameBufferNew)
end procedure
 
Jacques Deschenes
Baie-Comeau, Quebec
Canada
desja@quebectel.com
To:   Robert Craig, [72614,1667]
From: Jacques Deschenes, INTERNET:desja@quebectel.com
Date: 6/7/97, 12:11 PM
Re:   doswrap.e last revision
 
 
Sender: desja@quebectel.com
Received: from mail.quebectel.com (mail.quebectel.com [142.169.1.18]) by dub-img-3.compuserve.com (8.6.10/5.950515)
	id MAA01814; Sat, 7 Jun 1997 12:11:23 -0400
Received: from desja.quebectel.com (ts1-33.f106.quebectel.com [142.169.36.103]) by mail.quebectel.com (8.8.5/8.8.5) with SMTP id MAA02345 for <72614.1667@compuserve.com>; Sat, 7 Jun 1997 12:11:18 -0400 (EDT)
Message-Id: <1.5.4.32.19970607160610.006e35f8@quebectel.com>
X-Sender: desja@quebectel.com
X-Mailer: Windows Eudora Light Version 1.5.4 (32)
Mime-Version: 1.0
Content-Type: multipart/mixed; boundary="=====================_865713970==_"
Date: Sat, 07 Jun 1997 12:06:10 -0400
To: Robert Craig<72614.1667@compuserve.com>
From: Jacques Deschenes <desja@quebectel.com>
Subject: doswrap.e last revision
X-Attachments: c:\euphoria\work\doswrap.e;
Hi Robert,
 
 
   I send you this last revision of doswrap.e
 
with the following modifications.
 
-- May 30th, 1997
--   added procedure DeleteFile()
--   added procedure RenameFile()
--   added global integer dos_error
--   added constant FAILED
-- June 7th, 1997
--   added global atom DosVersion and private function GetDosVersion
--   Modified DosCreate(), DosOpen(), DeletFile() and RenameFile() 
--     to accept long file names.
 
 
Regards,
 
-- Dos function call #21 wrap up.
-- by Jacques Deschenes, Baie-Comeau, PQ, Canada, e-mail: Desja@quebectel.com
-- Creation date: September 28th, 1996
-- Why to bother about using dos for files I/O when euphoria can do that?
-- Because with Euphoria you have to read file to sequence and then to poke
-- the sequence in a buffer.
-- with Dos file I/O one can read and write direct to buffer which is faster.
--
-- revesion history
-- february 6th, 1997
--   added 2 functions to set date and time:
--      DosSetDate(sequence Date)
--      DosSetTime(sequence time)
-- February 9th, 1997
--   In DosCreate() redefined type of NameBuffer to atom, was mistakenly 
--   define as sequence.
-- May 6th, 1997
--   corrected bug:  Name buffers where not freed.
-- May 30th, 1997
--   added procedure DeleteFile()
--   added procedure RenameFile()
--   added global integer dos_error
--   added constant FAILED
-- June 7th, 1997
--   added global atom DosVersion and private function GetDosVersion
--   Modified DosCreate(), DosOpen(), DeletFile() and RenameFile() 
--     to accept long file names.
 
with trace
include machine.e
include ports.e
 
global integer dos_error
dos_error = 0
 
constant FAILED = -1
 
global atom DosVersion
 
function GetDosVersion()
sequence regs
  regs = repeat(0,10)
  regs[REG_AX] = #3000
  regs = dos_interrupt(#21,regs)
  return remainder(regs[REG_AX],256) + floor(regs[REG_AX]/256)/100
end function
 
DosVersion = GetDosVersion()
 
global constant READ = 0, WRITE = 1, READ_WRITE=2
 
global function DosCreate(sequence Name, integer attributes)
-- Create a new file.
-- parameters: Name is name of the new file.
--             attributes for the new file.
-- if succes return File handle else return -1
sequence regs
atom NameBuffer
dos_error = 0
regs = repeat(0,10)
NameBuffer = allocate_low(length(Name)+1)
if not NameBuffer then
    dos_error = FAILED
    return FAILED
end if
poke(NameBuffer,Name & 0)
if DosVersion < 7 then
  regs[REG_AX] = #3C00
  regs[REG_CX] = attributes
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_DX] = remainder(NameBuffer,16)
else
  regs[REG_AX] = #716C
  regs[REG_BX] = WRITE 
  regs[REG_CX] = attributes
  regs[REG_DX] = #10
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_SI] = remainder(NameBuffer,16)
  regs[REG_DI] = 1
end if
regs = dos_interrupt(#21,regs)
free_low(NameBuffer)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to create
end if
return regs[REG_AX]  -- return file handle
end function -- DosCreate()
 
global procedure DeleteFile(sequence FileName)
atom NameBuffer
sequence regs
   dos_error = 0
   NameBuffer=allocate_low(length(FileName)+1)
   if NameBuffer = 0 then
     dos_error = FAILED
     return
   end if
   poke(NameBuffer,FileName&0)
   regs = repeat(0,10)
   regs[REG_DS] = floor(NameBuffer/16)
   regs[REG_DX] = remainder(NameBuffer,16)
   if DosVersion < 7 then
     regs[REG_AX] = #4100
   else
     regs[REG_AX] = #7141
   end if
   regs = dos_interrupt(#21,regs)
  if and_bits(regs[REG_FLAGS],1) then
     dos_error = regs[REG_AX]
  end if
  free_low(NameBuffer)
end procedure
 
global function DosOpen(sequence FileName, integer Mode)
-- use DOS function #3D to open a file
-- return file handle or -1 if error
-- mode is 0 = read only
--         1 = write only
--         2 = read/write 
 
atom NameBuffer
sequence regs
dos_error = 0
regs = repeat(0,10)
NameBuffer = allocate_low(length(FileName)+1)
if not NameBuffer then
    dos_error = FAILED
    return FAILED
end if
poke(NameBuffer,FileName & 0)
if DosVersion < 7 then
  regs[REG_AX] = #3D00+Mode
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_DX] = remainder(NameBuffer,16)
else
  regs[REG_AX] = #716C
  regs[REG_BX] = Mode
  regs[REG_CX] = 0
  regs[REG_DX] = #01  -- action
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_SI] = remainder(NameBuffer,16)
  regs[REG_DI] = 1
end if
regs = dos_interrupt(#21,regs)
free_low(NameBuffer)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to open
end if
return regs[REG_AX]  -- return file handle
end function -- DosOpen()
 
global function DosClose(integer Handle)
-- close a file open with DosOpen()
-- return 1 if success else return 0
sequence regs
    dos_error = 0
    regs = repeat(0,10)
    regs[REG_AX] = #3E00
    regs[REG_BX] = Handle
    regs = dos_interrupt(#21,regs)
    if and_bits(regs[REG_FLAGS],1) then
	dos_error = regs[REG_AX]
	return 0
    end if
    return 1
end function -- DosClose()
 
global function BlockRead(integer Handle, atom buffer, atom NbBytes)
-- Read a given number of bytes from a file open with DosOpen() to a buffer 
-- if success return Number of bytes actually read else return -1
-- parameters:
--    Handle -> the file Handle returned by DosOpen()
--    buffer -> is a pointer returned byt allocate_low() where the data will be
--              read.
--    NbBytes -> is the number of bytes to read.
 
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #3F00
regs[REG_BX] = Handle
regs[REG_CX] = NbBytes
regs[REG_DS] = floor(buffer/16)
regs[REG_DX] = remainder(buffer,16)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to read
end if
return regs[REG_AX]
end function --BlockRead()
 
global function BlockWrite(integer Handle, atom buffer, atom NbBytes)
-- Write to a file open with DosOpen() from a buffer.
-- if succes return number of bytes actually written else return 0
-- parameters: Handle -> handle returned by DosOpen()
--             buffer -> buffer pointer returned by allocate_low() where data
--                       to write is stored.
--             NbBytes -> Number of bytes to write
 
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #4000
regs[REG_BX] = Handle
regs[REG_CX] = NbBytes
regs[REG_DS] = floor(buffer/16)
regs[REG_DX] = remainder(buffer,16)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to write
end if
return regs[REG_AX]
end function -- BlockWrite()
 
global constant -- seek origin constants
    START_OF_FILE = 0,
    CURRNENT_POS = 1,
    END_OF_FILE = 2
    
global function DosSeek(integer Handle, integer Distance, integer Origin)
-- Move the file read/write pointer to specified position
-- return new pointer position or -1 if error.
-- parameters: Handle is DosOpen() handle
--             Distance is distance to move to
--             Origin from where Distance is added
--              Origin = 0 beginning of file + Distance
--              Origin = 1 current location + Distance
--              Origin = 2 end of file + Distance
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #4200+Origin
regs[REG_BX] = Handle
regs[REG_CX] = floor(Distance/256)
regs[REG_DX] = remainder(Distance,256)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED 
end if
return regs[REG_AX]
end function --DosSeek()
 
global procedure DosSetDate(sequence Date)
-- Date format is {year, month, day)    
sequence r
  r = repeat(0,10)
  r[REG_AX] = #2B00
  r[REG_CX] = Date[1]
  r[REG_DX] = Date[2]*256+Date[3]
  r = dos_interrupt(#21,r)
end procedure -- DosSetDate()
 
global procedure DosSetTime(sequence Time)
-- Time format is {Hours, minutes, secondes}    
-- 24 hours format used.
sequence r
  r = repeat(0,10)
  r[REG_AX] = #2D00
  r[REG_CX] = Time[1]*256+Time[2]
  r[REG_DX] = Time[3]*256
  r = dos_interrupt(#21,r)
end procedure -- DosSetTime()
 
constant BUFF_SIZE = power(2,15)
 
global function CopyFile(sequence Source, -- source file name
			 sequence Dest    -- destination file name
			)
 
atom buffer
integer   FSrc, FDest, NbRead, junk
 
    dos_error = 0
    FSrc = DosOpen(Source,READ)
    if FSrc = -1 then
	return 0
    end if
    FDest = DosCreate(Dest,0)
    if FDest = -1 then
	return 0
    end if  
    buffer = allocate_low(BUFF_SIZE)
    if buffer = 0 then
	dos_error = FAILED
	return 0
    end if
    NbRead = BlockRead(FSrc,buffer,BUFF_SIZE)
    while NbRead > 0 do
	if BlockWrite(FDest,buffer,NbRead) = -1 then
	  junk = DosClose(FSrc)
	  junk = DosClose(FDest)
	  free_low(buffer)
	  return 0
	end if
       NbRead = BlockRead(FSrc,buffer,BUFF_SIZE)
    end while
    junk = DosClose(FSrc)
    junk = DosClose(FDest)
    free_low(buffer)
    return 1
end function
 
global procedure RenameFile(sequence Current, sequence New)
atom NameBufferCurrent, NameBufferNew
sequence regs
    
    dos_error = 0
    regs = repeat(0,10)
    NameBufferCurrent = allocate_low(length(Current)+1)
    if NameBufferCurrent = 0 then
	dos_error = FAILED
	return
    end if
    NameBufferNew = allocate_low(length(New)+1)
    if NameBufferNew = 0 then
	dos_error = FAILED
	free_low(NameBufferCurrent)
	return
    end if
    poke(NameBufferCurrent,Current&0)
    poke(NameBufferNew,New&0)
    regs[REG_DS] = floor(NameBufferCurrent/16)
    regs[REG_DX] = remainder(NameBufferCurrent,16)
    regs[REG_ES] = floor(NameBufferNew/16)
    regs[REG_DI] = remainder(NameBufferNew,16)
    if DosVersion < 7 then
      regs[REG_AX] = #5600
    else    
      regs[REG_AX] = #7156
    end if
    regs = dos_interrupt(#21,regs)
    if and_bits(regs[REG_FLAGS],1) then
	dos_error = regs[REG_AX]
    end if
    free_low(NameBufferCurrent)
    free_low(NameBufferNew)
end procedure
 
Jacques Deschenes
Baie-Comeau, Quebec
Canada
desja@quebectel.com
To:   Robert Craig, [72614,1667]
From: Jacques Deschenes, INTERNET:desja@quebectel.com
Date: 6/7/97, 12:11 PM
Re:   doswrap.e last revision
 
 
Sender: desja@quebectel.com
Received: from mail.quebectel.com (mail.quebectel.com [142.169.1.18]) by dub-img-3.compuserve.com (8.6.10/5.950515)
	id MAA01814; Sat, 7 Jun 1997 12:11:23 -0400
Received: from desja.quebectel.com (ts1-33.f106.quebectel.com [142.169.36.103]) by mail.quebectel.com (8.8.5/8.8.5) with SMTP id MAA02345 for <72614.1667@compuserve.com>; Sat, 7 Jun 1997 12:11:18 -0400 (EDT)
Message-Id: <1.5.4.32.19970607160610.006e35f8@quebectel.com>
X-Sender: desja@quebectel.com
X-Mailer: Windows Eudora Light Version 1.5.4 (32)
Mime-Version: 1.0
Content-Type: multipart/mixed; boundary="=====================_865713970==_"
Date: Sat, 07 Jun 1997 12:06:10 -0400
To: Robert Craig<72614.1667@compuserve.com>
From: Jacques Deschenes <desja@quebectel.com>
Subject: doswrap.e last revision
X-Attachments: c:\euphoria\work\doswrap.e;
Hi Robert,
 
 
   I send you this last revision of doswrap.e
 
with the following modifications.
 
-- May 30th, 1997
--   added procedure DeleteFile()
--   added procedure RenameFile()
--   added global integer dos_error
--   added constant FAILED
-- June 7th, 1997
--   added global atom DosVersion and private function GetDosVersion
--   Modified DosCreate(), DosOpen(), DeletFile() and RenameFile() 
--     to accept long file names.
 
 
Regards,
 
-- Dos function call #21 wrap up.
-- by Jacques Deschenes, Baie-Comeau, PQ, Canada, e-mail: Desja@quebectel.com
-- Creation date: September 28th, 1996
-- Why to bother about using dos for files I/O when euphoria can do that?
-- Because with Euphoria you have to read file to sequence and then to poke
-- the sequence in a buffer.
-- with Dos file I/O one can read and write direct to buffer which is faster.
--
-- revesion history
-- february 6th, 1997
--   added 2 functions to set date and time:
--      DosSetDate(sequence Date)
--      DosSetTime(sequence time)
-- February 9th, 1997
--   In DosCreate() redefined type of NameBuffer to atom, was mistakenly 
--   define as sequence.
-- May 6th, 1997
--   corrected bug:  Name buffers where not freed.
-- May 30th, 1997
--   added procedure DeleteFile()
--   added procedure RenameFile()
--   added global integer dos_error
--   added constant FAILED
-- June 7th, 1997
--   added global atom DosVersion and private function GetDosVersion
--   Modified DosCreate(), DosOpen(), DeletFile() and RenameFile() 
--     to accept long file names.
 
with trace
include machine.e
include ports.e
 
global integer dos_error
dos_error = 0
 
constant FAILED = -1
 
global atom DosVersion
 
function GetDosVersion()
sequence regs
  regs = repeat(0,10)
  regs[REG_AX] = #3000
  regs = dos_interrupt(#21,regs)
  return remainder(regs[REG_AX],256) + floor(regs[REG_AX]/256)/100
end function
 
DosVersion = GetDosVersion()
 
global constant READ = 0, WRITE = 1, READ_WRITE=2
 
global function DosCreate(sequence Name, integer attributes)
-- Create a new file.
-- parameters: Name is name of the new file.
--             attributes for the new file.
-- if succes return File handle else return -1
sequence regs
atom NameBuffer
dos_error = 0
regs = repeat(0,10)
NameBuffer = allocate_low(length(Name)+1)
if not NameBuffer then
    dos_error = FAILED
    return FAILED
end if
poke(NameBuffer,Name & 0)
if DosVersion < 7 then
  regs[REG_AX] = #3C00
  regs[REG_CX] = attributes
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_DX] = remainder(NameBuffer,16)
else
  regs[REG_AX] = #716C
  regs[REG_BX] = WRITE 
  regs[REG_CX] = attributes
  regs[REG_DX] = #10
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_SI] = remainder(NameBuffer,16)
  regs[REG_DI] = 1
end if
regs = dos_interrupt(#21,regs)
free_low(NameBuffer)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to create
end if
return regs[REG_AX]  -- return file handle
end function -- DosCreate()
 
global procedure DeleteFile(sequence FileName)
atom NameBuffer
sequence regs
   dos_error = 0
   NameBuffer=allocate_low(length(FileName)+1)
   if NameBuffer = 0 then
     dos_error = FAILED
     return
   end if
   poke(NameBuffer,FileName&0)
   regs = repeat(0,10)
   regs[REG_DS] = floor(NameBuffer/16)
   regs[REG_DX] = remainder(NameBuffer,16)
   if DosVersion < 7 then
     regs[REG_AX] = #4100
   else
     regs[REG_AX] = #7141
   end if
   regs = dos_interrupt(#21,regs)
  if and_bits(regs[REG_FLAGS],1) then
     dos_error = regs[REG_AX]
  end if
  free_low(NameBuffer)
end procedure
 
global function DosOpen(sequence FileName, integer Mode)
-- use DOS function #3D to open a file
-- return file handle or -1 if error
-- mode is 0 = read only
--         1 = write only
--         2 = read/write 
 
atom NameBuffer
sequence regs
dos_error = 0
regs = repeat(0,10)
NameBuffer = allocate_low(length(FileName)+1)
if not NameBuffer then
    dos_error = FAILED
    return FAILED
end if
poke(NameBuffer,FileName & 0)
if DosVersion < 7 then
  regs[REG_AX] = #3D00+Mode
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_DX] = remainder(NameBuffer,16)
else
  regs[REG_AX] = #716C
  regs[REG_BX] = Mode
  regs[REG_CX] = 0
  regs[REG_DX] = #01  -- action
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_SI] = remainder(NameBuffer,16)
  regs[REG_DI] = 1
end if
regs = dos_interrupt(#21,regs)
free_low(NameBuffer)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to open
end if
return regs[REG_AX]  -- return file handle
end function -- DosOpen()
 
global function DosClose(integer Handle)
-- close a file open with DosOpen()
-- return 1 if success else return 0
sequence regs
    dos_error = 0
    regs = repeat(0,10)
    regs[REG_AX] = #3E00
    regs[REG_BX] = Handle
    regs = dos_interrupt(#21,regs)
    if and_bits(regs[REG_FLAGS],1) then
	dos_error = regs[REG_AX]
	return 0
    end if
    return 1
end function -- DosClose()
 
global function BlockRead(integer Handle, atom buffer, atom NbBytes)
-- Read a given number of bytes from a file open with DosOpen() to a buffer 
-- if success return Number of bytes actually read else return -1
-- parameters:
--    Handle -> the file Handle returned by DosOpen()
--    buffer -> is a pointer returned byt allocate_low() where the data will be
--              read.
--    NbBytes -> is the number of bytes to read.
 
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #3F00
regs[REG_BX] = Handle
regs[REG_CX] = NbBytes
regs[REG_DS] = floor(buffer/16)
regs[REG_DX] = remainder(buffer,16)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to read
end if
return regs[REG_AX]
end function --BlockRead()
 
global function BlockWrite(integer Handle, atom buffer, atom NbBytes)
-- Write to a file open with DosOpen() from a buffer.
-- if succes return number of bytes actually written else return 0
-- parameters: Handle -> handle returned by DosOpen()
--             buffer -> buffer pointer returned by allocate_low() where data
--                       to write is stored.
--             NbBytes -> Number of bytes to write
 
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #4000
regs[REG_BX] = Handle
regs[REG_CX] = NbBytes
regs[REG_DS] = floor(buffer/16)
regs[REG_DX] = remainder(buffer,16)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to write
end if
return regs[REG_AX]
end function -- BlockWrite()
 
global constant -- seek origin constants
    START_OF_FILE = 0,
    CURRNENT_POS = 1,
    END_OF_FILE = 2
    
global function DosSeek(integer Handle, integer Distance, integer Origin)
-- Move the file read/write pointer to specified position
-- return new pointer position or -1 if error.
-- parameters: Handle is DosOpen() handle
--             Distance is distance to move to
--             Origin from where Distance is added
--              Origin = 0 beginning of file + Distance
--              Origin = 1 current location + Distance
--              Origin = 2 end of file + Distance
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #4200+Origin
regs[REG_BX] = Handle
regs[REG_CX] = floor(Distance/256)
regs[REG_DX] = remainder(Distance,256)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED 
end if
return regs[REG_AX]
end function --DosSeek()
 
global procedure DosSetDate(sequence Date)
-- Date format is {year, month, day)    
sequence r
  r = repeat(0,10)
  r[REG_AX] = #2B00
  r[REG_CX] = Date[1]
  r[REG_DX] = Date[2]*256+Date[3]
  r = dos_interrupt(#21,r)
end procedure -- DosSetDate()
 
global procedure DosSetTime(sequence Time)
-- Time format is {Hours, minutes, secondes}    
-- 24 hours format used.
sequence r
  r = repeat(0,10)
  r[REG_AX] = #2D00
  r[REG_CX] = Time[1]*256+Time[2]
  r[REG_DX] = Time[3]*256
  r = dos_interrupt(#21,r)
end procedure -- DosSetTime()
 
constant BUFF_SIZE = power(2,15)
 
global function CopyFile(sequence Source, -- source file name
			 sequence Dest    -- destination file name
			)
 
atom buffer
integer   FSrc, FDest, NbRead, junk
 
    dos_error = 0
    FSrc = DosOpen(Source,READ)
    if FSrc = -1 then
	return 0
    end if
    FDest = DosCreate(Dest,0)
    if FDest = -1 then
	return 0
    end if  
    buffer = allocate_low(BUFF_SIZE)
    if buffer = 0 then
	dos_error = FAILED
	return 0
    end if
    NbRead = BlockRead(FSrc,buffer,BUFF_SIZE)
    while NbRead > 0 do
	if BlockWrite(FDest,buffer,NbRead) = -1 then
	  junk = DosClose(FSrc)
	  junk = DosClose(FDest)
	  free_low(buffer)
	  return 0
	end if
       NbRead = BlockRead(FSrc,buffer,BUFF_SIZE)
    end while
    junk = DosClose(FSrc)
    junk = DosClose(FDest)
    free_low(buffer)
    return 1
end function
 
global procedure RenameFile(sequence Current, sequence New)
atom NameBufferCurrent, NameBufferNew
sequence regs
    
    dos_error = 0
    regs = repeat(0,10)
    NameBufferCurrent = allocate_low(length(Current)+1)
    if NameBufferCurrent = 0 then
	dos_error = FAILED
	return
    end if
    NameBufferNew = allocate_low(length(New)+1)
    if NameBufferNew = 0 then
	dos_error = FAILED
	free_low(NameBufferCurrent)
	return
    end if
    poke(NameBufferCurrent,Current&0)
    poke(NameBufferNew,New&0)
    regs[REG_DS] = floor(NameBufferCurrent/16)
    regs[REG_DX] = remainder(NameBufferCurrent,16)
    regs[REG_ES] = floor(NameBufferNew/16)
    regs[REG_DI] = remainder(NameBufferNew,16)
    if DosVersion < 7 then
      regs[REG_AX] = #5600
    else    
      regs[REG_AX] = #7156
    end if
    regs = dos_interrupt(#21,regs)
    if and_bits(regs[REG_FLAGS],1) then
	dos_error = regs[REG_AX]
    end if
    free_low(NameBufferCurrent)
    free_low(NameBufferNew)
end procedure
 
Jacques Deschenes
Baie-Comeau, Quebec
Canada
desja@quebectel.com
To:   Robert Craig, [72614,1667]
From: Jacques Deschenes, INTERNET:desja@quebectel.com
Date: 6/7/97, 12:11 PM
Re:   doswrap.e last revision
 
 
Sender: desja@quebectel.com
Received: from mail.quebectel.com (mail.quebectel.com [142.169.1.18]) by dub-img-3.compuserve.com (8.6.10/5.950515)
	id MAA01814; Sat, 7 Jun 1997 12:11:23 -0400
Received: from desja.quebectel.com (ts1-33.f106.quebectel.com [142.169.36.103]) by mail.quebectel.com (8.8.5/8.8.5) with SMTP id MAA02345 for <72614.1667@compuserve.com>; Sat, 7 Jun 1997 12:11:18 -0400 (EDT)
Message-Id: <1.5.4.32.19970607160610.006e35f8@quebectel.com>
X-Sender: desja@quebectel.com
X-Mailer: Windows Eudora Light Version 1.5.4 (32)
Mime-Version: 1.0
Content-Type: multipart/mixed; boundary="=====================_865713970==_"
Date: Sat, 07 Jun 1997 12:06:10 -0400
To: Robert Craig<72614.1667@compuserve.com>
From: Jacques Deschenes <desja@quebectel.com>
Subject: doswrap.e last revision
X-Attachments: c:\euphoria\work\doswrap.e;
Hi Robert,
 
 
   I send you this last revision of doswrap.e
 
with the following modifications.
 
-- May 30th, 1997
--   added procedure DeleteFile()
--   added procedure RenameFile()
--   added global integer dos_error
--   added constant FAILED
-- June 7th, 1997
--   added global atom DosVersion and private function GetDosVersion
--   Modified DosCreate(), DosOpen(), DeletFile() and RenameFile() 
--     to accept long file names.
 
 
Regards,
 
-- Dos function call #21 wrap up.
-- by Jacques Deschenes, Baie-Comeau, PQ, Canada, e-mail: Desja@quebectel.com
-- Creation date: September 28th, 1996
-- Why to bother about using dos for files I/O when euphoria can do that?
-- Because with Euphoria you have to read file to sequence and then to poke
-- the sequence in a buffer.
-- with Dos file I/O one can read and write direct to buffer which is faster.
--
-- revesion history
-- february 6th, 1997
--   added 2 functions to set date and time:
--      DosSetDate(sequence Date)
--      DosSetTime(sequence time)
-- February 9th, 1997
--   In DosCreate() redefined type of NameBuffer to atom, was mistakenly 
--   define as sequence.
-- May 6th, 1997
--   corrected bug:  Name buffers where not freed.
-- May 30th, 1997
--   added procedure DeleteFile()
--   added procedure RenameFile()
--   added global integer dos_error
--   added constant FAILED
-- June 7th, 1997
--   added global atom DosVersion and private function GetDosVersion
--   Modified DosCreate(), DosOpen(), DeletFile() and RenameFile() 
--     to accept long file names.
 
with trace
include machine.e
include ports.e
 
global integer dos_error
dos_error = 0
 
constant FAILED = -1
 
global atom DosVersion
 
function GetDosVersion()
sequence regs
  regs = repeat(0,10)
  regs[REG_AX] = #3000
  regs = dos_interrupt(#21,regs)
  return remainder(regs[REG_AX],256) + floor(regs[REG_AX]/256)/100
end function
 
DosVersion = GetDosVersion()
 
global constant READ = 0, WRITE = 1, READ_WRITE=2
 
global function DosCreate(sequence Name, integer attributes)
-- Create a new file.
-- parameters: Name is name of the new file.
--             attributes for the new file.
-- if succes return File handle else return -1
sequence regs
atom NameBuffer
dos_error = 0
regs = repeat(0,10)
NameBuffer = allocate_low(length(Name)+1)
if not NameBuffer then
    dos_error = FAILED
    return FAILED
end if
poke(NameBuffer,Name & 0)
if DosVersion < 7 then
  regs[REG_AX] = #3C00
  regs[REG_CX] = attributes
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_DX] = remainder(NameBuffer,16)
else
  regs[REG_AX] = #716C
  regs[REG_BX] = WRITE 
  regs[REG_CX] = attributes
  regs[REG_DX] = #10
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_SI] = remainder(NameBuffer,16)
  regs[REG_DI] = 1
end if
regs = dos_interrupt(#21,regs)
free_low(NameBuffer)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to create
end if
return regs[REG_AX]  -- return file handle
end function -- DosCreate()
 
global procedure DeleteFile(sequence FileName)
atom NameBuffer
sequence regs
   dos_error = 0
   NameBuffer=allocate_low(length(FileName)+1)
   if NameBuffer = 0 then
     dos_error = FAILED
     return
   end if
   poke(NameBuffer,FileName&0)
   regs = repeat(0,10)
   regs[REG_DS] = floor(NameBuffer/16)
   regs[REG_DX] = remainder(NameBuffer,16)
   if DosVersion < 7 then
     regs[REG_AX] = #4100
   else
     regs[REG_AX] = #7141
   end if
   regs = dos_interrupt(#21,regs)
  if and_bits(regs[REG_FLAGS],1) then
     dos_error = regs[REG_AX]
  end if
  free_low(NameBuffer)
end procedure
 
global function DosOpen(sequence FileName, integer Mode)
-- use DOS function #3D to open a file
-- return file handle or -1 if error
-- mode is 0 = read only
--         1 = write only
--         2 = read/write 
 
atom NameBuffer
sequence regs
dos_error = 0
regs = repeat(0,10)
NameBuffer = allocate_low(length(FileName)+1)
if not NameBuffer then
    dos_error = FAILED
    return FAILED
end if
poke(NameBuffer,FileName & 0)
if DosVersion < 7 then
  regs[REG_AX] = #3D00+Mode
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_DX] = remainder(NameBuffer,16)
else
  regs[REG_AX] = #716C
  regs[REG_BX] = Mode
  regs[REG_CX] = 0
  regs[REG_DX] = #01  -- action
  regs[REG_DS] = floor(NameBuffer/16)
  regs[REG_SI] = remainder(NameBuffer,16)
  regs[REG_DI] = 1
end if
regs = dos_interrupt(#21,regs)
free_low(NameBuffer)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to open
end if
return regs[REG_AX]  -- return file handle
end function -- DosOpen()
 
global function DosClose(integer Handle)
-- close a file open with DosOpen()
-- return 1 if success else return 0
sequence regs
    dos_error = 0
    regs = repeat(0,10)
    regs[REG_AX] = #3E00
    regs[REG_BX] = Handle
    regs = dos_interrupt(#21,regs)
    if and_bits(regs[REG_FLAGS],1) then
	dos_error = regs[REG_AX]
	return 0
    end if
    return 1
end function -- DosClose()
 
global function BlockRead(integer Handle, atom buffer, atom NbBytes)
-- Read a given number of bytes from a file open with DosOpen() to a buffer 
-- if success return Number of bytes actually read else return -1
-- parameters:
--    Handle -> the file Handle returned by DosOpen()
--    buffer -> is a pointer returned byt allocate_low() where the data will be
--              read.
--    NbBytes -> is the number of bytes to read.
 
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #3F00
regs[REG_BX] = Handle
regs[REG_CX] = NbBytes
regs[REG_DS] = floor(buffer/16)
regs[REG_DX] = remainder(buffer,16)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to read
end if
return regs[REG_AX]
end function --BlockRead()
 
global function BlockWrite(integer Handle, atom buffer, atom NbBytes)
-- Write to a file open with DosOpen() from a buffer.
-- if succes return number of bytes actually written else return 0
-- parameters: Handle -> handle returned by DosOpen()
--             buffer -> buffer pointer returned by allocate_low() where data
--                       to write is stored.
--             NbBytes -> Number of bytes to write
 
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #4000
regs[REG_BX] = Handle
regs[REG_CX] = NbBytes
regs[REG_DS] = floor(buffer/16)
regs[REG_DX] = remainder(buffer,16)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED -- failed to write
end if
return regs[REG_AX]
end function -- BlockWrite()
 
global constant -- seek origin constants
    START_OF_FILE = 0,
    CURRNENT_POS = 1,
    END_OF_FILE = 2
    
global function DosSeek(integer Handle, integer Distance, integer Origin)
-- Move the file read/write pointer to specified position
-- return new pointer position or -1 if error.
-- parameters: Handle is DosOpen() handle
--             Distance is distance to move to
--             Origin from where Distance is added
--              Origin = 0 beginning of file + Distance
--              Origin = 1 current location + Distance
--              Origin = 2 end of file + Distance
sequence regs
dos_error = 0
regs = repeat(0,10)
regs[REG_AX] = #4200+Origin
regs[REG_BX] = Handle
regs[REG_CX] = floor(Distance/256)
regs[REG_DX] = remainder(Distance,256)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    dos_error = regs[REG_AX]
    return FAILED 
end if
return regs[REG_AX]
end function --DosSeek()
 
global procedure DosSetDate(sequence Date)
-- Date format is {year, month, day)    
sequence r
  r = repeat(0,10)
  r[REG_AX] = #2B00
  r[REG_CX] = Date[1]
  r[REG_DX] = Date[2]*256+Date[3]
  r = dos_interrupt(#21,r)
end procedure -- DosSetDate()
 
global procedure DosSetTime(sequence Time)
-- Time format is {Hours, minutes, secondes}    
-- 24 hours format used.
sequence r
  r = repeat(0,10)
  r[REG_AX] = #2D00
  r[REG_CX] = Time[1]*256+Time[2]
  r[REG_DX] = Time[3]*256
  r = dos_interrupt(#21,r)
end procedure -- DosSetTime()
 
constant BUFF_SIZE = power(2,15)
 
global function CopyFile(sequence Source, -- source file name
			 sequence Dest    -- destination file name
			)
 
atom buffer
integer   FSrc, FDest, NbRead, junk
 
    dos_error = 0
    FSrc = DosOpen(Source,READ)
    if FSrc = -1 then
	return 0
    end if
    FDest = DosCreate(Dest,0)
    if FDest = -1 then
	return 0
    end if  
    buffer = allocate_low(BUFF_SIZE)
    if buffer = 0 then
	dos_error = FAILED
	return 0
    end if
    NbRead = BlockRead(FSrc,buffer,BUFF_SIZE)
    while NbRead > 0 do
	if BlockWrite(FDest,buffer,NbRead) = -1 then
	  junk = DosClose(FSrc)
	  junk = DosClose(FDest)
	  free_low(buffer)
	  return 0
	end if
       NbRead = BlockRead(FSrc,buffer,BUFF_SIZE)
    end while
    junk = DosClose(FSrc)
    junk = DosClose(FDest)
    free_low(buffer)
    return 1
end function
 
global procedure RenameFile(sequence Current, sequence New)
atom NameBufferCurrent, NameBufferNew
sequence regs
    
    dos_error = 0
    regs = repeat(0,10)
    NameBufferCurrent = allocate_low(length(Current)+1)
    if NameBufferCurrent = 0 then
	dos_error = FAILED
	return
    end if
    NameBufferNew = allocate_low(length(New)+1)
    if NameBufferNew = 0 then
	dos_error = FAILED
	free_low(NameBufferCurrent)
	return
    end if
    poke(NameBufferCurrent,Current&0)
    poke(NameBufferNew,New&0)
    regs[REG_DS] = floor(NameBufferCurrent/16)
    regs[REG_DX] = remainder(NameBufferCurrent,16)
    regs[REG_ES] = floor(NameBufferNew/16)
    regs[REG_DI] = remainder(NameBufferNew,16)
    if DosVersion < 7 then
      regs[REG_AX] = #5600
    else    
      regs[REG_AX] = #7156
    end if
    regs = dos_interrupt(#21,regs)
    if and_bits(regs[REG_FLAGS],1) then
	dos_error = regs[REG_AX]
    end if
    free_low(NameBufferCurrent)
    free_low(NameBufferNew)
end procedure
 
-- Jacques Deschenes
-- Baie-Comeau, Quebec
-- Canada
-- desja@quebectel.com
