--       Include file to read the joystick
--       by: Jacques Deschnes, Baie-Comeau, P.Q., Canada.
--       email: Desja@QUEBECTEL.COM
--       note: joystick is accessible by bios interrupt 15H  service 84H
--
--        function                 registers
--                         input             output
--        ---------------------------------------------------------
--       reading buttons    AX=#8400
--                          DX=#0000        AL= button state
--
--       reading stick      AX=#8400
--                          DX=#0001          AX= j1(x)
--                                            BX= j1(y)
--                                            CX= j2(x)
--                                            DX= j2(y)
--
--

include machine.e
sequence reg_list -- list of register values

reg_list = repeat(0, 10)
constant READ_POS=#0001, READ_BUTTONS=#0000
constant INT_15=#15, JOYSTICK=#8400

-- *********************
-- * globals functions *
-- *********************

global function get_stick_pos(integer JoyNo)
-- return the position of the specified joystick
-- position is {x,y}
   sequence position
   position = repeat(0,2)
   reg_list[REG_AX] = JOYSTICK
   reg_list[REG_DX] = READ_POS
   reg_list = dos_interrupt(INT_15,reg_list) -- read joystick
   if JoyNo = 1 then
     position[1] = reg_list[REG_AX]
     position[2] = reg_list[REG_BX]
   else
     position[1] = reg_list[REG_CX]
     position[2] = reg_list[REG_DX]
   end if
   return position
end function -- get_stick_pos

global function get_buttons(integer JoyNo)
-- return the state of the buttons of the specified joystick
-- buttons are {b1,b2} 0  pressed, 1  released

   sequence buttons
   atom ButtonsState
   buttons = repeat(0,2)
   reg_list[REG_AX] = JOYSTICK
   reg_list[REG_DX] = READ_BUTTONS
   reg_list = dos_interrupt(INT_15,reg_list) -- read joystick
   ButtonsState=floor(reg_list[REG_AX]/16)
   if JoyNo != 1 then
     ButtonsState=floor(ButtonsState/4)
   end if
   buttons[1] = remainder(ButtonsState,2)
   ButtonsState=floor(ButtonsState/2)
   buttons[2] = remainder(ButtonsState,2) 

   return buttons
end function -- get_buttons

global function WaitButtons(integer JoyNo)
-- wait until a joystick button is pressed, x specify which joystick
  sequence b
  b = {1,1}
  while b[1] and b[2] do
    b = get_buttons(JoyNo)
  end while 
  return b
end function -- WaitButtons()

global procedure WaitButtonsRelease(integer JoyNo)
  sequence b
  b = get_buttons(JoyNo)
  while b[1] = 0  or b[2] = 0 do
    b = get_buttons(JoyNo)
  end while
end procedure -- WaitButtonsRelease()

global sequence HiX, LoX, HiY, LoY
HiX = repeat(0,2) LoX = repeat(0,2) HiY=repeat(0,2)  LoY=repeat(0,2)

global procedure CalJoyStk(integer JoyNo)
-- Calibrate the joystick 
   sequence b, pos integer cx, cy
   printf(1,"********  Joystick calibration procedure. *********\n\n",{})
   printf(1,"Calibration of joystick %1d\n\n",{JoyNo})
   printf(1,"CENTER joystick and push a button.\n",{})
   b = WaitButtons(JoyNo)
   WaitButtonsRelease(JoyNo)
   pos = get_stick_pos(JoyNo)
   cx = pos[1] cy = pos[2]
   printf(1,"Center x is %d\nCenter y is %d\n",{cx,cy})
   printf(1,"Push joystick UP and LEFT and push a button.\n",{})
   b = WaitButtons(JoyNo)
   WaitButtonsRelease(JoyNo)
   pos = get_stick_pos(JoyNo)
   HiX[JoyNo] = floor((cx+pos[1])/2) HiY[JoyNo] = floor((cy+pos[2])/2)
   printf(1,"High threshold x is %d\nHigh threshold y is %d\n",
	  {HiX[JoyNo],HiY[JoyNo]})
   printf(1,"Push joystick DOWN and RIGHT and push a button.\n",{})
   b = WaitButtons(JoyNo)
   WaitButtonsRelease(JoyNo)
   pos = get_stick_pos(JoyNo)
   LoX[JoyNo] = floor((cx+pos[1])/2) LoY[JoyNo] = floor((cy+pos[2])/2)
   printf(1,"Low threshold x is %d\nLow threshold y is %d\n",
	  {LoX[JoyNo],LoY[JoyNo]})
   printf(1,"Push a button to continu.",{})
   b = WaitButtons(JoyNo)
end procedure -- CalJoyStk()


