-- Menu system.
-- By: Jacques Deschenes, Baie-Comeau, P.Q., Canada
-- e-mail: desja@quebectel.com
-- creation date: august 23th, 1996
--
-- This module implement 2 lines menu system to use in text mode.
--  First line display menu items
--  Second line display help info on the selected item
--  Menu displeay a given line and read the keyboard for a command key.
-- a menu can be longer than screen width.
-- ESC key cancel menu
-- ENTER confirm selected item
-- LEFT and RIGHT arrow move selection thrue items.
-- a menu is a sequence of item.
-- a menu item is a sequence of length 4
--      first element is item name to be displayed on menu line.
--          a tilde indicate which carater to bold.
--      second item is a positive integer or a sub menu sequence.
--          the integer is a unique command ID returned to the caller.
--      third item is a booelan flag that indicate if the command is active.
--      forth item is the help line text displayed under the menu items.
--      example: {"~help",100,1,"display help sub menu"} 
--              note: the '~' is not displayed it mean letter 'h' is enhanced.

include machine.e
include graphics.e
include image.e

global constant M_NAME=1, M_CMD_ID=2, M_ACTIVE=3,M_INFO=4 -- to acces item stru

integer MenuBackColor, MenuNormalColor, MenuSelectColor,MenuBoldColor
integer ScreenLines, ScreenColumns
-- default menu colors
MenuBackColor = BROWN           -- normal background color
MenuNormalColor = BLACK         -- normal text color
MenuSelectColor = GREEN       -- selected item back color
MenuBoldColor =  BRIGHT_BLUE    -- bold caracter color
-- default screen metrics
ScreenLines = 25                
ScreenColumns = 80              

sequence vc
vc = video_config()
ScreenLines = vc[VC_LINES]  ScreenColumns = vc[VC_COLUMNS]

constant SCREEN=1

function ToUpper(atom char)
    if char >= 'a' and char <= 'z' then
	return char - 'a' + 'A'
    end if
    return char
end function -- ToUpper()

global procedure ClrEol()
-- clear to end of line in current bk_color an text_color
    sequence CurPos
    sequence r
    r = repeat(0,REG_LIST_SIZE)
    r[REG_AX] = 9*256+32
    r[REG_BX] = get_display_page()*256 + BkColor*16+TextColor
    CurPos = get_position()
    r[REG_CX] = ScreenColumns-CurPos[2]+1
    r = dos_interrupt(#10,r)
end procedure --ClrEol()

procedure WriteItem(sequence item,integer SelectFlag)
-- write a menu item. If there is no tilde to indicate which letter to bold
-- first letter will be.
-- if SelectFlag is true bk_color is set to MenuSelectColor
   integer pos
   sequence CurPos
   if SelectFlag then
     bk_color(MenuSelectColor)
    else
     bk_color(MenuBackColor)
   end if
   pos = find('~',item)
   if pos = 0 then
      text_color(MenuBoldColor)
      puts(SCREEN,item[1])
      text_color(MenuNormalColor)
      puts(SCREEN,item[2..length(item)])
     elsif pos = 1 then
      text_color(MenuBoldColor)
      puts(SCREEN,item[2])
      text_color(MenuNormalColor)
      puts(SCREEN,item[3..length(item)])
     else
      text_color(MenuNormalColor)
      puts(SCREEN,item[1..pos-1])
      text_color(MenuBoldColor)
      puts(SCREEN,item[pos+1])
      text_color(MenuNormalColor)
      puts(SCREEN,item[pos+2..length(item)])
   end if
   bk_color(MenuBackColor)
   CurPos = get_position()
   if CurPos[2] < ScreenColumns-1 then
      puts(SCREEN,' ')
   end if
end procedure --WriteItem()

function CalcFirst(sequence menu, integer selected)
  integer SelectedPos,First
  SelectedPos = 1
  First = 1
  for i = 1 to selected by 1 do
    if selected = i then exit end if 
    SelectedPos = SelectedPos + length(menu[i][M_NAME])+1
  end for
  while SelectedPos+length(menu[selected][M_NAME]) > ScreenColumns - 2 do
    SelectedPos =  SelectedPos - length(menu[First][M_NAME]-1)
    First = First + 1
  end while
  return First
end function --CalcFirst

procedure DisplayMenu(sequence menu, integer Line, integer selected)
-- Display menu line bolding command letter an enhancing selected item
    sequence CurPos
    integer FirstItem  -- first item to be displayed
    FirstItem = CalcFirst(menu,selected)
    bk_color(MenuBackColor)
    position(Line,1)
    ClrEol()
    if FirstItem > 1 then
	WriteItem({17},0)
    end if
    
    for i = FirstItem to length(menu) by 1 do
	CurPos = get_position()
	if ScreenColumns - CurPos[2] - 2 < length(menu[i][M_NAME]) then
	    WriteItem({16},0)
	    exit 
	end if
	if menu[i][M_ACTIVE] then
	    if selected = i then
		WriteItem(menu[i][M_NAME],1)
		CurPos = get_position()
		if Line = ScreenLines then
		    position(Line-1,1)
		else
		    position(Line+1,1)
		end if
		ClrEol()
		puts(SCREEN,menu[i][M_INFO])
		position(CurPos[1],CurPos[2])
	    else
		WriteItem(menu[i][M_NAME],0)
	    end if
	end if
    end for
end procedure --DisplayMenu

function BuildCmdStr(sequence menu)
    sequence Cmds
    integer pos
    Cmds={}
    for i = 1 to length(menu) by 1 do
      if menu[i][M_ACTIVE] then
	pos = find('~',menu[i][M_NAME])
	if pos= 0 then
	   Cmds = Cmds & ToUpper(menu[i][M_NAME][1])
	  else
	   Cmds = Cmds & ToUpper(menu[i][M_NAME][pos+1])
	end if
	else
	  Cmds = Cmds & 0
      end if
    end for
    return Cmds
end function -- BuildCmdStr()

constant ESC=27,ENTER=13,LEFT=331,RIGHT=333

function NextActive(sequence menu,integer from)
-- scan menu to find the next active item
   for i = from+1 to length(menu) by 1  do
    if menu[i][M_ACTIVE] then
	return i
    end if
   end for
   return from
end function -- NextActive()

function PrevActive(sequence menu, integer from)
    for i = from-1 to 1 by -1 do
	if menu[i][M_ACTIVE] then
	    return i
	end if
    end for
    return from
end function -- PrevActive()

global function DoMenu(sequence Menu, integer LineNo)
-- Display menu at specified line number and wait for a command key.
   sequence CmdStr, ScreenSave,CurrentMenu, stack, OldPos
   sequence OldColor
   integer Selected,level,key,changed
   OldColor = {}
   OldColor = append(OldColor,BkColor) OldColor = append(OldColor,TextColor)
   OldPos = get_position()
   if LineNo = ScreenLines then
     ScreenSave=save_text_image({LineNo-1,1},{LineNo,ScreenColumns})
    else
     ScreenSave=save_text_image({LineNo,1},{LineNo+1,ScreenColumns})
   end if
   CurrentMenu = Menu
   Selected = NextActive(CurrentMenu,0)
   stack = {}
   cursor(NO_CURSOR)
   CmdStr=BuildCmdStr(CurrentMenu)
   level = 1
   changed = 1
   while 1 do
      if changed then
	  DisplayMenu(CurrentMenu,LineNo,Selected)
      end if
      key = ToUpper(get_key())
      if key=ESC then
	if level = 1 then
	    exit
	  else
	    level = level - 1
	    CurrentMenu = stack[level]
	    stack = stack[1..level-1]
	    Selected = NextActive(CurrentMenu,0)
	    CmdStr = BuildCmdStr(CurrentMenu)
	    changed = 1
	end if
	elsif key=ENTER then
	    if atom(CurrentMenu[Selected][M_CMD_ID]) then
		exit
	      else
		level=level+1
		stack = append(stack,CurrentMenu)
		CurrentMenu=CurrentMenu[Selected][M_CMD_ID] -- sub menu
		Selected = NextActive(CurrentMenu,0)
		CmdStr=BuildCmdStr(CurrentMenu)
		changed = 1
	    end if
	
	elsif key=LEFT then
	   if Selected > 1 then
	      Selected = PrevActive(CurrentMenu,Selected)
	      changed = 1
	   end if
	elsif key=RIGHT  then
	      Selected = NextActive(CurrentMenu,Selected)
	      changed = 1
	elsif find(key,CmdStr) then
	    Selected = find(key,CmdStr)
	    if atom(CurrentMenu[Selected][M_CMD_ID]) then
		exit
	      else
		stack=append(stack,CurrentMenu)
		level=level+1
		CurrentMenu=CurrentMenu[Selected][M_CMD_ID] -- sub menu
		Selected = NextActive(CurrentMenu,0)
		CmdStr=BuildCmdStr(CurrentMenu)
		changed = 1
	    end if
	else
	    changed = 0
      end if
   end while
   if LineNo = ScreenLines then
	display_text_image({LineNo-1,1},ScreenSave)
    else  
	display_text_image({LineNo,1},ScreenSave)
    end if
    position(OldPos[1],OldPos[2])
    cursor(UNDERLINE_CURSOR)
    bk_color(OldColor[1]) text_color(OldColor[2])
    if key = ESC then
	return 0
      else
	return CurrentMenu[Selected][M_CMD_ID]
    end if
end function -- DoMenu()

global constant ON = 1, OFF = 0  -- switch item on and off

global function SwitchItem(sequence menu, sequence CmdIdList,integer state)
-- to switch on and off a set off items.
-- search the menu for each CmdId in CmdIdList an activate or deactivate the 
-- corresponding item according to  state (i.e. state = 1 activate, 0 deactivate)
   for i = 1 to length(CmdIdList) by 1 do
     for j = 1 to length(menu)  by 1 do
       if atom(menu[j][M_CMD_ID]) then
	  if CmdIdList[i] = menu[j][M_CMD_ID] then
	    menu[j][M_ACTIVE] = state
	    exit
	  end if
	else 
	  menu[j][M_CMD_ID] = SwitchItem(menu[j][M_CMD_ID],CmdIdList[i..length(CmdIdList)],state)
       end if
     end for -- j
   end for -- i
   return  menu
end function -- SwitchItem()

global constant MC_BACK=1,MC_NORMAL=2,MC_SELECT=3,MC_BOLD=4 -- to access color struc

global procedure SetMenuColors(sequence colors)
-- set the colors used in menu display
-- sequence is {MC_BACK,MC_NORMAL,MC_SELECT,MC_BOLD}
MenuBackColor = colors[MC_BACK]
MenuNormalColor = colors[MC_NORMAL]
MenuSelectColor = colors[MC_SELECT]
MenuBoldColor = colors[MC_BOLD]
end procedure -- SetMenuColors()

