ndDOMAINS

	integerlist = integer*
	stringlist = string*
	
/*
---------------------------------------------------------
PREDICATE : sum
CATEGORY  : List
FUNCTION  : Sum of an integer list
SYNTAX    : sum(IntegerList,Sum)
CALLS     : recursive
---------------------------------------------------------
*/

PREDICATES

    sum(integerlist,integer)

CLAUSES 

    sum([],0) if !.
    sum([Head|Tail],Sum) if
        sum(Tail,Add), !,
        Sum = Head + Add.

/*
---------------------------------------------------------
PREDICATE : append
CATEGORY  : List
FUNCTION  : Appends two lists together
SYNTAX    : append(List1,List2,AppendedList)
CALLS     : recursive
---------------------------------------------------------
*/

PREDICATES

    append(stringlist,stringlist,stringlist)
    append(integerlist,integerlist,integerlist)

CLAUSES

    append([],List,List).
    append([Head|Tail],List,[Head|Back]) if
        append(Tail,List,Back).

/*
---------------------------------------------------------
PREDICATE : pick
CATEGORY  : List
FUNCTION  : Pick element from a list and return the rest
SYNTAX    : pick(Element,List,ResultingList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    pick(string,stringlist,stringlist)
    pick(integer,integerlist,integerlist)

CLAUSES

    pick(Head,[Head|Tail],Tail) if !.
    pick(Element,[Head|Tail],[Head|Back]) if !,
        pick(Element,Tail,Back).

/*
---------------------------------------------------------
PREDICATE : delete
CATEGORY  : List
FUNCTION  : Delete an element from a list
SYNTAX    : delete(Element,List,ResultingList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    delete(string,stringlist,stringlist)
    delete(integer,integerlist,integerlist)

CLAUSES

    delete(Element,[Element|Tail],Tail).
    delete(Element,[Head|Tail],[Head|List]) if !,
        delete(Element,Tail,List).

/*
---------------------------------------------------------
PREDICATE : insort
CATEGORY  : List
FUNCTION  : Sorts a list using insertion method
SYNTAX    : insort(OriginalList,SortedList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    insort(stringlist,stringlist)
    insort(integerlist,integerlist)

    insortsub(stringlist,stringlist,stringlist)
    insortsub(integerlist,integerlist,integerlist)

CLAUSES

    insort([],[]).  
    insort([Head|Tail],List) if !,
        insort(Tail,N), insortsub([Head],N,List).

    insortsub([Head|Tail],[Front|List],[Front|Back]) if
        Front < Head, !,
        insortsub([Head|Tail],List,Back).
    insortsub([Head|_],List,[Head|List]).

/*
---------------------------------------------------------
PREDICATE : last
CATEGORY  : List
FUNCTION  : Returns last element from list
SYNTAX    : last(List,LastElement)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    last(stringlist,string)
    last(integerlist,integer)

CLAUSES

    last([Last],Last).
    last([_|Tail],Last) if !,
        last(Tail,Last).

/*
---------------------------------------------------------
PREDICATE : length
CATEGORY  : List
FUNCTION  : Number of elements in list
SYNTAX    : length(List,Length)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    length(stringlist,integer)
    length(integerlist,integer)
    
CLAUSES

    length([],0) if !.
    length([_|Tail],N) if
        length(Tail,M), !, N = M+1.

/*
---------------------------------------------------------
PREDICATE : member
CATEGORY  : List
FUNCTION  : True if element is a part of the list
SYNTAX    : member(Element,List)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    member(string,stringlist)
    member(integer,integerlist)

CLAUSES

    member(Name,[Name|_]).
    member(Name,[_|Tail]) if !,
        member(Name,Tail).

/*
---------------------------------------------------------
PREDICATE : overlap
CATEGORY  : List
FUNCTION  : Returns the portion common to both lists
SYNTAX    : overlap(List1,List2,CommonElements)
CALLS     : member
---------------------------------------------------------
*/

PREDICATES

    overlap(stringlist,stringlist,stringlist)
    overlap(integerlist,integerlist,integerlist)

CLAUSES

    overlap([],_,[]).
    overlap([Head|Tail],List,[Head|Back]) if
        member(Head,List), !,
        overlap(Tail,List,Back).
    overlap([_|Tail],List,Back) if !,
        overlap(Tail,List,Back).

/*
---------------------------------------------------------
PREDICATE : permute
CATEGORY  : List
FUNCTION  : Find possible permutations
SYNTAX    : permute(List,ResultingList)
CALLS     : delete
---------------------------------------------------------
*/

PREDICATES

    permute(stringlist,stringlist)
    permute(integerlist,integerlist)

CLAUSES

    permute([],[]).
    permute(List,[Head|Tail]) if
        delete(Head,List,Temp),
        permute(Temp,Tail).

/*
---------------------------------------------------------
PREDICATE : qsort
CATEGORY  : List
FUNCTION  : Quick sort a list
SYNTAX    : qsort(List,SortedList)
CALLS     : append
---------------------------------------------------------
*/

PREDICATES

    qsort(stringlist,stringlist)
    qsort(integerlist,integerlist)

    sortsub(string,stringlist,stringlist,stringlist)
    sortsub(integer,integerlist,integerlist,integerlist)

CLAUSES

    qsort([],[]).
    qsort([Head|Tail],List) if
        sortsub(Head,Tail,A,B),
        qsort(A,A1), qsort(B,B1),
        append(A1,[Head|B1],List).

    sortsub(H,[Head|Tail],[Head|Y],Z) if
        Head <= H, !, sortsub(H,Tail,Y,Z).
    sortsub(H,[Head|Tail],Y,[Head|Z]) if
        Head >  H, !, sortsub(H,Tail,Y,Z).
    sortsub(_,[],[],[]).

/*
---------------------------------------------------------
PREDICATE : remove
CATEGORY  : List
FUNCTION  : Remove all occurences of an element
SYNTAX    : remove(Element,List,ResultingList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    remove(string,stringlist,stringlist)
    remove(integer,integerlist,integerlist)

CLAUSES

    remove(Element,[Element|Tail],List) if !,
        remove(Element,Tail,List).
    remove(Element,[Head|Tail],[Head|List]) if !,
        remove(Element,Tail,List).
    remove(_,[],[]).

/*
---------------------------------------------------------
PREDICATE : replace
CATEGORY  : List
FUNCTION  : Replaces one element with another in a list
SYNTAX    : replace(Element,List,NewElement,ResultingList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    replace(string,stringlist,string,stringlist)
    replace(integer,integerlist,integer,integerlist)

CLAUSES

    replace(_,[],_,[]).
    replace(Head,[Head|Tail],Front,[Front|Back]) if !,
        replace(Head,Tail,Front,Back).
    replace(Old,[Head|Tail],Element,[Head|Back]) if !,
        replace(Old,Tail,Element,Back).

/*
---------------------------------------------------------
PREDICATE : reverse
CATEGORY  : List
FUNCTION  : Reverse order of list
SYNTAX    : reverse(List,ResultingList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    reverse(stringlist,stringlist)
    reverse(integerlist,integerlist)

CLAUSES 

    reverse([],[]).
    reverse([Head|Tail],Reverse) if
        reverse(Tail,Temp),
        append(Temp,[Head],Reverse), !.

/*
---------------------------------------------------------
PREDICATE : cycle
CATEGORY  : List
FUNCTION  : Moves the first element to the back of a list
SYNTAX    : cycle(OriginalList,ResultingList)
CALLS     : append
---------------------------------------------------------
*/

PREDICATES

    cycle(stringlist,stringlist)
    cycle(integerlist,integerlist)
        
CLAUSES

    cycle([Head|Tail],List) if !,
        append(Tail,[Head],List).   

/*
---------------------------------------------------------
PREDICATE : split
CATEGORY  : List
FUNCTION  : Turns a string into a string list
SYNTAX    : split(String,TokenList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    split(string,stringlist)

CLAUSES

    split("",[]) if !.
    split(String,[Head|Tail]) if
        fronttoken(String,Token,Back),
        upper_lower(Token,Head), !,
        split(Back,Tail).

/*
---------------------------------------------------------
PREDICATE : subset
CATEGORY  : List
FUNCTION  : True if first list a subset of the second
SYNTAX    : subset(Subset,List)
CALLS     : member
---------------------------------------------------------
*/

PREDICATES

    subset(stringlist,stringlist)
    subset(integerlist,integerlist)

CLAUSES

    subset([Head|Tail],List) if
        member(Head,List), !,
        subset(Tail,List).
    subset([],_).

/*
---------------------------------------------------------
PREDICATE : typelist
CATEGORY  : List
FUNCTION  : Write out a list by element, one on each line
SYNTAX    : typelist(List)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    typelist(stringlist)
    typelist(integerlist)

CLAUSES

    typelist([]).
    typelist([Head|Tail]) if
        write(Head), nl, !,
        typelist(Tail).

/*
---------------------------------------------------------
PREDICATE : union
CATEGORY  : List
FUNCTION  : Unites two lists, removing duplication.
SYNTAX    : union(List1,List2,UnionList)
CALLS     : member
---------------------------------------------------------
*/

PREDICATES

    union(stringlist,stringlist,stringlist)
    union(integerlist,integerlist,integerlist)

CLAUSES

    union([],List,List).
    union([Head|Tail],List,Union) if
        member(Head,List), !,
        union(Tail,List,Union).
    union([Head|Tail],List,[Head|Union]) if !,
        union(Tail,List,Union).

/*
---------------------------------------------------------
PREDICATE : choose
CATEGORY  : List
FUNCTION  : Indexes into a list to find the Nth element.
SYNTAX    : choose(Position,List,Element)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    choose(integer,integerlist,integer)
    choose(integer,stringlist,string)
    
CLAUSES

    choose(1,[Head|_],Head) if !.
    choose(N,[_|Tail],Element) if
        N1 = N-1, !,
        choose(N1,Tail,Element).
    
/*
---------------------------------------------------------
PREDICATE : extract
CATEGORY  : List
FUNCTION  : Removes Nth element and return the element
SYNTAX    : extract(Position,List,Element,NewList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    extract(integer,integerlist,integer,integerlist)
    extract(integer,stringlist,string,stringlist)

CLAUSES

    extract(1,[Head|T],Head,T) if !.
    extract(N,[Head|Tail],Element,[Head|Back]) if
        N1 = N-1, !, extract(N1,Tail,Element,Back).
        
/*
---------------------------------------------------------
PREDICATE : insert
CATEGORY  : List
FUNCTION  : Inserts an element at indicated position
SYNTAX    : insert(Position,Element,List,NewList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    insert(integer,string,stringlist,stringlist)
    insert(integer,integer,integerlist,integerlist)
    
CLAUSES

    insert(1,Element,List,[Element|List]) if !.
    insert(N,Element,[Head|Tail],[Head|Back]) if
        N1 = N-1, !, insert(N1,Element,Tail,Back).

/*
---------------------------------------------------------
PREDICATE : mask
CATEGORY  : List
FUNCTION  : Filters one list out from another
SYNTAX    : mask(List,FilterList,NewList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    mask(stringlist,stringlist,stringlist)
    mask(integerlist,integerlist,integerlist)

CLAUSES

    mask([],_,[]) if !.
    mask([Head|Tail],List,New) if
        member(Head,List), !,
        mask(Tail,List,New).
    mask([Head|Tail],List,[Head|Back]) if !,
        mask(Tail,List,Back).

/*
---------------------------------------------------------
PREDICATE : range
CATEGORY  : List
FUNCTION  : Returns a subset of elements withing a range
SYNTAX    : range(List,LowElement,HighElement,NewList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    range(stringlist,string,string,stringlist)
    range(integerlist,integer,integer,integerlist)

CLAUSES

    range([],_,_,[]) if !.
    range([Head|Tail],Low,High,[Head|Back]) if
        Head >= Low, Head <= High, !,
        range(Tail,Low,High,Back).
    range([_|Tail],Low,High,List) if !,
        range(Tail,Low,High,List).

/*
---------------------------------------------------------
PREDICATE : minimum
CATEGORY  : List
FUNCTION  : Returns smallest element in a list
SYNTAX    : minimum(List,Element)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    minimum(stringlist,string)
    minimum(integerlist,integer)

CLAUSES

    minimum(List,Element) if !,
        qsort(List,[Element|_]).

/*
---------------------------------------------------------
PREDICATE : maximum
CATEGORY  : List
FUNCTION  : Returns largest element in a list
SYNTAX    : maximum(List,Element)
CALLS     : qsort, last
---------------------------------------------------------
*/

PREDICATES

    maximum(stringlist,string)
    maximum(integerlist,integer)

CLAUSES

    maximum(List,Element) if
        qsort(List,New), !,
        last(New,Element).

/*
---------------------------------------------------------
PREDICATE : extend
CATEGORY  : List
FUNCTION  : Returns the extend portion of longest list
SYNTAX    : extend(FirstList,SecondList,LongestList)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    extend(integerlist,integerlist,integerlist)
    extend(stringlist,stringlist,stringlist)

CLAUSES

    extend(List,[],List) if !.
    extend([],List,List) if !.
    extend([_|Tail],[_|Back],List) if !,
        extend(Tail,Back,List).

/*
---------------------------------------------------------
PREDICATE : group
CATEGORY  : List
FUNCTION  : Concatenates a list of strings, adding spaces
SYNTAX    : group(StringList,"",NewString)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    group(stringlist,string,string)

CLAUSES

    group([],New,New) if !.
    group([H|T],String,New) if
        concat(String,H,Temp),
        concat(Temp," ",Str), !,
        group(T,Str,New).


/*
---------------------------------------------------------
PREDICATE : unique
CATEGORY  : List
FUNCTION  : Removes any duplication within a list
SYNTAX    : unique(List,NewString)
CALLS     : 
---------------------------------------------------------
*/

PREDICATES

    unique(stringlist,stringlist)
    unique(integerlist,integerlist)

CLAUSES

    unique([],[]) if !.
    unique([Head|Tail],[Head|Back]) if
        not(member(Head,Tail)), !,
        unique(Tail,Back).
    unique([_|Tail],Back) if !,
        unique(Tail,Back).
