include graphics.e
include gfx_file.e
include screen.e
include image.e

cursor(NO_CURSOR)

object junk
sequence sprites,pal,map,back_colors,mon,frames,lm,t_maps
sequence p_pos,start_poses
atom back_color,p_dir,level,total_mons,lives,maps

sprites=load_gfx_file("LN_Rats.gfx")
t_maps=load_gfx_file("maps.dat")
t_maps=t_maps[2]
maps=length(t_maps)
pal=sprites[1]
sprites=sprites[2]

pal[1]={0,0,0}
junk=graphics_mode(19)
all_palette(pal/4)
atom key
key = -1

level=1
lives=5

set_screens(2)

--frames is for monsters animations
frames={{3,{5,6,7},{8,9,10}}}

sequence mmov,nmov,mche --monster movement calculation variables
mche={{0,-1},{0,11},{-1,0},{13,0}}  --pixel to check for a wall.
mmov={{0,-1},{0,1},{-1,0},{1,0}}    --positions to move to.
nmov={1,0,3,2}                      --directions to change to when turning.

back_colors={16,16,16,16,16,16,16,16,16,16}
--mon={ypos,xpos,type,direction(0=left\1=right,move dir(0=l,1=r,2=u,3=d),anim}
mon={{},{},{},{},{{5,280,1,0,0,1},{180,260,1,0,2,1}},{{5,180,1,0,0,1}},
{{35,279,1,0,0,1},{11,123,1,0,0,1},{107,298,1,0,3,1},{172,278,1,0,0,1},
{87,172,1,0,2,1},{48,71,1,0,3,1},{49,41,1,0,0,1},{80,65,1,0,0,1},
{122,34,1,0,2,1},{180,73,1,0,0,1},{20,227,1,0,0,1}},
{{25,172,1,0,0,1},{100,15,1,1,3,2}},
{{45,172,1,0,0,1},{40,110,1,0,0,1},{35,60,1,0,0,1}},{}}

start_poses={   {98,17},{30,10},{100,5},{160,5},{10,3},{10,5},{3,3},
		{18,3},{15,3},{120,5}}

function square(atom x)
    return x*x
end function

function touching(sequence a , sequence b )   --find if object b is touching
atom dist
    dist=sqrt(square(a[1][1]-b[1][1])+square(a[1][2]-b[1][2]))
    if (dist-a[2])-b[2]<=0 then
	return 1
    else
	return 0
    end if
end function

procedure win()
    junk=graphics_mode(-1)
    puts(1,"Congratulations! You have won.\nPress enter to exit.\n")
    puts(1,"\nI hope you enjoyed this demo of:\n")
    puts(1,"Liquid-Nitrogen Rat Land!\n\n")
    puts(1,"I bet you just cant wait for the full version,\n")
    puts(1,"complete with level editor and monster designer!\n")
    puts(1,"Scrolling screens and multiple screen exit points!\n\n")
    puts(1,"Look soon also for WULF - an Isometric role playing game\n")
    puts(1,"Also by LN software.\n")
    
    while get_key() !=13 do end while --wait for user to press enter
    abort(0)
end procedure

procedure load()
    if level>maps then
	win()
    end if
    lm=mon[level]
    total_mons=length(lm)
    map=t_maps[level]
    map[1][1..320]=0
    p_pos=start_poses[level]
    p_dir=0
    back_color=back_colors[level]
    fdisplay({0,0},map,2)
    screen_copy(1,2)
    if level=10 and lives > 3 then
	lives=3
    end if
end procedure



procedure play()
atom jump
atom fall,dead
sequence jumped,slide
dead=0
fall=0
--level=level-1
if level=0 then
    level=1
end if
jump=0
jumped={0,0}
slide={0,0}
key = -1

load()
while key != 27 do
    key=get_key()
    screen_copy(1,2)
    if jump then
	if map[p_pos[1]-1][p_pos[2]+9] != back_color and
	map[p_pos[1]-1][p_pos[2]+4] != back_color then
	    jump=0
	else
	    p_pos[1]=p_pos[1]-1
	    if map[p_pos[1]-1][p_pos[2]+9] != back_color and
	    map[p_pos[1]-1][p_pos[2]+4] != back_color then
		jump=0
	    else
		p_pos[1]=p_pos[1]-1
	    end if
		jump=jump-1
	end if
    end if
    
    if jump=0 and map[p_pos[1]+14][p_pos[2]+4] = back_color and
    map[p_pos[1]+14][p_pos[2]+8] = back_color then
	fall=fall+1
	p_pos[1]=p_pos[1]+1
	if map[p_pos[1]+14][p_pos[2]+4] = back_color and
    map[p_pos[1]+14][p_pos[2]+8] = back_color then
	    fall=fall+1
	    p_pos[1]=p_pos[1]+1
	end if
    else
	if fall>79 then
	    dead=1
	end if
	if find(0,map[p_pos[1]+14][p_pos[2]+4..p_pos[2]+8]) then
	    dead=1
	end if
	    junk = map[p_pos[1]+14][p_pos[2]+4..p_pos[2]+8]
	    for j = 1 to length(junk) do
		if junk[j] != 16 then
		    jumped={0,0}
		    exit
		end if
	    end for
	    slide={0,0}
	    for j = 1 to length(junk) do
		if junk[j] = 222 or junk[j] = 221 then
		    slide={1,p_dir}
		    exit
		end if
	    end for
	if slide[1] then
	    --------------**************
	    if not slide[2] then
		slide[1]=slide[1]-1
		if map[p_pos[1]+13][p_pos[2]+9] = back_color then
		    p_pos[2]=p_pos[2]+1
		end if
	    else
		slide[1]=slide[1]-1
	    if map[p_pos[1]+13][p_pos[2]+4] = back_color then
		p_pos[2]=p_pos[2]-1
		if p_pos[2]<0 then
		    p_pos[2]=0
		    slide={0,0}
		end if
		end if
	    end if

	end if
	fall=0
    end if
    if key = 328 and jump = 0 and
    (map[p_pos[1]+14][p_pos[2]+4] != back_color or
     map[p_pos[1]+14][p_pos[2]+8] != back_color) then
	jump=20
    end if
    if key = 333 then
	p_dir=0
	if jump and jumped[1]=0 then
	    jumped={30,1}
	else
	    if map[p_pos[1]+13][p_pos[2]+9] = back_color then
		p_pos[2]=p_pos[2]+1
		if map[p_pos[1]+13][p_pos[2]+9] = back_color then
		    p_pos[2]=p_pos[2]+1
		end if
	    elsif map[p_pos[1]+12][p_pos[2]+9] = back_color then
		p_pos=p_pos+{-1,1}
	    end if
	end if
    end if
    if key = 331 then
	p_dir=1
	if jump and jumped[1]=0 then
	    jumped={30,0}
	else
	    if map[p_pos[1]+13][p_pos[2]+4] = back_color then
		p_pos[2]=p_pos[2]-1
		if map[p_pos[1]+13][p_pos[2]+4] = back_color then
		    p_pos[2]=p_pos[2]-1
		end if
	    elsif map[p_pos[1]+12][p_pos[2]+4] = back_color then
		p_pos=p_pos-{1,1}
	    end if
	    if p_pos[2]<0 then
		p_pos[2]=0
	    end if
	end if
    end if
    if jumped[1] then
	    if jumped[2] then
		jumped[1]=jumped[1]-1
		if map[p_pos[1]+13][p_pos[2]+9] = back_color then
		    p_pos[2]=p_pos[2]+1
		end if
	    else
		jumped[1]=jumped[1]-1
	    if map[p_pos[1]+13][p_pos[2]+4] = back_color then
		p_pos[2]=p_pos[2]-1
		if p_pos[2]<0 then
		    p_pos[2]=0
		    jumped={0,0}
		end if
		end if
	    end if
    end if
    if p_pos[2]>308 then
	level=level+1
	load()
    end if

    if total_mons>0 then--move, display and act monsters.
	for i = 1 to total_mons do
	    junk = lm[i][1..2]+mche[lm[i][5]+1]
	    if junk[2]>319 or junk[2]<1 then
		junk=0
		lm[i][5]=nmov[lm[i][5]+1]
		if lm[i][5]<2 then
		    if lm[i][4]=0 then
			lm[i][4]=1
		    else
			lm[i][4]=0
		    end if
		end if
	    end if
	    if sequence(junk) then
		if map[junk[1]][junk[2]] != back_color then
		    lm[i][5]=nmov[lm[i][5]+1]
		    if lm[i][5]<2 then
			if lm[i][4]=0 then
			    lm[i][4]=1
			else
			    lm[i][4]=0
			end if
		    end if
		else
		    lm[i][1..2] = lm[i][1..2]+mmov[lm[i][5]+1]
		    lm[i][6]=lm[1][6]+1
		    if lm[i][6]>frames[lm[i][3]][1] then
			lm[i][6]=1
		    end if
		end if
	    end if
	end for
	
	for i = 1 to total_mons do
display(lm[i][1..2],sprites[frames[lm[i][3]][lm[i][4]+2][lm[i][6]]],1)
		
	end for
	    for i = 1 to total_mons do
		if touching({p_pos+{6,6},6},{lm[i][1..2]+{6,6},6}) then
		    dead = 1
		end if
	    end for
    end if
    if dead=0 then
	display_clip(p_pos,sprites[1+p_dir],1)
    for i = 1 to lives do
	display({3,20*i-16},sprites[4],1)
    end for
	poke_screen(1)
    else
	display_clip(p_pos+{1,0},sprites[3],1)
    for i = 1 to lives do
	display({3,20*i-16},sprites[4],1)
    end for
	poke_screen(1)
	key=27
    end if
end while
end procedure


procedure demo()
atom t
junk=pal
pal=repeat({0,0,0},256)
CLS(1)
all_palette(pal/4)
display({50,60},sprites[11],1)
poke_screen(1)
t=time()
while time()-t<1 do end while
for q = 1 to 256 do
for i = 1 to 256 do
    for x = 1 to 3 do
	if pal[i][x]<junk[i][x] then
	    pal[i][x]=pal[i][x]+1
	end if
    end for
end for
all_palette(pal/4)
end for
for q = 1 to 256 do
for i = 1 to 256 do
    for x = 1 to 3 do
	if pal[i][x]>0 then
	    pal[i][x]=pal[i][x]-1
	else
	    pal[i][x]=0
	end if
    end for
end for
all_palette(pal/4)
end for

CLS(1)
poke_screen(1)
pal=junk
junk={}
all_palette(pal/4)

end procedure

demo()

atom off        
off=0
fdisplay({0,0},sprites[14],1)
poke_screen(1)
while key !=27 do   --main loop
    if not off then
	if lives<5 then
	    display({80,50},sprites[12],1)
	    poke_screen(1)
	else
	    display({80,60},sprites[13],1)
	    poke_screen(1)
	end if
	off=1
    end if
    key=get_key()
    if key = 13 then
	play()
	key = -1
	off=0
	lives=lives-1
	if lives=0 then
	    level=1
	    lives=5
	end if
    end if
end while

junk=graphics_mode(-1)
