-----------------------------------------------------------------------------
-- MaZeR DeMonSTraTiON By Ralf Nieuwenhuijsen for Micheal Packard

-- This is a special demonstration program for Micheal Packard, 
--      how to implend ascII maze with the MaZeR (version 2 needed!)

-- This demonstartion program consist of a few easy routines, and a demo 
--      routine, which will be called at the end of the source.

-- See 'simple.txt' for a simple explenation how to call mazer...
-----------------------------------------------------------------------------
-- Routines describtions

-- display_ascII_maze ( sequence ) 
--          Displays text_image. 

-- sequence  = make_ascII_maze (int wl, int sp, seq pos, seq opt) 
--          Returns ascII maze with char wl as line/wall char and char sp as 
--              as the character used for the space between the walls.
--          For pos you must give a sequence with the {width , height}
--              of the sequence you want him to return.
--              (WARNING THE WIDTH & HEIGHT WILL BE ONE MORE!!)
--              (This is because you need borders on all sides!!)

-- demo () 
--          Demonstrates the use of the above two!!
--          Calls make_ascII_maze with different flavours, and 
--              displays them using display_ascII_maze. 
--          This character is used for the lines : 'X'
--          This character is used for the spaces : ' '

-----------------------------------------------------------------------------
-- What are you supposed to say when someone goes through this trouble for
--      you ???                                                 
                      
-----------------------------------------------------------------------------                         
-- Includes...

    include mazer.e                -- so i can use mazer()
    include get.e                  -- so i can use wait_key()
    include flavours.e             -- flavours routines

-----------------------------------------------------------------------------
-- AscII routines...

    -- Displays the text_image of ascII_data
procedure display_ascII_maze (sequence ascII_data)
    position (1,1)
    for j = 1 to length(ascII_data) do
        puts(1,append(ascII_data[j],'\n'))    -- Add line from 'picture'+'\n'
    end for
end procedure

    -- Makes an ascII maze using mazer    
function make_ascII_maze(integer wl, integer sp, sequence pos, sequence opt)
sequence ret
    ret = mazer(pos,opt)

    for y = 1 to length(ret) do
        for x = 1 to length(ret[y]) do
           if ret[y][x] = 0 then ret[y][x] = sp else ret[y][x] = wl end if
        end for
    end for    
    
    return ret
end function

-----------------------------------------------------------------------------
-- Demonstartion routine...

procedure demo ()
sequence my_maze        
integer nothing
    
    while 1 do
        my_maze = make_ascII_maze('',' ',{76,20},flv_die_hard(2,{20,10},1))
        display_ascII_maze (my_maze)
        puts (1, "Die Hard AscII Maze by Ralf Nieuwenhuijsen <-> Enter - Next <-> Space - ReMaZe")
        if not (wait_key() = ' ') then exit end if               
    end while                                
    
    clear_screen ()
    
    while 1 do
        my_maze = make_ascII_maze('',' ',{76,20},flv_castle(2,{20,10},1))
        display_ascII_maze (my_maze)
        puts (1, "Castle AscII Maze by Ralf Nieuwenhuijsen <-> Enter - Next <-> Space - ReMaZe")
        if not (wait_key() = ' ') then exit end if               
    end while                                               
    
    clear_screen ()
    
    while 1 do
        my_maze = make_ascII_maze('',' ',{76,20},flv_fort(5,{20,10},1))
        display_ascII_maze (my_maze)
        puts (1, "Fort AscII Maze by Ralf Nieuwenhuijsen <-> Enter - Next <-> Space - ReMaZe")
        if not (wait_key() = ' ') then exit end if               
    end while         
    
    clear_screen ()
    
    while 1 do
        my_maze = make_ascII_maze('',' ',{76,20},flv_game(2,{20,10},1))
        display_ascII_maze (my_maze)
        puts (1, "Game AscII Maze by Ralf Nieuwenhuijsen <-> Enter - Next <-> Space - ReMaZe")
        if not (wait_key() = ' ') then exit end if               
    end while      
                             
    clear_screen ()
        
    while 1 do
        my_maze = make_ascII_maze('',' ',{60,18},flv_zone(2,{20,10},1))
        display_ascII_maze (my_maze)
        puts (1, "Zone AscII Maze by Ralf Nieuwenhuijsen <-> Enter - Next <-> Space - ReMaZe")
        if not (wait_key() = ' ') then exit end if               
    end while                                
                      
    clear_screen ()
        
    while 1 do
        my_maze = make_ascII_maze('',' ',{76,20},flv_fbi(2,{20,10},1))
        display_ascII_maze (my_maze)
        puts (1, "FBI AscII Maze by Ralf Nieuwenhuijsen <-> Enter - Next <-> Space - ReMaZe")
        if not (wait_key() = ' ') then exit end if               
    end while        
    
    clear_screen ()
        
    while 1 do
        my_maze = make_ascII_maze('',' ',{76,20},flv_tombes(2,{20,10},1))
        display_ascII_maze (my_maze)
        puts (1, "Tombes AscII Maze by Ralf Nieuwenhuijsen <-> Enter - Next <-> Space - ReMaZe")
        if not (wait_key() = ' ') then exit end if               
    end while                                

end procedure
-----------------------------------------------------------------------------                                                          
demo ()
        
        

