MODULE CANNIBAL;
(* PROGRAMA PASCAL (c) 1979 by martin tracy  *)
(* translated by steve gibson  1988          *)
(* FST Modula-2 December 17,1988             *)
(* Oberon-M      December 1992               *)

IMPORT IO, Screen;

CONST Bs=08; Cr=13;
    (* persona *)
      Can1=1;
      Can2=2; Hun1=3; Hun2=4;
      Doctor=5; Nurse=6;  Mis1=7; Mis2=8; Mis3=9;
    (* health status *)
        Fine=0; Mina=1; Maja=2; Minu=3; Maju=4; Dead=5;
    (* other consants *)
        Near=0; Far=1;
         Empty=FALSE;
          Full=4; ALL=9;
VAR Canoe, Ngoing,SinkRate:INTEGER;
    Quit,Continue:BOOLEAN;
    Shore:ARRAY 10 OF INTEGER;
    Health,Paddle:ARRAY 10 OF INTEGER;
    Hfactor:ARRAY 7 OF INTEGER;
    Move:ARRAY 5 OF INTEGER;

PROCEDURE Pname(player:INTEGER); (* print name *)
BEGIN
     CASE player OF
      Can1,Can2:IO.WS("CANNIBAL ");IO.WI(player-Can1+1) ;
|     Hun1,Hun2:IO.WS("HUNTER ");  IO.WI(player-Hun1+1);
|     Doctor:IO.WS("DOCTOR ") ;
|     Nurse:IO.WS("NURSE ")    ;
|     Mis1,Mis2,Mis3:IO.WS("Missionary ");IO.WI(player-Mis1+1);
|     ELSE
     IO.WS("pname error ");
     END ;
   END Pname;

PROCEDURE Setup; (* initialize variable *)
VAR i:INTEGER ;ch:CHAR;
BEGIN
     Canoe:=Near; Ngoing:=0;
     i:=1;
     REPEAT
         Health[i]:=Fine; Shore[i]:=Near;
         INC(i);
       UNTIL i = ALL  ;
       i:=1;
       REPEAT
          Move[i] := 0;
       INC(i);
       UNTIL i=4;
        SinkRate:=22;
         Hfactor[0]:=10;
         Hfactor[1]:=9;
         Hfactor[2]:=9;
         Hfactor[3]:=8;
         Hfactor[4]:=7;
         Hfactor[5]:=0;
         Hfactor[6]:=0;
         Paddle[1]:=12;
        Paddle[2]:=12;
        Paddle[3]:=9;
        Paddle[4]:=9;
        Paddle[5]:=7;
        Paddle[6]:=5;
        Paddle[7]:=4;
        Paddle[8]:=4;
        Paddle[9]:=4;
         IO.WS("HELLO GAMER  WELCOME TO THE OLD GAME OF CANNIBALS");
         IO.WL;
         
         IO.WS("NOW IMPLEMENTED IN OBERON-M ");
         IO.WS("AS A DEMOSTRATION PROGRAM");
         IO.WL;
         IO.WS("(c) 1988 S.A. Gibson ");
         IO.WL;
         IO.WS("and placed in the public domain ");
         IO.WL;
         IO.WL;IO.WL;
         IO.WS("Your goal is to get the party across the River");
         IO.WL;
         IO.WS("with only one canoe and a River full of pirahna.");
         IO.WL;IO.WL;
         IO.WS("hit any key to start ");IO.RCh(ch);
         IO.WL; IO.WL; IO.WL; IO.WL; IO.WL;
         IO.WL;
END Setup;

PROCEDURE Tab(position:INTEGER);
BEGIN
Screen.MoveCursor(20,position-1);
END Tab;

PROCEDURE Delay(p:LONGINT);
VAR i:LONGINT;
BEGIN
i:=1;
REPEAT
i:=i+1;
UNTIL i=p;
END Delay;

PROCEDURE Random(lo,hi:INTEGER):INTEGER; (* PICK A NUMBER FROM LO TO HI *)
VAR rnd:INTEGER;
BEGIN
  RETURN 3;
RETURN rnd
END Random;

PROCEDURE StillPlaying():BOOLEAN ; (* anyone alive on near shore ? *)
VAR i:INTEGER;
BEGIN
 
   i:=1;
   REPEAT
      IF (Shore[i] = Near )      THEN
      IF  (Health[i] <Dead)    THEN
      RETURN  TRUE;
      END;
      ELSE
      RETURN  TRUE;
      END;  
      INC(i);
   UNTIL i =ALL;
END StillPlaying;

PROCEDURE InCanoe(p:INTEGER); (* in canoe ? *)
VAR i:INTEGER;
BEGIN
     i:=1;
     REPEAT
          IF Move[i] = p THEN
             IO.WS(" (in canoe) ");
          END;
         INC(i);
      UNTIL i=ALL    ;
END InCanoe;

PROCEDURE Status; (* print game status *)
VAR p:INTEGER;
BEGIN
IO.WL;IO.WL;
      
         p:= 1 ;
        REPEAT
           Pname(p); IO.WS("   ");
           CASE Health[p] OF
                 Fine: IO.WS("ok") |
              | Mina: IO.WS("Healing") |
              |  Maja: IO.WS("unwell") |
              |  Minu: IO.WS("wounded") |
              |  Maju: IO.WS("dying") |
              |  Dead: IO.WS("Dead") ;
            |ELSE
          END; (* CASE *)
        IO.WS("  ");
        INC(p);
             UNTIL p =ALL;
                IO.WL;
   IO.WS("NEAR SHORE");IO.WS("                   ");IO.WS("FAR SHORE");
   IO.WL;IO.WL;
     
      p:= 1 ;
      REPEAT
      IF Shore[p] = Far THEN
         IO.WS("                              ");Pname(p);
        InCanoe(p);
      ELSE
       Pname(p);
       InCanoe(p);
      END; 
     IO.WL;
      INC(p);
      UNTIL p = ALL;
      IF Canoe = Far THEN
       IO.WS("                                "); IO.WS("canoe");
       IO.WL;IO.WL
       ELSE        IO.WL;  IO.WS("canoe"); IO.WL;IO.WL
        END;
END Status;

PROCEDURE WhosGoing; (* prepare trip *)
CONST bye=0;go=1;out=2;stat=3;can=4;hun=5;doc=6;nur=7;mis=8;ques=9;
VAR com,i:INTEGER;ch:CHAR;done:BOOLEAN;

    PROCEDURE Enter(p:INTEGER); (* player enters canoe *)
              VAR i  :INTEGER;
                  dup:BOOLEAN;
              BEGIN
                dup:=FALSE;
                i:=1 ;
                REPEAT
                 IF p=Move[i]              THEN 
                    dup:=TRUE;
                END     ;  (* IF THEN *)
                INC(i);
                UNTIL i>Ngoing;
                IF dup = TRUE THEN
                    IO.WS(" Already in Boat ");
                ELSE
                  IF Shore[p] = Canoe THEN
              
                  IF Ngoing=Full THEN IO.WS("Canoe Full")
                  ELSE 
                  Ngoing :=Ngoing+1;
                  Move[Ngoing]:= p;
                  IO.WS("   ") ;
                  Pname(p);
                  IO.WS("  enters canoe ") ;
               END;
               ELSE
               IO.WS(" On other side");
                END;
                END;
           END Enter;
   PROCEDURE GetCommand(ch:CHAR):INTEGER;
   BEGIN
     IF CAP(ch)="P" THEN RETURN 1 
     ELSIF CAP(ch)="U" THEN RETURN 2
     ELSIF CAP(ch)="S" THEN RETURN 3
     ELSIF CAP(ch)="C" THEN RETURN 4
     ELSIF CAP(ch)="H" THEN RETURN 5
     ELSIF CAP(ch)="D" THEN RETURN 6
     ELSIF CAP(ch)="N" THEN RETURN 7
     ELSIF CAP(ch)="M" THEN RETURN 8
     ELSIF CAP(ch)="Q" THEN RETURN 9
     ELSE RETURN 9 END;
   END GetCommand;

BEGIN
   done:= FALSE;
   Screen.MoveCursor(23,1);
   IO.WL;
   IO.WS(" Enter your instructions: ");
   REPEAT
     IO.WL;
     IO.WS("COMMAND: ");
     IO.RCh(ch);
     IO.WL;
     ch:= CAP(ch);
     com:=GetCommand(ch);
     CASE  com OF
    go:
         IF (Ngoing = 0)
         THEN
         IO.WS(" Nobody to Paddle");
         IO.WL
         ELSE done:= TRUE
         END   |
|    out:(* unload *)
         Ngoing := 0;
         i:=0;
         REPEAT
         INC(i);
         Move[i]:=0;
         UNTIL i = Full;
         IO.WS(" Canoe Emptied ");
         IO.WL  ;
 |  stat: (* Print Status *)
            Status; IO.WL;
            IO.WS("move") |
 |   can:      IO.WS("which cannibal? ");IO.RCh(ch) ;      (* cannibal *)
             i:=(ORD(ch)-ORD("0")); 
             Enter(Can1+i-1);
 |  hun:     IO.WS("which hunter? ");IO.RCh(ch);          (* hunter *)
             i:=(ORD(ch)-ORD("0")) ;
             Enter(Hun1+i-1);
 | doc:      Enter(Doctor);
 | nur:      Enter(Nurse);
 | mis:   IO.WS("which missionary? ");IO.RCh(ch);     (* missionary *)
           i:=(ORD(ch)-ORD("0")) ;
           Enter(Mis1+i-1);
 |ques:  IO.WS("S)tatus, U)nload canoe, P)addle ");IO.WL;
          IO.WS(" D)octor board canoe, H)unter, N)urse), C)annibal) ");
         IO.WS("M)issionary), Q)uit or help  ");IO.WL ;
         IO.WS("quit? ") ; IO.RCh(ch); 
          IF ch = "y" THEN
           Quit:=TRUE; 
           END;
 |     ELSE;
           IF (ch = ",") THEN
           ELSE
             IO.WS(" Huh ? ");
            END;
            END;
     UNTIL (done OR (CAP(ch) = "Y"));
END WhosGoing;

PROCEDURE Trip; (* cross the river *)
CONST river=100; Swamped=100;
VAR i,speed,distance,Water:INTEGER;
    Stop,afloat:BOOLEAN;

    PROCEDURE Swim(p:INTEGER);   (* player p swims *)
    BEGIN
    Delay(11500);
    IF Health[p] = Dead     THEN Pname(p);
      IO.WS(" Floats, Ashore");
       IO.WL;
    ELSE
          IF Random(0,1) = 1     THEN
              Pname(p);
               IO.WS(" Makes it.");
              IO.WL;
          ELSE IO.WS("BYTE!! BYTE !! ");
               Pname(p);
          END;
     END;
       IF   Random(0,2)=0        THEN 
       ELSE
            IF Health[p] < Maju THEN 
                  Health[p] := Maju
             END;
           IF Health[p] = Minu THEN
                   IO.WS(" is Slightly wounded ");
                  IO.WL
           END;
       END;
        IO.WS(" is badly eaten"); IO.WL;
     
    
    CASE Health[p] OF
      Fine,Mina:Health[p]:=Minu 
  |        Maju:Health[p]:=Maju;
  | ELSE
         END;
     IF Health[p] < Maju THEN Health[p] := Maju
     END;
         IF Health[p] = Minu THEN IO.WS(" is Slightly wounded ");
         IO.WL
         ELSE    IO.WS(" is badly eaten"); IO.WL
         END; 


    END Swim;

    PROCEDURE Capsize; (* canoe capizes! *)
    VAR p:INTEGER;
    BEGIN
      Delay(11000);
      IO.WS(" Capsize!!! everybody swim ashore fast!! ");
      IO.WL;
       p:=1 ;
      REPEAT
        Swim(Move[p]);
        afloat:=FALSE;
       INC(p);
       UNTIL p=Ngoing;
    END Capsize;

    PROCEDURE OneFish; (* fish jumped in canoe *)
     VAR p:INTEGER;
     BEGIN
     IO.WS(" A pirana has jumped into the canoe near !" );
     p:= Move[Random(1,Ngoing)];
     Pname(p);
     IO.WS(" . ");
     IO.WL;
     IF Health[p]=Dead THEN
     IO.WS(" Oh well, he is dead anyway");
     IO.WL;
     ELSE
     CASE p OF
     Can1,Can2:IO.WS("He spears the fish,  but holes the canoe!");
               IO.WL ;
               SinkRate:=SinkRate+SinkRate DIV 8 |
|     Hun1,Hun2,Doctor:IF Random(0,1) = 1
                  THEN IO.WS(" he kicks it out of the canoe. ");
                    IO.WL;
                  ELSE IO.WS(" He panicks!     He is rocking the booooat!!");
                  IO.WL; Capsize;  END |
 |   Nurse:IO.WS(" She panicks! ");IF Random(0,2) = 2 THEN
              IO.WS(" but finally sits down.");
              IO.WL;
              ELSE IO.WS(" and falls overboard! ");
              IO.WL;
              Swim(Nurse);
              END  |
    |   Mis1,Mis2,Mis3:IO.WS(" He remains calm. ");
                    IO.WL;
    |ELSE;
             END; (* case *)
            END; (* IF THEN *)

    END OneFish;

BEGIN
        afloat := TRUE ;
        speed:=0;
        distance := 0;
        Water := 0;

        i:= 0 ;
       REPEAT
         INC(i);
          speed := speed+Paddle[Move[i]]* Hfactor[Health[Move[i]]];
          speed:= speed DIV (4*Ngoing); (* yards /unit time *)
          IO.WL;
          IO.WS(" Paddle! " );
          Delay(11100);
          IO.WL;
        
        UNTIL i=Ngoing;
        REPEAT Delay(11000);
        
          Water := Water+SinkRate;
          IF Water >= Swamped           THEN
             IO.WS(" Boat is swamped...");
             IO.WL;
             Capsize;
          END;
          distance := distance+speed;
          IF afloat THEN
             IO.WL;
             IO.WS(" Canoe has ");
             IO.WI(river-distance);
             IO.WS(" yard to go");
              IO.WL;
             IO.WS(" and is ");
             IO.WI(Water);
             IO.WS(" % full of water");
             IO.WL;
             IF Random(1,4)= 1 THEN 
                OneFish
             END;
            END;
       IF   afloat  THEN
       IF  (distance+speed>= river) THEN
             Stop := TRUE
       ELSE
            Stop := FALSE
       END
       ELSE
            Stop := TRUE;
       END;
     UNTIL Stop ;       
         i := 0; (* made it *)
        REPEAT
        INC(i);
       Shore[Move[i]] := 1-Shore[Move[i]] ;
       
       UNTIL i=Ngoing;
        Canoe:= 1 - Canoe;
         Ngoing:=0;
         Delay(1000);
          IO.WL;
         IF  Canoe = Near THEN
         IO.WS("NEAR ")
         ELSE IO.WS("FAR")
         END;  (* IF THEN *)
         IO.WS(" Shore is Reached ! ");
         IO.WL;


END Trip;

PROCEDURE ShoreActs; (* attend the wounded *)
CONST attention=2;
VAR p:INTEGER;
BEGIN
  Delay(1000);
  
  
 p:=1 ;
  REPEAT
                IF (Shore[p]=Shore[Doctor]) THEN
                IF (Health[Doctor]<Maju) THEN
                IF (Health[Doctor]>Minu) THEN
                IF (Health[p] =  Minu) THEN
                IF (Health[p] =Maju) THEN
                                   Health[p]:=Health[p] - attention;
                                        Pname(p);
                                        IO.WS(" attended by DOCTOR ");
                                        IO.WL; 
                      END; 
                   END; 
               END; 
                  END; 
             END; 

                IF (Shore[p]=Shore[Nurse]) THEN
                IF (Health[Nurse]<Maju) THEN
                IF (Health[Nurse]>Minu) THEN
                IF (Health[p] =  Minu) THEN
                                   Health[p]:=Mina;
                                        Pname(p);
                                        IO.WS(" attended by Nurse ");
                                        IO.WL
                                                                  ELSE
                IF (Health[p]=Maju) THEN
                IF (Shore[Doctor] = Shore[Nurse]) THEN
                  IF (Health[Doctor]<Dead)   THEN
                                   Health[p]:=Maja;
                                        Pname(p);
                                        IO.WS(" attended by Nurse ");
                                        IO.WL; 
                                      END;
                                    END;
                                     END;
                                      END;
                                        END;
                                          END;
                                      END;
                IF (Health[p]<Fine) THEN
                IF (Random(0,2)=2) THEN 
                IF (Health[p]=Minu) THEN
              IF (Health[p]=Maju) THEN
                       Pname(p);
                       IO.WS(" is much worse");
                       Health[p]:=Health[p]+1;
                       IF Health[p]=Dead
                       THEN IO.WS(" ...in fact Dead! ");
                       IO.WL;
                       END; END;
                         END; END;
                           END;
          INC(p);             
    UNTIL p=ALL  ;                 
   END ShoreActs;


PROCEDURE WrapUp; (* Tally Score *)
VAR s,p:INTEGER;
BEGIN
        s:=1000; (* perfect score *)
         p:=1 ;
        REPEAT
                CASE Health[p] OF
                Dead: s:=s-100 |
              |  Maju: s:=s-30 |
              |  Minu: s:=s-10;
                |ELSE;
                        END;
           INC(p); UNTIL p=ALL;
   Screen.MoveCursor(23,1);IO.WL;IO.WL;
   IO.WS("your Score is ");IO.WI(s);
   IO.WL;

END WrapUp;

BEGIN  (* main program begins here *)
  Setup;
  Continue :=StillPlaying();
  Quit:=FALSE;
   Status;
  IO.WS("S)tatus, U)nload canoe, P)addle ");IO.WL;
          IO.WS(" D)octor board canoe, H)unter, N)urse), C)annibal) ");
         IO.WS("M)issionary), Q)uit or help  ");IO.WL ;
      IO.WS("example: d h1 .  doctor & hunter board canoe");
      IO.WL;
      IO.WS("and start trip");IO.WL;
  WHILE Continue       DO
    WhosGoing;

    IF  Quit THEN
    Continue:=FALSE
    ELSE
    Trip;
    ShoreActs;
    Status;
    
    END; END;
  WrapUp;
  IO.WL;
IO.WS("thanks for playing with the cannibals ");
IO.WL;
END CANNIBAL.
(*  IT HAS EVOLVED THROUGH MANY LANGUAGE VERSIONS");
     ("AS A DEMOSTRATION PROGRAM");
     "NOW IMPLEMENTED IN MODULA-2");
     ("Your goal is to get the party across the River");
     ("with only one canoe and a River full of pirahna.");
   one remaining source of problems is the case of  dead occupants of
   the canoe. The module will not at present detect the fact that there is
   no one to paddle.
     December 17, 1988                                         *)


