MODULE Star1;
        (* ----------------------------------------------------*)
        (*              S  T  A  R  S                           *)
        (* ----------------------------------------------------  *)
        (*      THIS VERSION OF STARS    IS COURTESY OF       *) 
 IMPORT IO, Box, Screen;
 
VAR     position:ARRAY 11,3 OF INTEGER;

PROCEDURE Docs(it:INTEGER);
BEGIN
CASE it OF
 0: IO.WS("LUNAR LANDING SIMULATION                            "     ); 
 |1: IO.WS("SEC  FEET   SPEED    FUEL       PLOT OF DISTANCE        ");
 |2: IO.WS( "TOUCHDOWN AT 44 SECONDS                               " );
 |3: IO.WS("LANDING VELOCITY= 10 FT/SEC                             ");
 |4: IO.WS("YOU ARE LANDING ON THE MOON, YOUR HAVE HAD TO");
 |5: IO.WS("ABORT YOUR AUTOMATIC LANDING PLAN AND HAVE TAKEN");
 |6: IO.WS("OVER MANUAL CONTROL 500 FT. OVER A GOOD LANDING");
 |7: IO.WS("SPOT. YOU ARE FALLING AT 50 FT/SEC, WITH 120 LBS");
 |8: IO.WS("OF FUEL TOTAL; DEPLETED AS FOLLOWS:                 ");
 |9: IO.WS("(1) AFTER EACH SECOND, THE HEIGHT,VELOCITY AND");
 |10: IO.WS("REMAINING FUEL WILL BE REPORTED.                  " );
  |11: IO.WS("(2) NEXT, A/?/ WILL BE TYPED. ENTER THE NUMBER");
 |12: IO.WS("OF LBS OF FUEL YOU WISH TO BURN DURING THE NEXT");
 |13: IO.WS("SECOND. EACH LB BURNED WILL SLOW THE DESCENT BY");
 |14: IO.WS("1 FT/SEC. 5 LBS OF FUEL WILL MAINTAIN YOUR CUR-");
 |15: IO.WS("RENT VELOCITY EXACTLY.                             ");
 |16: IO.WS("(3) MAXIMUM THRUST YOUR ENGINE CAN SUSTAIN IS       ");
 |17: IO.WS("30 FT/SEC OR 30 LBS OF FUEL/SEC.                    ");
 |18: IO.WS( "(4) WHEN YOU CONTACT THE LUNAR SURFACE, YOUR       ");
 |19: IO.WS("DESCENT ENGINE WILL AUTO-SHUT OFF AND YOU WILL      ");
 |20: IO.WS("BE GIVEN A READOUT OF LANDING CONDITIONS.           ");
 |21: IO.WS("(5) IF OUT OF FUEL, ONLY REPORTS UNTIL              ");
 |22: IO.WS("YOU CONTACT THE LUNAR SURFACE                        ");
 |23: IO.WS("ALERT! ALERT! DESCENT PROCEEDURE INITIATED!            ");
 |24: IO.WS( "HINT; NO BURN TILL SECOND # 4                        ");
 |25: IO.WS( "HINT; YOU BURNED LATE FOR A NOVICE                    ");
 |26: IO.WS("SEC  FEET   SPEED    FUEL       PLOT OF DISTANCE        ");
 |27: IO.WS( "TOUCHDOWN AT 44 SECONDS                               " );
 |28: IO.WS("LANDING VELOCITY= 10 FT/SEC                             ");
 |29: IO.WS( "CONGRATULATIONS! A PERFECT LANDING                      ");
 |30: IO.WS("YOU HAD TO TRY FOR THAT! DO IT RIGHT                      ");
 |31: IO.WS(";   SCORE =                                               ");
 |32: IO.WS("NEARLY PERFECT: YOU MUST TRY AGAIN!                       ");
 |33: IO.WS("                    ----                                  ");
 |34: IO.WS( "GOOD.  ( YOU COULD WALK AWAY FROM IT )                    ");
 |35: IO.WS("ABOUT LIKE HITTING THE WALL RUNNING HARD.                 ");
 |36: IO.WS("OUCH! THAT HURT! ( THE LANDER )                           ");
 |37: IO.WS("PUH-LEEEZE!  MY SOUFFLE'!                                ");
 |38: IO.WS( " YOU SHOULD REREAD THIS:   FOR EACH                     ");
 |ELSE
 END;
END Docs;

PROCEDURE InitStar(x,y,num:INTEGER);
BEGIN
Screen.MoveCursor(24,60);
IO.WI(x);IO.WI(y);
position[num,0]:=x;
position[num,1]:=y;
Screen.MoveCursor(x,y);
IO.Wch(".");
END InitStar;

PROCEDURE MoveStar(num:INTEGER);
VAR x,y:INTEGER;
BEGIN
Screen.MoveCursor(24,70);
IO.WI( position[num,0]) ;IO.WI(position[num,1]);
Screen.MoveCursor( position[num,0],position[num,1]);
IO.Wch(" ");
IF position[num,0] < 11 THEN
IF position[num,1] < 40 THEN
  position[num,0]:=position[num,0]-1; 
  position[num,1]:=position[num,1]-2; 
  ELSE
  position[num,0]:=position[num,0]-1; 
  position[num,1]:=position[num,1]+2; 
  END;
  ELSE
  IF position[num,1] < 40 THEN
  position[num,0]:=position[num,0]+1; 
  position[num,1]:=position[num,1]-2; 
  ELSE
  position[num,0]:=position[num,0]+1; 
  position[num,1]:=position[num,1]+2; 
  END;
  END;
  x:=position[num,0]; 
  y:=position[num,1];
  CASE x OF
  2: position[num,0]:=y MOD 20; 
    IF y > 39 THEN
       position[num,1]:=41;
        ELSE
       position[num,1]:=39;
       END;
  |22: position[num,0]:=y MOD 20+3; 
    IF y > 39 THEN
       position[num,1]:=41;
       ELSE
       position[num,1]:=39;
       END;
  |ELSE
  CASE y OF
  1: position[num,1]:=x * 20; 
    IF x > 10 THEN
       position[num,0]:=11;
       ELSE
       position[num,0]:=9;
       END;
  |0: position[num,1]:=x * 20; 
    IF x > 10 THEN
       position[num,0]:=11;
       ELSE
       position[num,0]:=9;
       END;
  |79: position[num,1]:=x * 20; 
    IF x > 10 THEN
       position[num,0]:=11;
       ELSE
       position[num,0]:=9;
       END;
  |80: position[num,1]:=x * 20; 
    IF x > 10 THEN
       position[num,0]:=11;
       ELSE
       position[num,0]:=9;
       END;
  |ELSE
   END;   
   END;   
Screen.MoveCursor( position[num,0],position[num,1] );
IO.Wch(".");
Screen.MoveCursor(24,1)
END MoveStar;

PROCEDURE Delay(num:LONGINT);
VAR i:LONGINT;
BEGIN
i:=1   ;
REPEAT
i:=i+1;
UNTIL i=num;
END Delay;

PROCEDURE Main;
VAR j,k:INTEGER;
BEGIN
Screen.Clear;
k:=0;
Box.DrawBox(1,1,23,80);
InitStar(11,32,1);
InitStar(12,42,2);
InitStar(10,52,3);
InitStar(13,22,4);
InitStar(11,52,5);
InitStar(9,22,6);
InitStar(12,52,7);
InitStar(9,52,8);
REPEAT
Box.DrawBox(1,1,23,80);
Screen.MoveCursor(24,1);
Docs(k);
j:=1;
REPEAT
Delay(15000);
MoveStar(1);
MoveStar(2);
MoveStar(3);
MoveStar(4);
MoveStar(5);
MoveStar(6);
MoveStar(7);
MoveStar(8);
INC(j);
UNTIL j=10;
INC(k );
UNTIL k =30;
Screen.MoveCursor(24,1);
END Main;


BEGIN
IO.WL;
Main;
END Star1.
