MODULE Str;
IMPORT IO;

PROCEDURE Len * (x: ARRAY OF CHAR): INTEGER;  
VAR j: INTEGER;
BEGIN  (* there exists a k: 0 <= k < LEN(x): x[k] = 0X *)
	j := 0;
	WHILE  x[j] > 0X  DO  INC(j)  END;
	RETURN j
END Len;

PROCEDURE Copy * (src: ARRAY OF CHAR; VAR dest: ARRAY OF CHAR);  
VAR j: INTEGER;
BEGIN  (* Len(dest) > Len(src) *)
	j := 0;
	WHILE src[j] # 0X DO  dest[j] := src[j]; INC(j)  END;
	dest[j] := 0X
END Copy;

PROCEDURE Locate * ( txt: ARRAY OF CHAR; x: ARRAY OF CHAR; VAR pos: INTEGER);

VAR j, Lx, Lt: INTEGER;
BEGIN  Lx := Len(x);  Lt := Len(txt);  pos := -1;
	REPEAT  j := 0;
		INC(pos);
		WHILE (x[j] = txt[pos + j]) & (j < Lx)  DO INC(j)  END
	UNTIL (j = Lx) OR ((pos + Lx) > Lt);
	IF  j < Lx  THEN pos := -1 (* pattern not found *)  END
END Locate;

PROCEDURE Insert  * (src: ARRAY OF CHAR;VAR dest: ARRAY OF CHAR; pos: INTEGER);

VAR j, Lt, Lx: INTEGER;
BEGIN
	Lt := Len(dest);  Lx := Len(src);
	IF (Lx + Lt < LEN(dest)) & (pos >= 0) & (pos <= Lt) THEN
		(* make room *)
		j := Lt;
		WHILE j >= pos DO  dest[j + Lx] := dest[j];  DEC(j)  END;
		(* copy pattern x after character dest[pos] *)
		j := 0;
		WHILE j < Lx DO  dest[pos + j] := src[j]; INC(j)  END
	END
END Insert;

PROCEDURE Upper * (VAR s:ARRAY OF CHAR;pos,num:INTEGER);
(* Operate directly on a string - converting num characters to Upper case *)
VAR j, Lt: INTEGER;
BEGIN
	Lt := Len(s);
	IF ((Lt>=pos)  & (pos >= 0)) THEN 
		
		(* convert to Uppercase num characters after s[pos] *)
		j := pos;
		WHILE ((j < Lt) & (j<num+1)) DO
                     s[j] := CAP(s[j]); INC(j)                    
                END 
        END 
END Upper;

PROCEDURE Lower * (VAR s:ARRAY OF CHAR;pos,num:INTEGER);
(* Operate directly on a string - converting num characters to lower case *)
VAR j,x, Lt: INTEGER;
BEGIN
	Lt := Len(s);
	IF ((Lt>=pos)  & (pos >= 0)) THEN 
		
		(* convert to lowercase num characters after s[pos] *)
		j := pos;
                
		WHILE ((j < Lt) & (j<num+1)) DO
                 x := ORD(s[j]);
                 IF ((x>64) & (x<91)) THEN 
                 s[j] := CHR(ORD(s[j])+32);
                 END;
                 INC(j);
              END ;
        END;
 END Lower;

PROCEDURE CopySub * (src:ARRAY OF CHAR;VAR dest:ARRAY OF CHAR;pos,num:INTEGER);
(* extract a substring from a string and copy to another string *)
VAR j, Lt : INTEGER;
BEGIN
	Lt:= Len(src);
	IF ((Lt >=pos)   & (num > 0) ) THEN 
		
		(* copy pattern src after character src[pos] *)
		j := 0;
		WHILE ((j < Lt) &(j<num)) DO
                     dest[j] := src[pos+j]; INC(j)
                END 
              dest[j]:=0X;
        END 

END CopySub;

PROCEDURE Delete * (VAR s:ARRAY OF CHAR;pos,num:INTEGER);
(* Operate directly on a string - deleting num characters and closing the gap *)
VAR j,i, Lt: INTEGER;
BEGIN
	Lt := Len(s);
	IF ((Lt>=pos)  & (pos >= 0)) THEN 
		
		(* del num characters after dest[pos] *)
		j := 0;
                i:= pos+num;

		WHILE j < Lt+1 DO
                     s[pos + j] := s[i+j]; INC(j)
                END 
        END 
END Delete;

PROCEDURE Over * (src:ARRAY OF CHAR;VAR dest:ARRAY OF CHAR;pos:INTEGER);
(* overwrite a portion of a string with another string *)
VAR j, Lt, Lx: INTEGER;
BEGIN
	Lt := Len(src);  Lx := Len(dest);
	IF ((Lx-pos) >= Lt)  & (pos >= 0) & (pos <= Lx) THEN 
		
		(* copy pattern src after character dest[pos] *)
		j := 0;
		WHILE j < Lt DO
                     dest[pos + j] := src[j]; INC(j)
                END 
        END 
END Over;

END Str.
  (* S.A. Gibson 73277,1141  Dec 1992 from routines published by: *)
         (* Terry M. Ward, 1987 *)
	(* M. Reiser, 1992 *)

