IMPLEMENTATION MODULE Mouse;

	(********************************************************)
	(*							*)
	(*		    Mouse driver			*)
	(*							*)
	(*  Programmer:		P. Moylan			*)
	(*  Last edited:	8 March 1994			*)
	(*  Status:		OK				*)
	(*							*)
	(*	This module is actually an intermediary		*)
	(*	between the user and the true mouse driver;	*)
	(*	this is so that I can easily experiment		*)
	(*	with different mouse drivers.			*)
	(*							*)
	(********************************************************)

FROM ConfigurationOptions IMPORT
    (* const*)	UseMouse;

(*%T UseSerialDriver *)
FROM SerialMouse IMPORT
(*%E *)
(*%F UseSerialDriver *)
FROM Mouse33 IMPORT
(*%E *)
    (* var! *)	DriverInstalled,
    (* proc *)	SetCursorPos, SetPage, GetPosBut, ShowCursor,
		HideCursor, SetEventHandler,
		SetHorizontalLimits, SetVerticalLimits;

(************************************************************************)

VAR
    HaveMouse: BOOLEAN;
    NumberOfButtons: CARDINAL;

(************************************************************************)

PROCEDURE MouseAvailable (): BOOLEAN;

    (* Returns TRUE iff a mouse driver is loaded, a mouse exists, and	*)
    (* mouse operation is permitted in module ConfigurationOptions.	*)

    BEGIN
	RETURN UseMouse AND DriverInstalled AND HaveMouse
			AND (NumberOfButtons > 0);
    END MouseAvailable;

(************************************************************************)

PROCEDURE GetTextMousePosition (VAR (*OUT*) Xposition: ColumnRange;
				VAR (*OUT*) Yposition: RowRange);

    (* Returns the current position of the mouse cursor. *)

    VAR Buttons: ButtonSet;  X, Y: CARDINAL;

    BEGIN
	GetPosBut (Buttons, X, Y);
	Xposition := X DIV 8;
	Yposition := Y DIV 8;
    END GetTextMousePosition;

(************************************************************************)

PROCEDURE GetTextMouseStatus (VAR (*OUT*) buttons: ButtonSet;
				VAR (*OUT*) Xposition: ColumnRange;
				VAR (*OUT*) Yposition: RowRange);

    (* Returns the current mouse position and state of the buttons.	*)

    VAR X, Y: CARDINAL;

    BEGIN
	GetPosBut (buttons, X, Y);
	Xposition := X DIV 8;
	Yposition := Y DIV 8;
    END GetTextMouseStatus;

(************************************************************************)

PROCEDURE SetTextMousePosition (Xposition: ColumnRange; Yposition: RowRange);

    (* Initialises the mouse position. *)

    BEGIN
	SetCursorPos (8*Xposition, 8*Yposition);
    END SetTextMousePosition;

(************************************************************************)

PROCEDURE SetTextMousePage (page: CARDINAL);

    (* Sets the hardware screen page where the mouse is visible. *)

    BEGIN
	SetPage (page);
    END SetTextMousePage;

(************************************************************************)

PROCEDURE SetMouseCursorLimits (top, bottom: RowRange;
					left, right: ColumnRange);

    (* Specifies a rectangular region outside which the mouse cursor	*)
    (* may not go.							*)

    VAR X: ColumnRange;  Y: RowRange;

    BEGIN
	SetHorizontalLimits (8*left, 8*right);
	SetVerticalLimits (8*top, 8*bottom);
    END SetMouseCursorLimits;

(************************************************************************)

PROCEDURE ShowMouseCursor;

    (* Makes the mouse cursor visible on the screen. *)


    BEGIN
	ShowCursor;
    END ShowMouseCursor;

(************************************************************************)

PROCEDURE HideMouseCursor;

    (* Makes the mouse cursor invisible. *)

    BEGIN
	HideCursor;
    END HideMouseCursor;

(************************************************************************)

PROCEDURE InstallEventHandler (DetectedEvents: EventSet;
					Handler: EventHandler);

    (* Nominates the procedure to be called whenever an event in the	*)
    (* set DetectedEvents occurs.					*)

    BEGIN
	SetEventHandler (DetectedEvents, Handler);
    END InstallEventHandler;

(************************************************************************)

BEGIN
    IF UseMouse AND DriverInstalled THEN
	ResetMouse (HaveMouse, NumberOfButtons);
    ELSE
	HaveMouse := FALSE;  NumberOfButtons := 0;
    END (*IF*);
END Mouse.

