IMPLEMENTATION MODULE Mouse33;

	(****************************************************************)
	(*								*)
	(*		   Mouse driver using INT 33H			*)
	(*		to call a resident mouse driver			*)
	(*								*)
	(*	Author:		P.D. Terry, Rhodes University,		*)
	(*			 Sun  01-10-1993			*)
	(*			Based on an earlier version by		*)
	(*				Roger Carvalho			*)
	(*	Modified by:	Peter Moylan				*)
	(*			(to run with TopSpeed v3)		*)
	(*	Last edited:	8 March 1994				*)
	(*	Status:		Working, not fully tested.  See note	*)
	(*			below about problems with Microsoft	*)
	(*			mouse driver.				*)
	(*								*)
	(*		Everything that I've tested works, but this	*)
	(*		module has been tested only superficially	*)
	(*		by me (PJM) so far.  The code should		*)
	(*		however be fairly trustworthy, because I have	*)
	(*		tested the parts which differ from the		*)
	(*		implementation by Pat Terry.			*)
	(*								*)
	(****************************************************************)
	(*								*)
	(*		PROBLEMS WITH MICROSOFT MOUSE DRIVER		*)
	(*								*)
	(*	Although this module works with the Logitech mouse	*)
	(*	driver and with the OS/2 mouse drivers, it fails with	*)
	(*	at least one version of the Microsoft mouse driver	*)
	(*	for DOS.  The problem is that the mouse driver tries	*)
	(*      to take over the timer interrupt vector, and this is	*)
	(*      incompatible with the PMOS module Timer.  As a result	*)
	(*      you should NOT use this module in conjunction with	*)
	(*      a Microsoft mouse driver; use module SerialMouse	*)
	(*      instead.						*)
	(*								*)
	(*	This problem apparently does not arise when running	*)
	(*	from inside Microsoft Windows.				*)
	(*								*)
	(****************************************************************)

IMPORT Lib, SYSTEM;

FROM ConfigurationOptions IMPORT
    (* const *)	UseMouse;

FROM TerminationControl IMPORT
    (* proc *)	SetTerminationProcedure;

(* ==== From definition module
TYPE
    Buttons =  (LeftButton, RightButton, MiddleButton);

    ButtonSet = SET OF Buttons;

    Events =  (Motion, LeftDown, LeftUp, RightDown, RightUp, MiddleDown,
              MiddleUp);

    EventSet = SET OF Events;

    EventHandler = PROCEDURE (EventSet,  (* condition mask *)
                              ButtonSet, (* Button state *)
                              INTEGER,   (* horizontal cursor position *)
                              INTEGER);  (* vertical cursor position *)

VAR DriverInstalled : BOOLEAN;
====================================== *)

(************************************************************************)

PROCEDURE ResetMouse (VAR (*OUT*) MousePresent: BOOLEAN;
                        VAR (*OUT*) NumberOfButtons: CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 0; Lib.Intr(R, 33H);
	MousePresent := R.AX # 0;
	IF MousePresent THEN
	    NumberOfButtons := R.BX
	ELSE
	    NumberOfButtons := 0;
	END (*IF*);
    END ResetMouse;

(************************************************************************)

PROCEDURE ShowCursor;

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 1; Lib.Intr(R, 33H);
    END ShowCursor;

(************************************************************************)

PROCEDURE HideCursor;

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 2; Lib.Intr(R, 33H);
    END HideCursor;

(************************************************************************)

PROCEDURE GetPosBut (VAR Buttons: ButtonSet;  VAR X, Y: CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 3; Lib.Intr(R, 33H);
	Buttons := ButtonSet(R.BX);  X := R.CX;  Y := R.DX;
    END GetPosBut;

(************************************************************************)

PROCEDURE SetCursorPos (X, Y : CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 4; R.CX := X; R.DX := Y; Lib.Intr(R, 33H);
    END SetCursorPos;

(************************************************************************)

PROCEDURE GetButPress (Button : Buttons; VAR Status : ButtonSet;
                         VAR Count : CARDINAL; VAR X, Y : CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 5; R.BX := ORD(Button);
	Lib.Intr(R, 33H);
	Status := ButtonSet(R.AX); Count := R.BX; X := R.CX; Y := R.DX;
    END GetButPress;

(************************************************************************)

PROCEDURE GetButRelease (Button : Buttons; VAR Status : ButtonSet;
                           VAR Count : CARDINAL; VAR X ,Y : CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 6; R.BX := ORD(Button); Lib.Intr(R, 33H);
	Status := ButtonSet(R.AX); Count := R.BX; X := R.CX; Y := R.DX;
    END GetButRelease;

(************************************************************************)

PROCEDURE SetHorizontalLimits (MinX, MaxX : CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 7; R.CX := MinX; R.DX := MaxX; Lib.Intr(R, 33H);
    END SetHorizontalLimits;

(************************************************************************)

PROCEDURE SetVerticalLimits (MinY, MaxY : CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 8; R.CX := MinY; R.DX := MaxY; Lib.Intr(R, 33H);
    END SetVerticalLimits;

(************************************************************************)

PROCEDURE SetGraphicsCursor (Cursor: GraphicCursor);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 9; R.BX := Cursor.HotX; R.CX := Cursor.HotY;
	R.DX := SYSTEM.Ofs(Cursor.ScreenMask);
	R.ES := SYSTEM.Seg(Cursor.ScreenMask);
	Lib.Intr(R, 33H);
    END SetGraphicsCursor;

(************************************************************************)

PROCEDURE SetTextCursor (Hardware : BOOLEAN; Start, Stop : CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 10; R.BX := ORD(Hardware); R.CX := Start; R.DX := Stop;
	Lib.Intr(R, 33H);
    END SetTextCursor;

(************************************************************************)

PROCEDURE ReadMotionCounters (VAR X, Y : CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 11; Lib.Intr(R, 33H); X := R.CX; Y := R.DX;
    END ReadMotionCounters;

(************************************************************************)

PROCEDURE SetEventHandler (Mask : EventSet;  Handler : EventHandler);

    VAR R: SYSTEM.Registers;
	subr: RECORD
		CASE :BOOLEAN OF
		    FALSE: proc: EventHandler;
		  | TRUE:  offset, segment: CARDINAL;
		END (*CASE*);
	      END (*RECORD*);

    BEGIN
	subr.proc := Handler;
	R.AX := 12; R.CX := CARDINAL(Mask);
	R.DX := subr.offset; R.ES := subr.segment;
	Lib.Intr(R, 33H);
    END SetEventHandler;

(************************************************************************)

PROCEDURE LightPenOn;

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 13; Lib.Intr(R, 33H);
    END LightPenOn;

(************************************************************************)

PROCEDURE LightPenOff;

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 14; Lib.Intr(R, 33H);
    END LightPenOff;

(************************************************************************)

PROCEDURE SetMickeysPerPixel (HorMPP, VerMPP : CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 15; R.CX := HorMPP; R.DX := VerMPP;
	Lib.Intr(R, 33H);
    END SetMickeysPerPixel;

(************************************************************************)

PROCEDURE ConditionalOff (Left, Top, Right, Bottom : CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 16; R.CX := Left; R.DX := Top; R.SI := Right; R.DI := Bottom;
	Lib.Intr(R, 33H);
    END ConditionalOff;

(************************************************************************)

PROCEDURE SetSpeedThreshold (Threshold : CARDINAL);

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 19; R.DX := Threshold; Lib.Intr(R, 33H);
    END SetSpeedThreshold;

(************************************************************************)

PROCEDURE SetPage (page: CARDINAL);

    (* Sets the hardware screen page where the mouse is visible. *)

    VAR R: SYSTEM.Registers;

    BEGIN
	R.AX := 29;  R.BX := page;  Lib.Intr (R, 33H);
    END SetPage;

(************************************************************************)

PROCEDURE Cleanup;

    (* Final cleanup on program termination. *)

    VAR HasMouse: BOOLEAN;  Count: CARDINAL;

    BEGIN
	ResetMouse (HasMouse, Count);
    END Cleanup;

(************************************************************************)
(*			MODULE INITIALISATION				*)
(************************************************************************)

CONST IRET = CHR(207);

VAR Vector [0:204]: RECORD
			CASE  :BOOLEAN OF
			    TRUE:	Routine: POINTER TO CHAR;
			  | FALSE:	segment, offset : CARDINAL;
			END (*CASE*);
		    END (*RECORD*);

BEGIN
    DriverInstalled := (Vector.segment # 0) AND (Vector.offset # 0)
                        AND (Vector.Routine^ # IRET);
    IF UseMouse AND DriverInstalled THEN
	SetTerminationProcedure (Cleanup);
    END (*IF*);
END Mouse33.

