MODULE EditTest;

	(********************************************************)
	(*							*)
	(*		Test of module ScreenEditor		*)
	(*							*)
	(*  Programmer:		P. Moylan			*)
	(*  Last edited:	21 July 1993			*)
	(*  Status:		Working but incomplete		*)
	(*	Trying to recover from the loss of the latest	*)
	(*	source for this module.  This is an old version	*)
	(*	which I am trying to make into an up-to-date	*)
	(*	test.						*)
	(*							*)
	(********************************************************)

FROM Trace IMPORT
    (* proc *)	Pause;

FROM Windows IMPORT
    (* type *)	Window, Colour, FrameType, DividerType,
    (* proc *)	OpenWindow, CloseWindow, SetCursor, WriteString;

FROM NumericIO IMPORT
    (* proc *)	WriteRJCard;

FROM RealIO IMPORT
    (* proc *)	WriteReal;

FROM ScreenEditor IMPORT
    (* type *)	Structure,
    (* proc *)	CardinalField, RealField, Combine, MakeArray,
		ScreenEdit;

(************************************************************************)

CONST maxsubscript = 10;

TYPE
    subscript = [1..maxsubscript];
    TestRecord = RECORD
		    part1: REAL;
		 END (*RECORD*);

VAR
    TestData: ARRAY subscript OF TestRecord;

(************************************************************************)

PROCEDURE RunTheTest;

    VAR w: Window;  R, S, count: Structure;  abort: BOOLEAN;
	x: CARDINAL;  y: REAL;  z: REAL;  graphics: BOOLEAN;

    BEGIN
	OpenWindow (w, blue, cyan, 5, 18, 10, 69, simpleframe, nodivider);

	(* Test 1: a few simple variables. *)

	x := 1234;  y := 3.14159;  graphics := FALSE;
	SetCursor (w, 3, 2);  WriteString (w, "x      [");
	SetCursor (w, 3, 10);  WriteRJCard (w, x, 8);  WriteString (w, "]");
	SetCursor (w, 5, 2);  WriteString (w, "y      [");
	SetCursor (w, 5, 10);  WriteReal (w, y, 10);  WriteString (w, "]");
	SetCursor (w, 5, 30);  WriteString (w, "z      [");
	SetCursor (w, 5, 40);  WriteReal (w, z, 10);  WriteString (w, "]");
	SetCursor (w, 7, 2);  WriteString (w, "graphics");
	SetCursor (w, 7, 10);  WriteString (w, "OFF");

	R := CardinalField (x, 3, 10, 8);
	Combine (R, RealField (z, 5, 40, 10));
	Combine (R, RealField (y, 5, 10, 10));

   (*	AddBooleanField (S, graphics, 7, 10, "NO", "YES");  *)

   (*	ScreenEdit (w, R, abort);   *)

	(* Test 2: elements of an array. *)

	Combine (R, RealField (TestData[1].part1, 1, 3, 10));
	Combine (R, RealField (TestData[2].part1, 2, 3, 10));
	ScreenEdit (w, R, abort);

	SetCursor (w, 9, 1);  WriteString (w, "x, y, z = ");
	WriteRJCard (w, x, 8);  WriteReal (w, y, 10);
	WriteReal (w, z, 10);
	SetCursor (w, 10, 1);  WriteString (w, "graphics is o");
	IF graphics THEN WriteString (w, "n");
	ELSE WriteString (w, "ff");
	END (*IF*);

	(* Test 3: repeating structure. *)
(*
	S := MakeArray (R, maxsubscript, SIZE(TestRecord), 1, 0);
	ScreenEdit (w, S);
*)
	Pause;
	CloseWindow (w);
    END RunTheTest;

(************************************************************************)
(*				MAIN PROGRAM				*)
(************************************************************************)

BEGIN
    RunTheTest;
END EditTest.

