MODULE MenuTest;

	(************************************************)
	(*						*)
	(*	Test of the "Menus" module.		*)
	(*						*)
	(*  Programmer:		P. Moylan		*)
	(*  Last edited:	21 February 1994	*)
	(*  Status:		OK			*)
	(*						*)
	(************************************************)

FROM Trace IMPORT
    (* proc *)	TraceOn, TraceOff, NYI, Pause, InTrace, OutTrace;

FROM Windows IMPORT
    (* type *)	Window, Colour, FrameType, DividerType,
    (* proc *)	OpenWindow, CloseWindow, WriteString, WriteLn;

FROM NumericIO IMPORT
    (* proc *)	WriteCard;

FROM Mouse IMPORT
    (* proc *)	MouseAvailable;

FROM UserInterface IMPORT
    (* type *)	UIWindow, Capability, CapabilitySet,
    (* proc *)	AllowMouseControl;

FROM Menus IMPORT
    (* type *)	Menu, ItemText,
    (* proc *)	CreateMenu, PositionMenu, DestroyMenu, SelectFromMenu;

(********************************************************)

PROCEDURE DisplayAnswer (w: Window; number: CARDINAL);

    BEGIN
	InTrace ("DisplayAnswer");
	WriteString (w, "The result is: ");
	WriteCard (w, number);  WriteLn (w);
	OutTrace ("DisplayAnswer");
    END DisplayAnswer;

(********************************************************)

PROCEDURE RunTheTest;

    VAR menu1: Menu;
	menu1text: ARRAY [0..25] OF ItemText;
	result: CARDINAL;
	resultwindow: Window;  UIW: UIWindow;

    BEGIN
	InTrace ("RunTheTest");
	menu1text[0] := "MENU 1";
	menu1text[1] := "The";
	menu1text[2] := "quick";
	menu1text[3] := "brown";
	menu1text[4] := "fox";
	menu1text[5] := "jumps";
	menu1text[6] := "over";
	menu1text[7] := "the";
	menu1text[8] := "lazy";
	menu1text[9] := "dog";
	menu1text[10] := "Now";
	menu1text[11] := "is";
	menu1text[12] := "the";
	menu1text[13] := "time";
	menu1text[14] := "for";
	menu1text[15] := "all";
	menu1text[16] := "good";
	menu1text[17] := "men";
	menu1text[18] := "to";
	menu1text[19] := "come";
	menu1text[20] := "to";
	menu1text[21] := "the";
	menu1text[22] := "aid";
	menu1text[23] := "of";
	menu1text[24] := "the";
	menu1text[25] := "party";
	OpenWindow (resultwindow, white, magenta, 1, 15, 32, 70,
			doubleframe, nodivider);
	IF MouseAvailable() THEN
	    UIW := AllowMouseControl (resultwindow, "Menu selection result",
			CapabilitySet {wshow, wmove, whide});
	END (*IF*);
	CreateMenu (menu1, 3, menu1text, 25);
	PositionMenu (menu1, blue, cyan, 3, 10, 0, 30);
	REPEAT
	    result := SelectFromMenu (menu1);
	    DisplayAnswer (resultwindow, result);
	    Pause;
	UNTIL result = 0;
	DestroyMenu (menu1);
	Pause;
	CloseWindow (resultwindow);
	OutTrace ("RunTheTest");
    END RunTheTest;

(********************************************************)
(*			MAIN PROGRAM			*)
(********************************************************)

BEGIN
    TraceOn (13, 24, 40, 79, 1);
    RunTheTest;
    TraceOff;
    Pause;
END MenuTest.

