--Checks for Sound Card
--Detects the presence of Sound Blaster Compatable Sound Card
--You need ports.e for this to work

without warning

include ports.e
include dma.e

-- with trace

constant DATA_READY = #AA
constant GET_DSP_VERSION = #E1
integer BaseIo, Dma8, Dma16, DspIrq

integer DSP_RESET,        -- dsp reset i/o port
	DSP_READ_DATA,    -- dsp read data i/o port
	DSP_WRITE_DATA ,  -- dsp write data i/o port
	DSP_WRITE_STATUS, -- dsp write status i/o port
	DSP_DATA_AVAIL    -- dsp read status i/o port


constant LogFile="Detect.log"
integer Log

procedure WriteLogMsg(sequence FileName, sequence msg)
integer fh
   fh = open(FileName,"a")
   if fh = -1 then
     return
   end if
   puts(fh,msg)
   close(fh)
end procedure

procedure CreateLogFile(sequence LogFileName)
integer fh 
  fh = open(LogFileName,"w")
  if fh = -1 then
      Log = 0
  else
     Log = 1
      puts(fh,"This file is produce by detect.exe.\n\n")
      close(fh)
  end if
end procedure

procedure Usage()
  puts(1,"Sound card setting detection, by Jacques Deschenes\n")
  puts(1,"USAGE: detect [/?] | [/l-|+]\n")
  puts(1,"   /? display this information.\n")
  puts(1,"   /l-  no log file.\n")
  puts(1,"   /l+  record results in a log file.\n")
  abort(1)
end procedure

-------------Write Sound Card Register----------------
procedure WriteSndReg(integer reg, integer val) -- by Gregg Harris
    --Write to a sound card register
    integer temp
	Output(reg, #388)
	for tmp = 1 to 6 do      --wait 6 miliseconds
	    temp = Input(#388)
	end for
	Output(val, #389)
	for tmp = 1 to 35 do    --wait 35 miliseconds
	    temp = Input(#388)
	end for
end procedure

----------------Detect Sound Card--------------------
function Detect_Sound_Card()  -- by Gregg Harris
    --Detects a Adlib Compatible Card
    --Return 1 if true 0 if not found
    integer a, b, c, success
	success = 0                --This was missing
	WriteSndReg(#4, #60)
	WriteSndReg(#4, #80)
	b=Input(#388)
	WriteSndReg(#2, #FF)
	WriteSndReg(#4, #21)
	for tmp = 1 to 130 do
	    a = Input(#388)
	end for
	c = Input(#388)
	WriteSndReg(#4, #60)
	WriteSndReg(#4, #80)
	if and_bits(b,#E0) = 0 then
	    if and_bits(c,#E0) = #C0 then
		success = 1
		for tmp = 1 to #F5 do     --reset Sound Card
		    WriteSndReg(tmp, 0)
		end for
	    end if
	end if
    return success
end function

function Get_Base_Address()  -- by Gregg Harris
integer baseport, resetport, readport, data
data = 0
baseport = #210
resetport = #216
readport = #21A
    while (data != DATA_READY) and (baseport<#270) do
       Output(1, resetport)
       for x = 1 to 3 do
       end for
       Output(0, resetport)
       data = 0

       for x = 0 to 99 do
       data = Input(readport)
       end for

       if data = DATA_READY then
	  exit
       else
	    baseport = baseport + #10
	    resetport = resetport + #10
	    readport = readport + #10
       end if
    end while

    if baseport = #270 then
	return 0
    else
	return baseport
    end if
end function

function DetectCard()  -- by Gregg Harris
    integer temp
    if Detect_Sound_Card() then
	temp = Get_Base_Address()
	BaseIo = temp
       --  Calculate the port addresses  
	DSP_RESET = BaseIo + #6 
	DSP_READ_DATA = BaseIo + #A 
	DSP_WRITE_DATA = BaseIo + #C 
	DSP_WRITE_STATUS = BaseIo + #C 
	DSP_DATA_AVAIL = BaseIo + #E 
	return BaseIo
    else
	return 0
    end if
end function


-- following code added by Jacques Deschenes

constant TIME_OUT = 0.5
procedure ResetDSP()
-- ResetDSP returns TRUE if reset was successful
atom start, TimeOut  
  Output(1,DSP_RESET) 
  --delay(.001) -- problably not needed.  DSP chip ask for a 3 micro second delay
  Output(0,DSP_RESET) 
  start = time()
  TimeOut = 0
  while not TimeOut and floor(Input(DSP_DATA_AVAIL)/#80)=0 do 
    TimeOut = time()-start >= TIME_OUT
  end while 
  if not Input(DSP_READ_DATA) = DATA_READY then
    puts(1,"unable to reset DSP.\n")
  end if
end procedure --ResetDSP()

global procedure WriteDSP(byte value) 
-- write a byte to dsp write register
atom start integer TimeOut
  start = time()
  TimeOut = 0
  while not TimeOut and floor(Input(DSP_WRITE_STATUS)/#80) = 1 do 
    TimeOut = time() - start > TIME_OUT
  end while
  Output(value,DSP_WRITE_DATA)
end  procedure --WriteDSP()

global function ReadDSP() 
-- read a byte from dsp read register
atom start 
integer TimeOut
  TimeOut = 0
  start = time()
  while not TimeOut and floor(Input(DSP_DATA_AVAIL)/#80) = 0 do 
    TimeOut = time() - start > TIME_OUT
  end while
  if TimeOut then
    return -1
  end if
  return Input(DSP_READ_DATA)
end function -- ReadDSP()

global function GetDSPVersion()
-- return the Digital sound processor version number.
integer major, minor
  WriteDSP(GET_DSP_VERSION)
  major = ReadDSP()
  minor = ReadDSP()
  return major+ minor/100
end function -- GetDSPVersion

constant DMA_8_CHANNELS = {0,1,3}
constant DMA_16_CHANNELS = {5,6,7}

function DetectDma8()
atom DmaBuff, start
integer channel
    
    channel = -1
    DmaBuff = AllocateDMABuffer(32)
    mem_set(DmaBuff,128,32)
    WriteDSP(#40)
    WriteDSP(211)
    for i = 1 to length(DMA_8_CHANNELS) do
      SetDma(DmaBuff,32,DMA_8_CHANNELS[i],DMA_OUT+DMA_SINGLE)
    end for
    WriteDSP(#14)
    WriteDSP(remainder(32-1,256))
    WriteDSP(floor((32-1)/256))
    start = time()
    while time() - start < .05 do
    end while
    ResetDSP()
    free_low(DmaBuff)
    for i = 1 to length(DMA_8_CHANNELS)  do
      if ReadCurrentCount(DMA_8_CHANNELS[i]) = 65535 then
	 channel =  DMA_8_CHANNELS[i]
      end if
      ResetDma(DMA_8_CHANNELS[i])
    end for
    return channel
end function

function DetectDma16()
atom DmaBuff, start
integer size, channel
    channel = -1
    size = 32
    DmaBuff = AllocateDMABuffer(size)
    mem_set(DmaBuff,0,size)
    WriteDSP(#41) -- set sampling rate
    WriteDSP(floor(22050/256))
    WriteDSP(remainder(22050,256))
    for i = 1 to length(DMA_16_CHANNELS) do
      SetDma(DmaBuff,size,DMA_16_CHANNELS[i],DMA_OUT+DMA_SINGLE)
    end for
    WriteDSP(#B0) -- set 16 bits output
    WriteDSP(#10) -- set 16 bits mono signed mode
    WriteDSP(remainder((size-1),256))
    WriteDSP(floor((size-1)/256))
    start = time()
    while time() - start < .05 do
    end while
    ResetDSP()
    free_low(DmaBuff)
    for i = 1 to length(DMA_16_CHANNELS) do
      if ReadCurrentCount(DMA_16_CHANNELS[i]) = 65535 then
	 channel = DMA_16_CHANNELS[i]
      end if
      ResetDma(DMA_16_CHANNELS[i])
    end for
    return channel
end function

procedure EnableIRQ(integer IrqNumber)
  if IrqNumber < 8 then 
    Output(and_bits(Input(#21),not_bits(power(2,IrqNumber))),#21)
  else       
    Output(and_bits(Input(#A1),not_bits(power(2,IrqNumber-8))),#A1)
  end if
end procedure --EnableIRQ()

procedure DisableIRQ(integer IrqNumber)
  if IrqNumber < 8 then 
    Output(or_bits(Input(#21),power(2,IrqNumber)),#21)
  else       
    Output(or_bits(Input(#A1),power(2,IrqNumber-8)),#A1)
  end if
end procedure --DisableIRQ()

atom segment, code_segment
segment = allocate(4)
lock_memory(segment,4)

sequence save_segment_code
save_segment_code = {
    #53,   -- push ebx
    #0E,   -- push cs   or #1E push ds -- only a 16-bit value
    #5B,   -- pop ebx  
    #89, #1D} & int_to_bytes(segment) & -- mov segment, ebx
    {#5B,   -- pop ebx
    #C3    -- ret
}       
atom save_segment
save_segment = allocate(length(save_segment_code))
poke(save_segment, save_segment_code)
call(save_segment) -- save code segment

code_segment = bytes_to_int(peek({segment,4})) 

poke(save_segment+1, #1E) 
call(save_segment) -- save data segment


constant TST_DATA_LEN = 16
atom INT_CODE, TST_DATA_SEG,
     dBASE_IO,
     dDMA_COUNT,
     dIRQ_NO,
     dINT_COUNT

TST_DATA_SEG = allocate(TST_DATA_LEN)
lock_memory(TST_DATA_SEG,TST_DATA_LEN)

dBASE_IO = TST_DATA_SEG + 0
dDMA_COUNT = TST_DATA_SEG + 2
dIRQ_NO = TST_DATA_SEG + 4
dINT_COUNT = TST_DATA_SEG + 5

constant sINT_CODE = {
  #1E,                                  -- PUSH DS               
  #60,                                  -- PUSHAD                
  #BB}&peek({segment,4})&{              -- MOV  EBX, DATA_SEG    
  #53,                                  -- PUSH EBX              
  #1F,                                  -- POP  DS               
  #66,#BA,#0C,#00,                      -- MOV  DX,  0C          
  #32,#C0,                              -- XOR  AL, AL
  #EE,                                  -- OUT  DX, AL           
  #66,#8B,#15}&int_to_bytes(dDMA_COUNT)&{-- MOV  DX, [dma_count]     
  #EC,                                  -- IN AL, DX             
  #86,#E0,                              -- XCHG AH,AL            
  #EC,                                  -- IN AL, DX             
  #66,#3D,#FF,#FF,                      -- CMP   AX, 0FFFF       
  #75,#30,#90,#90,#90,#90,              -- JNE  @exit
  #66,#8B,#15}&int_to_bytes(dBASE_IO)&{  -- MOV  DX, [BASE_IO]
  #66,#83,#C2,#0E,                      -- ADD  DX, 0E           
  #EC,                                  -- IN AL, DX             
  #66,#BA,#20,#00,                      -- MOV  DX, 20           
  #B0,#20,                              -- MOV  AL, 20           
  #EE,                                  -- OUT  DX, AL           
  #80,#3D}&int_to_bytes(dIRQ_NO)&{#07,   -- CMP  [IRQ_NO], 7
  #76,#10,#90,#90,#90,#90,              -- JBE  @exit
  #66,#BA,#A0,#00,                      -- MOV  DX, 0A0          
  #EE,                                  -- OUT  DX, AL           
  #66,#FF,#05}&int_to_bytes(dINT_COUNT)&{-- INC  [INT_COUNT]
				      -- @exit:
  #61,                                  -- POPAD
  #1F,                                  -- POP  DS
  #EA,#00,#00,#00,#00,#00,#00           -- JMP ORIG_HANDLER
}

INT_CODE = allocate(length(sINT_CODE))
lock_memory(INT_CODE,length(sINT_CODE))
poke(INT_CODE,sINT_CODE)

constant  DMA_COUNT_REG={1,3,5,7}

function TstInt(integer IrqNo)
sequence OrigVector
integer IntNo, Master, Slave
atom start, DmaBuff
    poke(dIRQ_NO,IrqNo)
    poke(dDMA_COUNT,{DMA_COUNT_REG[Dma8+1],0})
    poke(dINT_COUNT,{0,0,0,0})
    if IrqNo < 8 then
	IntNo = IrqNo + 8
    else
	IntNo = IrqNo - 8 + #70
    end if
    DmaBuff = AllocateDMABuffer(32)
    mem_set(DmaBuff,128,32)
    WriteDSP(#40)  -- set dsp time constant
    WriteDSP(211)  -- time constant
    Master = Input(#21)  -- get master PIC interrupt mask
    Slave = Input(#A1)   -- get slave PIC interrupt mask
    OrigVector = get_vector(IntNo)
    poke(INT_CODE + length(sINT_CODE) - 6,int_to_bytes(OrigVector[2])&
	 remainder(OrigVector[1],256)&floor(OrigVector[1]/256))
    set_vector(IntNo,{code_segment,INT_CODE})
    EnableIRQ(IrqNo)
    SetDma(DmaBuff,32,Dma8,DMA_OUT+DMA_SINGLE)
    WriteDSP(#14)  -- set dsp mode for single cycle dma transfert
    WriteDSP(remainder(32-1,256)) -- write block length low byte
    WriteDSP(floor((32-1)/256))   -- high byte
    start = time()
    while time() - start < .05 do
    end while
    ResetDSP()
    free_low(DmaBuff)
    ResetDma(Dma8)
    set_vector(IntNo,OrigVector)
    Output(Master,#21)
    Output(Slave,#A1)
    if bytes_to_int(peek({dINT_COUNT,4})) > 0 then
	return 1
    else
       return 0
    end if
end function  -- TstInt()

constant SB_INT_NO= {2,3,5,7,10}
function DetectIRQ()

  poke(dBASE_IO,{remainder(BaseIo,256),floor(BaseIo/256)})
  for i = 1 to length(SB_INT_NO)  do
    if TstInt(SB_INT_NO[i]) then
	return SB_INT_NO[i]
    end if
  end for
  return -1
end function

procedure TPrint(sequence message)  -- tee print (to file and to screen)
  puts(1,message)
  if Log then
    WriteLogMsg(LogFile,message)
  end if
end procedure

atom version
integer temp
sequence CmdLine, Msg

CmdLine = command_line()
if length(CmdLine) < 3 then
  CreateLogFile(LogFile)
elsif not compare(CmdLine[3],"/l-") then
  Log = 0
elsif not compare(CmdLine[3],"/l+") then 
  CreateLogFile(LogFile)
else
  Usage()
end if


TPrint("Sound card detection.\n\n")
-- trace(1)
temp = DetectCard()
if temp then
    Msg = sprintf("Sound card detected at base address %xh\n",{BaseIo})
    TPrint(Msg)
    version = GetDSPVersion()
    Msg = sprintf("DSP version is %.2f\n",{version})
    TPrint(Msg)
    Dma8 = DetectDma8()
    if Dma8 != -1 then
      Msg = sprintf("8 bits dma channel is %d\n",{Dma8})
      TPrint(Msg)
    else
      TPrint("Failed to detect 8 bits dma channel.\n")
    end if
    if version >= 4.00 then
	Dma16 = DetectDma16()
	if Dma16 > -1 then
	  Msg = sprintf("16 bits dma channel is %d\n",{Dma16})
	  TPrint(Msg)
	else  
	  TPrint("Failed to detect 16 bits dma channel.\n")
	end if
    end if
    DspIrq = DetectIRQ()
    if DspIrq > -1 then
      Msg = sprintf("IRQ number is %d\n",{DspIrq})
      TPrint(Msg)
    else
      TPrint("Failed to detect IRQ.\n")
    end if
else           
    TPrint("Sound card not detected.\n")
end if

