-- Dos function call #21 wrap up.
-- by Jacques Deschenes, Baie-Comeau, PQ, Canada, e-mail: Desja@quebectel.com
-- Creation date: September 28th, 1996
-- Why bother using DOS for file I/O when Euphoria can do that?
-- Because with Euphoria you have to read a file into a sequence and then 
-- poke the sequence into a buffer.
-- with DOS file I/O one can read and write directly to a buffer which 
-- is faster.
--
-- revision history
-- february 6th, 1997
--   added 2 functions to set date and time:
--      DosSetDate(sequence Date)
--      DosSetTime(sequence time)
-- February 9th, 1997
--   In DosCreate() redefined type of NameBuffer to atom, was mistakenly 
--   define as sequence.
-- May 6th, 1997
--   corrected bug:  Name buffers were not freed.

include machine.e
include ports.e

global constant READ = 0, WRITE = 1, READ_WRITE=2

global function DosCreate(sequence Name, integer attributes)
-- Create a new file.
-- parameters: Name is name of the new file.
--             attributes for the new file.
-- if success return File handle else return -1
sequence regs
atom NameBuffer
regs = repeat(0,10)
NameBuffer = allocate_low(length(Name)+1)
if not NameBuffer then
    return -1
end if
poke(NameBuffer,Name & 0)
regs[REG_AX] = #3C00
regs[REG_CX] = attributes
regs[REG_DS] = floor(NameBuffer/16)
regs[REG_DX] = remainder(NameBuffer,16)
regs = dos_interrupt(#21,regs)
free_low(NameBuffer)
if and_bits(regs[REG_FLAGS],1) then
    return -1 -- fail to open
end if
return regs[REG_AX]  -- return file handle
end function -- DosCreate()

global function DosOpen(sequence FileName, integer Mode)
-- use DOS function #3D to open a file
-- return file handle or -1 if error
-- mode is 0 = read only
--         1 = write only
--         2 = read/write 

atom NameBuffer
sequence regs
regs = repeat(0,10)
NameBuffer = allocate_low(length(FileName)+1)
if not NameBuffer then
    return -1
end if
poke(NameBuffer,FileName & 0)
regs[REG_AX] = #3D00+Mode
regs[REG_DS] = floor(NameBuffer/16)
regs[REG_DX] = remainder(NameBuffer,16)
regs = dos_interrupt(#21,regs)
free_low(NameBuffer)
if and_bits(regs[REG_FLAGS],1) then
    return -1 -- fail to open
end if
return regs[REG_AX]  -- return file handle
end function -- DosOpen()

global function DosClose(integer Handle)
-- close a file open with DosOpen()
-- return 1 if success else return 0
sequence regs
    regs = repeat(0,10)
    regs[REG_AX] = #3E00
    regs[REG_BX] = Handle
    regs = dos_interrupt(#21,regs)
    if and_bits(regs[REG_FLAGS],1) then
    return 0
    end if
    return 1
end function -- DosClose()

global function BlockRead(integer Handle, atom buffer, atom NbBytes)
-- Read a given number of bytes from a file open with DosOpen() to a buffer 
-- if success return Number of bytes actually read else return -1
-- parameters:
--    Handle -> the file Handle returned by DosOpen()
--    buffer -> is a pointer returned byt allocate_low() where the data will be
--              read.
--    NbBytes -> is the number of bytes to read.
 
sequence regs
regs = repeat(0,10)
regs[REG_AX] = #3F00
regs[REG_BX] = Handle
regs[REG_CX] = NbBytes
regs[REG_DS] = floor(buffer/16)
regs[REG_DX] = remainder(buffer,16)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    return -1 -- failed to read
end if
return regs[REG_AX]
end function --BlockRead()

global function BlockWrite(integer Handle, atom buffer, atom NbBytes)
-- Write to a file open with DosOpen() from a buffer.
-- if succes return number of bytes actually written else return 0
-- parameters: Handle -> handle returned by DosOpen()
--             buffer -> buffer pointer returned by allocate_low() where data
--                       to write is stored.
--             NbBytes -> Number of bytes to write

sequence regs
regs = repeat(0,10)
regs[REG_AX] = #4000
regs[REG_BX] = Handle
regs[REG_CX] = NbBytes
regs[REG_DS] = floor(buffer/16)
regs[REG_DX] = remainder(buffer,16)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    return -1 -- failed to write
end if
return regs[REG_AX]
end function -- BlockWrite()

global function DosSeek(integer Handle, integer Distance, integer Origin)
-- Move the file read/write pointer to specified position
-- return new pointer position or -1 if error.
-- parameters: Handle is DosOpen() handle
--             Distance is distance to move to
--             Origin from where Distance is added
--              Origin = 0 beginning of file + Distance
--              Origin = 1 current location + Distance
--              Origin = 2 end of file + Distance
sequence regs
regs = repeat(0,10)
regs[REG_AX] = #4200+Origin
regs[REG_BX] = Handle
regs[REG_CX] = floor(Distance/256)
regs[REG_DX] = remainder(Distance,256)
regs = dos_interrupt(#21,regs)
if and_bits(regs[REG_FLAGS],1) then
    return -1 -- failed
end if
return regs[REG_AX]
end function --DosSeek()

global procedure DosSetDate(sequence Date)
-- Date format is {year, month, day)    
sequence r
  r = repeat(0,10)
  r[REG_AX] = #2B00
  r[REG_CX] = Date[1]
  r[REG_DX] = Date[2]*256+Date[3]
  r = dos_interrupt(#21,r)
end procedure -- DosSetDate()

global procedure DosSetTime(sequence Time)
-- Time format is {Hours, minutes, secondes}    
-- 24 hours format used.
sequence r
  r = repeat(0,10)
  r[REG_AX] = #2D00
  r[REG_CX] = Time[1]*256+Time[2]
  r[REG_DX] = Time[3]*256
  r = dos_interrupt(#21,r)
end procedure -- DosSetTime()

constant BUFF_SIZE = power(2,15)

global function CopyFile(sequence Source, -- source file name
	     sequence Dest    -- destination file name
	    )

atom buffer
integer   FSrc, FDest, NbRead, junk

    FSrc = DosOpen(Source,READ)
    if FSrc = -1 then
    return 0
    end if
    FDest = DosCreate(Dest,0)
    if FDest = -1 then
    return 0
    end if  
    buffer = allocate_low(BUFF_SIZE)
    if buffer = 0 then
    return 0
    end if
    NbRead = BlockRead(FSrc,buffer,BUFF_SIZE)
    while NbRead > 0 do
    if BlockWrite(FDest,buffer,NbRead) = -1 then
      junk = DosClose(FSrc)
      junk = DosClose(FDest)
      free_low(buffer)
      return 0
    end if
       NbRead = BlockRead(FSrc,buffer,BUFF_SIZE)
    end while
    junk = DosClose(FSrc)
    junk = DosClose(FDest)
    free_low(buffer)
    return 1
end function



