-- to answer the question "How to use sbcard.e in game?"
-- steps:
-- 1) load all sounds in buffers,  use LoadSoundEffects().
-- 2) Open volumes (master, voice) set speaker on with SpeakerOn()
-- 3) when you need a sound effect call PlaySoundEffect() (see below)
-- **** NOTE: it plays only 8 bits wave files.

-- NOTE: don't forget to set WAV_DIR to your own wave directory

without warning
include file.e
include delay.e
include doswrap.e
include soundfx.e

DmaChannel = DMA8 -- only play 8 bit sound.

-- 1) Load sound effect in DMA buffers

sequence SoundEffects -- contain parameter for each sound effect.
-- needed parameters: {buffer,Size,TimeConstant, channels}

constant WAV_DIR = "" --"c:\\win95\\media\\wave\\"  -- my wave directory.

constant -- list of wave files to load in buffers.
 SoundFiles = {WAV_DIR&"explode.wav",WAV_DIR& "readywar.wav",
	       WAV_DIR&"whop.wav", WAV_DIR&"bat.wav",
	       WAV_DIR&"arnold.wav"}
 

SoundEffects = LoadSoundEffects(SoundFiles)

  
integer FHandle  
atom char
FHandle=open("game&wav.ex","r")
clear_screen()
sequence ScrLine
 ScrLine = {}
 for i =1  to 80  do
    char = getc(FHandle)
    if char = 10 or char = 13 then
	char = ' '
    end if
    ScrLine = ScrLine & char
 end for

procedure Scroller()
object line     integer ok
   position(12,1)
   puts(1,ScrLine)
   char = getc(FHandle)
   if char = -1 then
     ok = seek(FHandle,0)
     char = getc(FHandle)
   end if
   if char = 10 or char = 13 then
     char = ' '
   end if
   ScrLine = ScrLine[2..length(ScrLine)] & char
end procedure

integer key
  key = 0
  while get_key() != -1 do -- clean keyboard buffer
  end while
  position(2,1)
  puts(1,"enter a digit (0..4)\n")
-- 2) open volume
  SetVolume(MASTER_VOLUME,VOL_MAX)
  SetVolume(VOICE_VOLUME,2)
  while key != 27 do
    key = get_key() 
    poke(#41A,peek({#41C,2})) -- clean keyboard buffer
    if key >='0' and key <= '4' then
	PlaySoundEffect(SoundEffects[key-'0'+1]) 
      end if
    Scroller()
    delay(.2)
  
  end while
  
