-- NAME: int24.e
-- OBJECT: trapping criticals errors related to disk access
-- BY: Jacques Deschenes, Baie-Comeau, Canada, e-mail: desja@quebectel.com
-- 
-- How to use it:
--   after accessing disk your program should call CheckIo() to know if there
--   was an error.

include machine.e

atom segment
segment = allocate(4)
lock_memory(segment, 4)


sequence save_segment_code
save_segment_code = {
    #53,   -- push ebx
    #0E,   -- push cs   or #1E push ds -- only a 16-bit value
    #5B,   -- pop ebx  
    #89, #1D} & int_to_bytes(segment) & -- mov segment, ebx
    {#5B,   -- pop ebx
    -- pop ds
    #C3    -- ret
}       

atom save_segment
save_segment = allocate(length(save_segment_code))
poke(save_segment, save_segment_code)
call(save_segment) -- save code segment

integer code_segment
code_segment = bytes_to_int(peek({segment,4}))

poke(save_segment+1, #1E) 
call(save_segment) -- save data segment
sequence data_segment
data_segment = peek({segment,4})
free(segment)
free(save_segment)
save_segment_code = {}

constant DATA_LEN = 16
atom INT_24,
     ERROR_CODE

ERROR_CODE = allocate(DATA_LEN)
lock_memory(ERROR_CODE,DATA_LEN)
poke(ERROR_CODE,#FF)

constant sINT_24 = { -- interrupt #24 critical error handler trapping
  #80,#FC,#80,                          -- cmp ah, 80
  #73,#17,#90,#90,#90,#90,              -- jae old_isr
  #1E,                                  -- push ds
  #53,                                  -- push ebx
  #BB}&data_segment&{                   -- mov ebx, data_segment
  #53,                                  -- push ebx
  #1F,                                  -- pop ds
  #66,#89,#3D}&int_to_bytes(ERROR_CODE)&{-- mov [ERROR_CODE], di
  #5B,                                  -- pop ebx
  #1F,                                  -- pop ds
  #CF,                                  -- iretd
		      -- old_isr:
  #EA,#00,#00,#00,#00,#00,#00           -- jmp far old_vector
}

sequence OrigVector
integer HookInstalled

global procedure HookInt24()
  INT_24 = allocate(length(sINT_24))
  lock_memory(INT_24,length(sINT_24))
  poke(INT_24,sINT_24)
  OrigVector = get_vector(#24)
  poke(INT_24+length(sINT_24)-6,
      int_to_bytes(OrigVector[2])&
      remainder(OrigVector[1],256)&floor(OrigVector[1]/256)
    )
  set_vector(#24,{code_segment,INT_24})
  HookInstalled = 1
end procedure

global procedure RestoreInt24()
  set_vector(#24,OrigVector)
  free(INT_24)
  HookInstalled = 0
end procedure

global constant IO_ERRORS = { -- error messages associated with disk i/o error
  "Attempt to write on write-protected disk.",
  "Unknow unit.",
  "Drive not ready.",
  "Unknown command.",
  "Data error (CRC).",
  "Bad request structure length.",
  "Seek error.",
  "Unknown media type.",
  "Sector not found.",
  "Printer out of paper.",
  "Write fault.",
  "Read fault.",
  "General failure."
  }

global function CheckIo()
integer error
  if not HookInstalled then
    return 0
  end if
  error = peek(ERROR_CODE)
  poke(ERROR_CODE,#FF)
  if error = #FF then
    return 0
  else
    return error + 1
  end if
end function

HookInt24()

