-- demo program for sfx2.e

-- NOTE: don't forget to set WAV_DIR to your own wave directory

without warning
without type_check
include file.e
include sfx2.e




constant -- list of wave files to load in buffers.
 SoundFiles = {"readywar.wav","whop.wav","bat.wav",
	       "explode.wav","arnold.wav"}

constant SoundNames={"Readywar","whop","bat","explode","arnold"}
 
object WavInfo
sequence SoundEffects -- contain parameter for each sound effect.
SoundEffects = {}

-- 1) Load sound effect in buffers

for i = 1 to length(SoundFiles) do
    WavInfo = LoadWaveFile(SoundFiles[i])
    if sequence(WavInfo) then
	SoundEffects = append(SoundEffects,WavInfo)
    else
       printf(1,"File %s couldn't be loaded.\n",{SoundFiles[i]})
    end if
end for
  
clear_screen()

sequence SoundIds
SoundIds = repeat(0,4)

integer key, TimeOut, id
  key = 0
  while get_key() != -1 do -- clean keyboard buffer
  end while
  position(2,1)
  puts(1,"enter a digit (1..5), <s> to stop sounds and <ESC> to quit.\n")
  for i = 1 to 5 do
    printf(1,"%1d) %s\n",{i,SoundNames[i]})
    if i = 4 then
       position(6,30)
	puts(1,"(this sound is looping continously.)\n")
    end if
  end for

-- 2) open volume
  SetVolume(VOICE_VOLUME,2)
  id = PlaySound(SoundEffects[4],1)  -- play this sound continously
  SoundIds[id+1] = 4
  while key != 27 do
    key = get_key() 
    if key >='1' and key <= '5' then

-- 3) call PlaySound() when needed.
      id = PlaySound(SoundEffects[key-'0'],0) 
      if id > -1 then
	SoundIds[id+1] = key - '0' 
      end if
    elsif key = 's' or key = 'S' then
	StopSound(-1)  -- stop all sounds
    end if
    for i = 0 to 3 do
      if SoundDone(i) then
	SoundIds[i+1] = 0
      end if
    end for
    for i = 1 to  5 do
	position(2+i,13)
	if find(i,SoundIds) then
	    puts(1," is Playing.")
	else
	    puts(1,"            ")
	end if
    end for
    position(25,79)
    delay(.2)
end while

-- 4) Call CloseSfx() before exiting
CloseSfx()  

