-- WaveDemo.ex

-- purpose: Demonstrate the use of SFX2.E
-- play wav, view header info and test differeent sampling rate file.
-- by Jacques Deschenes, Baie-Comeau,P.Q., Canada, e-mail: desja@quebectel.com
-- Creation date: April 9th, 1997
-- Last revision: May 11th, 1997

without warning
with trace
include sfx2.e
include FileList.e


sequence sWavDir  -- wave resources directory
sequence FileName  -- current file name
sequence CmdLine  -- command line
object   WaveInfo  -- wave file header information
integer idx  -- index number of playing sound 
integer volume

constant  -- application screen colors
  iAPP_BK_COLOR = BLUE,
  iAPP_TEXT_COLOR = WHITE

procedure SetAppColors(integer BackColor, integer TextColor)
    text_color(TextColor)
    bk_color(BackColor)
end procedure   --SetAppColors()

function AToI(sequence NbStr)
-- convert a decimal string to it's integer value
integer i, sign
    sign = 0
    if NbStr[1] = '-' then
	sign = 1
	NbStr = NbStr[2..length(NbStr)]
    end if
    i = 0
    for n = 1 to length(NbStr) do
	if NbStr[n] >= '0' and NbStr[n] <= '9' then
	    i = i * 10 + NbStr[n] - '0'
	else
	    exit
	end if
    end for
    if sign then
	return (-i)
    else
	return i
    end if
end function -- AToI()

procedure Clreol()
-- clear end of line
sequence CurPos
  CurPos = get_position()
  puts(1,repeat(32,80-CurPos[2]))
  position(CurPos[1],CurPos[2])
end procedure -- clreol()


function PromptIn(sequence prompt)
sequence CurPos, InStr
    CurPos = get_position()
    puts(1,prompt)
    InStr = gets(0)
    position(CurPos[1],CurPos[2])
    Clreol()
    return InStr
end function -- PromptIn()

procedure CleanUp(integer ExitCode)
-- clean up and abort
atom junk
  junk = graphics_mode(-1)
  text_color(WHITE)
  bk_color(BLACK)
  clear_screen()
  CloseSfx()
  abort(ExitCode)   
end procedure

procedure Init()
  if iSbCardError then
    puts(1,ERROR_MESSAGES[iSbCardError])
    abort(1)
  end if
  volume = 4  -- mid level
  CmdLine = command_line()
  if length(CmdLine) < 3 then
    sWavDir = ""
  else
    sWavDir = CmdLine[3]
  end if
  if graphics_mode(18) then
     CleanUp(1)
  end if
  SetAppColors(iAPP_BK_COLOR, iAPP_TEXT_COLOR)
  SetVolume(VOICE_VOLUME,volume)
end procedure -- Init()

constant sCHANNELS = {"MONO","STEREO"}

procedure DisplayWavInfo(sequence FileName, sequence WavInfo)
  text_color(WHITE)
  bk_color(BLUE)
  clear_screen()
  position(4,1)
  printf(1,"File name: %s\n",{FileName})    
  printf(1,"Channels: %s\n",{sCHANNELS[WavInfo[siCHANNELS]]})
  printf(1,"Sampling rate: %d\n",{WavInfo[siSPS]})
  printf(1,"Data length: %d\n",{WavInfo[siDATA_LEN]})
end procedure --DisplayWavInfo()

function Convert(integer signed)
  return remainder((signed + 128),256) - 128
end function

procedure Graph(sequence WaveInfo)
atom buff_addr
sequence p1,p2
integer rate, DataLen, y_scale
    DataLen = WaveInfo[siDATA_LEN]
    rate = floor(DataLen/640)
    y_scale = floor(480/256)
    buff_addr = WaveInfo[siDATA_BUFF]
    p1 = {0,300}
    for i = 0 to 639 do
	p2 = {i,300-y_scale*(Convert(peek(buff_addr+i*rate)))}
	draw_line(15,{p1,p2})
	p1 = p2
    end for
end procedure

procedure ProgressBar(sequence WaveInfo, integer idx)
atom start, delta, total
integer BarPos, PrevPos
    total = WaveInfo[siDATA_LEN]/WaveInfo[siSPS]/WaveInfo[siCHANNELS]
    start = time()
    PrevPos = 0
    while not SoundDone(idx) do
      delta = time() - start
      BarPos = floor(delta/total*639)
      draw_line(iAPP_BK_COLOR,{{PrevPos,478},{PrevPos,420}})
      draw_line(WHITE,{{BarPos,478},{BarPos,420}})
      PrevPos = BarPos
      delay(.1)
      if get_key() != -1  then
	StopSound(idx)
	exit
      end if
    end while
    draw_line(iAPP_BK_COLOR,{{PrevPos,478},{PrevPos,420}})
end procedure

function AddEcho(sequence WaveInfo)
atom buffer, NewBuffer, a, b, Att, mdelay
sequence InStr
integer s, len, gap
    position(2,1)
    puts(1,"Echo delay (miliseconds)? ")
    InStr = gets(0)
    mdelay = AToI(InStr)
    position(2,1)
    Clreol()
    puts(1,"Echo level (%)?")
    InStr = gets(0)
    Att = AToI(InStr)
    len = WaveInfo[siDATA_LEN]
    NewBuffer = allocate(len)
    if not NewBuffer then
	return WaveInfo
    end if
    lock_memory(NewBuffer,len)
    buffer = WaveInfo[siDATA_BUFF]
    gap = floor(mdelay/1000*WaveInfo[siSPS])
    position(2,1)
    Clreol()
    puts(1,"Adding echo to "&FileName&'\n')
    mem_copy(NewBuffer,buffer,gap)
    for i = gap to len do
	if remainder(i,100) = 0 then
	  position(3,1) 
	  ? i
	end if
	a = Convert(peek(buffer+i-gap))*Att/100
	b = Convert(peek(buffer+i))
	s = floor(.7*(a + b))
	if s > 128 then
	    s = 127
	elsif s < - 128 then
	    s = - 128
	end if
	s = remainder(floor(s)+256,256)
	poke(NewBuffer+i,s)
    end for
    free(buffer)
    WaveInfo[siDATA_BUFF] = NewBuffer
    position(2,1)
    Clreol()
    position(3,1)
    Clreol()
    return WaveInfo
end function

function GetCommand(sequence HotKeys)
-- wait for a valid command and return it.
integer k
    k = -1
    while not find(k,HotKeys) do
	k = get_key()
	if k >= 'a' and k <= 'z' then
	    k = k - 'a' + 'A'
	end if
    end while
    return k
end function -- GetCommand()

Init()

integer Cmd, OldSPS , junk
integer Times
sequence OrigName

Cmd = 'N'
WaveInfo = -1
FileName = ""

while Cmd != 'Q' do
    position(1,1)
    puts(1,"<A>add echo <L>oop <P>lay <V>olume  <R>ate <N>ew <S>top <Q>uit.\n")
    Cmd = GetCommand("APVRNQSL")
    if Cmd = 'P' then
	if sequence(WaveInfo) then
	  idx = PlaySound(WaveInfo, 0)
	  ProgressBar(WaveInfo,idx)
	end if

    elsif Cmd = 'A' then
	if sequence(WaveInfo) then
	  WaveInfo = AddEcho(WaveInfo)
	  Graph(WaveInfo)
	  idx = PlaySound(WaveInfo,0)
	  ProgressBar(WaveInfo,idx)
	end if
    elsif Cmd = 'L' then
	if sequence(WaveInfo) then
	  idx = PlaySound(WaveInfo, 1)
	end if
	
    elsif Cmd = 'V' then
      Times = AToI(PromptIn("Volume level to set?(0..7)"))
      if integer(Times) then
	volume = remainder(Times,8)
	SetVolume(VOICE_VOLUME,volume)
      end if
    elsif Cmd = 'R' then
      if sequence(WaveInfo) then
	Times = AToI(PromptIn("Which sampling rate do you want to test? (4000..23000)"))
	if Times >= 4000 and Times <= 23000 then
	   OldSPS = WaveInfo[siSPS]
	   WaveInfo[siSPS] = Times
	   idx = PlaySound(WaveInfo,0) 
	   WaveInfo[siSPS] = OldSPS
	end if
      end if
    elsif Cmd = 'N' then
      junk = graphics_mode(-1)
      OrigName = FileName
      FileName = ChooseFile(sWavDir&"*.WAV")
      junk = graphics_mode(18)
      SetAppColors(iAPP_BK_COLOR,iAPP_TEXT_COLOR)
      clear_screen()
      if length(FileName) then
	puts(1,"\nLoading file "&FileName)
	WaveInfo = LoadWaveFile(FileName)
      else
	FileName = OrigName
      end if
      if sequence(WaveInfo) then
	 DisplayWavInfo(FileName,WaveInfo)
	 Graph(WaveInfo)
      else
	 printf(1,"Failed to open %s\n",{FileName})
      end if
    elsif Cmd = 'S' then
	StopSound(-1)
    elsif Cmd = 'Q' then
	exit
    end if
end while
-- clean up before quitting
CleanUp(0)

