include graphics.e


procedure write_text(integer color, sequence text)
    text_color(color)
    for i=1 to length(text) do
        position(3*i+5,(40-length(text[i]))/2+1)
        puts(1,text[i])
    end for
end procedure


sequence x,y,speed,prev,show,buff
integer snowNum,wind,windCount,showCount,buffCount
object junk

buff={{"\" L O V E ' S   S E C R E T \"",  -- example text
       "written by",
       "William Blake (1757-1827)"},
      {"Never seek to tell thy love,",
       "Love that never told can be,",
       "For the gentle wind does move",
       "Silently, invisibly."},
      {"I told my love, I told my love,",
       "I told her all my heart;",
       "Trembling, cold, in ghastly fears,",
       "Ah, she did depart!"},
      {"Soon as she was gone from me,",
       "A traveler came by,",
       "Silently, invisibly",
       "He took her with a sigh."}}

snowNum=600   -- change this number to reduce/increase running speed.

junk=graphics_mode(13)
junk=palette(1,{20,20,20})  -- color for the slowest snow speed
junk=palette(2,{35,35,35})
junk=palette(3,{50,50,50})  -- color for the fastest snow speed
junk=palette(9,{0,0,0})  -- color of texts

x=rand(repeat(320,snowNum))-1
y=-rand(repeat(200,snowNum))
speed=rand(repeat(3,snowNum))  -- 3 speed layers of snow falling
prev=repeat(0,snowNum)

-- following code determine fading speed and displaying duration of texts.
show=repeat(0.1,9)&repeat(0,80)&repeat(-0.1,9)&repeat(0,10)
for i=2 to length(show) do
    show[i]=show[i]+show[i-1]
end for

showCount=0
buffCount=0
windCount=0

while get_key()=-1 do

    showCount=showCount+1
    if showCount>length(show) then
        showCount=0
        if buffCount>0 then write_text(0,buff[buffCount]) end if
        buffCount=buffCount+1
        if buffCount>length(buff) then buffCount=1 end if
        write_text(9,buff[buffCount])
    else
        junk=palette(9,{23,23,53}*show[showCount])
    end if

    if windCount=0 then
        windCount=rand(50)  -- random wind blowing duration
        wind=rand(3)-2      -- random wind direction
    end if
    windCount=windCount-1

    for i=1 to snowNum do
        junk=get_pixel({x[i],y[i]})
        if junk>0 and junk<4 then
            pixel(prev[i],{x[i],y[i]})
        end if
        x[i]=x[i]+rand(3)-2+wind
        if x[i]<0 then x[i]=x[i]+320 end if
        if x[i]>319 then x[i]=x[i]-320 end if
        y[i]=y[i]+speed[i]
        if y[i]>199 then y[i]=0 end if
        prev[i]=get_pixel({x[i],y[i]})
        pixel(speed[i],{x[i],y[i]})
    end for

end while
junk=graphics_mode(-1)

