%
% "instab.t" compresses text files by inserting tabs
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

const Out_file_name : string := "instab.fil"
const Tab_size : int := 8

var In_file_name : string
var In_file, Out_file : int
var Line: string


program

    prompt "name of file to compress:"
    get In_file_name 

    In_file := open( In_file_name, "r" )
    Out_file := open( Out_file_name, "w" )

    assert In_file ~= 0 and Out_file ~= 0

    loop

        exit when eof( In_file ) 
        get : In_file, Line : *
        put : Out_file, insert_tabs( Line )

    end loop

    if close( In_file ) = 0 or close( Out_file ) = 0 then

        put "file close error"

    end if

    put In_file_name, " -> ", Out_file_name 

end program


function insert_tabs( in : string ) : string

    var i, j, k : int
    var tab : boolean
    var out : string

    j := 0

    for i := 0...255 do

        exit when in[i] = '\0'

        if in[i] = ' ' then

            tab := true

            for k := 1...Tab_size - 1 do

                if in[i+k] ~= ' ' then

                    tab := false
                    exit

                end if

            end for

            if tab then

                out[j] := '\t'            % ascii tab character
                i := i + Tab_size - 1

            else

                out[j] := in[i]

            end if

        else

            out[j] := in[i]

        end if

        incr j

    end for

    out[j] := '\0'

    return out

end function