%
% "mat_test.t" demonstrats matrix functions and
% related routines.
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

const DIM : int := 4

program

    var a, b, c : rmatrix
    var x, y : rvector
    var det : real
    label program_exit :

    y[0] :=  5.0
    y[1] := -1.0
    y[2] :=  8.0
    y[3] :=  2.0

    a[0,0] :=  2.0
    a[0,1] :=  1.0
    a[0,2] :=  5.0
    a[0,3] :=  1.0

    a[1,0] :=  1.0
    a[1,1] :=  1.0
    a[1,2] := -3.0
    a[1,3] := -4.0

    a[2,0] :=  3.0
    a[2,1] :=  6.0
    a[2,2] := -2.0
    a[2,3] :=  1.0

    a[3,0] :=  2.0
    a[3,1] :=  2.0
    a[3,2] :=  2.0
    a[3,3] := -3.0

    put "matrix A:"
    print_mat( a )
    det := invert( a, b, false )

    if det = 0.0 then

        put "is singular"
        goto program_exit

    end if
    
    put "determinant of A = ", det
    put "the inverse of A is:"
    print_mat( b )

    put "check result:"
    mul_mat_mat( a, b, c )
    print_mat( c )

    put "solve A x = y"
    put " for y: "
    put "y0 = ", y[0]:15:6
    put "y1 = ", y[1]:15:6
    put "y2 = ", y[2]:15:6
    put "y3 = ", y[3]:15:6

    mul_mat_vec( b, y, x )
    put " solution is:"
    put "x0 = ", x[0]:15:6
    put "x1 = ", x[1]:15:6
    put "x2 = ", x[2]:15:6
    put "x3 = ", x[3]:15:6

    put "solve A = M + S, where M is symmetric and S is skew-symmetric"
    sym_mat( a, b, c )
    put "symmetric part"
    print_mat( b )
    put "skew-symmetric part"
    print_mat( c )

    program_exit:

end program