%
% "newton.t" uses Newton iteration to solve a 
% simultaneous nonlinear set of equations:
%
%       f1(x,y) = x^3 - x^2 * y + y^2 - 3.526
%       f2(x,y) = x^3 + y^3 - 14.911
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

const DIM : int := 2

program

    var p, q : rmatrix
    var x : real := 1.0
    var y : real := 2.0
    var det, f1, f2 : real

    var i : int
    
    for i := 1 ... 5 do

        p[0,0] := 3 * x^2 - 2 * x * y
        p[0,1] := 2 * y - x^2
        p[1,0] := 3 * x^2
        p[1,1] := 3 * y^2

        
        det := invert( p, q, true ) 

        if det ~= 0.0 then

            f1 := x^3 - x^2 * y + y^2 - 3.526
            f2 := x^3 + y^3 - 14.911

            x := x - q[0,0] * f1 - q[0,1] * f2
            y := y - q[1,0] * f1 - q[1,1] * f2

            put "x = ", x:12:8 , ", ", "y = ", y:12:8

        else

            put "singular"
            exit

        end if

    end for

end program