%
% "remtab.t" removes tabs; see instab.t
%
%   Sample program for the T Interpreter by:
%
%   Stephen R. Schmitt
%   962 Depot Road
%   Boxborough, MA 01719
%

const Out_file_name : string := "remtab.fil"
const Tab_width : int := 8

var In_file_name: string
var In_file, Out_file: int
var Line: string


program

    label program_exit :

    prompt "file to de-compress:"
    get In_file_name 
    
    In_file := open( In_file_name, "r" )

    if In_file = 0 then

        put "cannot open file"
        goto program_exit

    end if

    Out_file := open( Out_file_name, "w" )
    put "Removing tabs . . . "

    loop

        exit when eof( In_file ) 
        get :In_file, Line : *
        put :Out_file, remove_tabs( Line )

    end loop

    if close( In_file ) = 0 or close( Out_file ) = 0 then

        put "file close error"

    end if
    
    put In_file_name, " -> ", Out_file_name 

    program_exit:

end program


function remove_tabs( in: string ) : string

    var out : string
    var i, j, k : int

    j := 0
    for i := 0 ... length( in ) - 1 do

        if in[i] = '\t' then

            for k := 1...Tab_width do

                out[j] := ' '
                incr j

            end for

        else

            out[j] := in[i]
            incr j

        end if

    end for

    out[j] := '\0'

    return out    

end function