-- extgraph.e   - extended graphics routines for Euphoria
-- Jeff Zeitlin (jeff.zeitlin@execnet.com)
-- builds on routines in graphics.e

include graphics.e

-- regular_polygon
-- draws an n-sided polygon with all sides and angles equal.
-- user specifies center location, radius, and rotation angle; 
-- regular_polygon computes the points and calls polygon.
-- an angle of zero places a corner directly to the right on
-- a horizontal line with the center point (i.e., a square is
-- displayed as a diamond, rotated 45 degrees).

constant pi = 3.141592653585
constant X = 1
constant Y = 2

global procedure regular_polygon(sequence center,-- {x,y} center of polygon
				 integer sides,  -- number of sides
				 integer radius, -- size corner-to-center
				 atom angle,     -- clockwise rotation (radians)
				 integer colr,   -- color to draw/fill
				 integer fill)   -- fill in with color?
    sequence circ_points
    atom int_angle
    atom angle_incr
    sequence newpoint
    
    circ_points = {}
    angle_incr = 2 * pi / sides
    for i = 0 to sides do
	int_angle = angle_incr * i + angle
	newpoint = {radius * cos(int_angle) + center[X],
		    radius * sin(int_angle) + center[Y]}
	circ_points = append(circ_points,newpoint)
    end for
    polygon(colr,fill,circ_points)
end procedure                                
				 
