-- math.e
-- Jeff Zeitlin (jeff.zeitlin@execnet.com)

-- Mathematical functions for Euphoria v1.5.  Those functions not requiring
-- the ARCTAN function should also work on v1.4.

-- interface:

-- global constant LOGBASE_E
-- The base value for natural (Napieran) logarithms - the value of x for
-- log(x) = 1.

-- global constant PI
-- The ratio of a circle's diameter to its circumference

-- object o
-- o = sinh(object x)
-- The hyperbolic sine of x.

-- object o
-- o = cosh(object x)
-- The hyperbolic cosine of x.

-- object o
-- o = tanh(object x)
-- The hyperbolic tangent of x.

-- object o
-- o = arcsinh(object x)
-- The value of o for which sinh(o) = x - the hyperbolic arcsine of x.

-- object o
-- o = arccosh(object x)
-- The value of o for which cosh(o) = x - the hyperbolic arccosine of x.

-- object o
-- o = arctanh(object x)
-- The value of o for which cosh(o) = x - the hyperbolic arctangent of x.

-- object o
-- o = logbase(object b, object n)
-- return logarithm of n to the base b

-- object o
-- o = arcsin(object x)
-- The value of o for which sin(o) = x - the arcsine of x.
-- Result will be in range of +/- PI/2

-- object o
-- o = arccos(object x)
-- The value of o for which cos(o) = x - the arccosine of x
-- Result will be in range of +/- PI/2

global constant LOGBASE_E = 2.718281828459045

global constant PI = 4 * arctan(1.0)

global function cosh(object x)
  return ((power(LOGBASE_E,x)+power(LOGBASE_E,-x))/2)
end function

global function sinh(object x)
  return ((power(LOGBASE_E,x)-power(LOGBASE_E,-x))/2)
end function

global function tanh(object x)
  return sinh(x)/cosh(x)
end function

global function arcsinh(object x)
  return log((2*x)+1)
end function

global function arccosh(object x)
  return log((2*x)-1)
end function

global function arctanh(object x)
  return (log((x+1)/(x-1))/2)
end function

global function logbase(object b, object n)
  return log(n)/log(b)
end function

global function arcsin(object x)
  return arctan(x/sqrt(1-(x*x)))
end function

global function arccos(object x)
  return arctan(sqrt(1-(x*x))/x)
end function
