-- queue.e - FIFO queue routunes
-- by Jeff Zeitlin (jeff.zeitlin@execnet.com)

-- implements a queue type for Euphoria with proper syntax.

-- queue q
--      declares the type queue, and checks to see if it is initialized

-- queue q
-- q = qinit()
--      creates a new queue, returns a "handle" to be used to refer to this
--      queue hereafter.

-- qenter(queue q, object o)
--      puts object o at the end of queue q

-- object o
-- o = qremove(queue q)
--      takes object off front of queue q, and returns it.

-- boolean/integer b
-- b = qempty(queue q)
--      returns TRUE (1) if there are no objects on queue q, FALSE (0) otherwise

-- qclear(queue q)
--      makes existing queue q empty, discarding all information on it.


-- private procedures and variables

sequence queues
queues = {}

-- public interface

global type queue(integer q)
    return q <= length(queues)
end type

global function qinit()
    queues = append(queues,{})
    return length(queues)
end function

global procedure qenter(queue q, object o)
    queues[q] = append(queues[q], o)
end procedure

global function qempty(queue q)
    return length(queues[q]) = 0
end function

global function qremove(queue q)
    object val
    
    if qempty(q) then
	printf(1,"%s","queue underflow error\n")
	abort(1)
    end if
    val = queues[q][1]
    queues[q] = queues[q][2..length(queues[q])]
    return val
end function

global procedure qclear(queue q)
    queues[q] = {}
end procedure
