{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-}
{$M 16384,0,655360}
{*****************************************************************************}
{* COM Port Status/Information Demonstration Program                         *}
{* Copyright (C) 1990-1993, Rising Edge Data Services       Updated 08/09/93 *}
{*                                                                           *}
{* This short program demonstrates how you can utilize the ASYNC predefined  *}
{* global variables.  It will display a list of possible COM port addresses  *}
{* and report the status of each one of ASYNC's internal logical port        *}
{* definitions.                                                              *}
{*****************************************************************************}

Program AsyncPortTest;

Uses Async;

Var
  ComPort : Byte;                      {Logical port counter}
  AvailPorts : Byte;                   {Usable port counter}
  PortStat : Byte;                     {Port status byte for online check}
  Temp : String[16];                   {Temporary used for display ops}

{*****************************************************************************}
{*                                                                           *}
{* Function Word2Hex(Nbr:Word) : String;                                     *}
{* --- Returns the HEX value of (Nbr) as a 4-character string                *}
{*                                                                           *}
{*****************************************************************************}

Function Word2Hex(Nbr:Word) : String;

Var
  Count : Byte;                        {Digit counter/index}
  Digit : Byte;                        {Digit isolated from (Nbr) passed}
  Hex : String[4];                     {Conversion buffer/return string}

Begin
  For Count := 4 Downto 1 Do
    Begin
      Digit := Nbr And $0F;            {Isolate least significant digit}
      Inc(Digit,48);                   {Add ASCII digit offset}
      If Digit > 57 Then Inc(Digit,7); {Add offset for letters A-F}
      Hex[Count] := Chr(Digit);        {Store result in return string}
      Nbr := Nbr SHR 4;                {Move next digit to 1's position}
    End;

  Hex[0] := #4;                        {Force return string length to 4 chars}
  Word2Hex := Hex;                     {Return ASCII HEX result string}
End;

{*****************************************************************************}

Begin
  Assign(Output,'');                   {Use DOS output to allow redirection}
  Rewrite(Output);
  Writeln;
  Writeln('ASYNC Port Test                         (C) 1990-1993 Rising Edge Data Services');
  Writeln;

  {Check for '/P' command line parameter}
  {If present, add PS/2 ports to port map}

  If ParamCount > 0 Then
    If (ParamStr(1) = '/p') Or (ParamStr(1) = '/P') Then
      AddPS2Ports(True)
    Else
      Begin
        Writeln('Usage: PORTTEST [/P]');
        Writeln('       /P : Scan for COM ports on a IBM PS/2');
        Halt(1);
      End;

  {Display report header}

  AvailPorts := 0;
  Writeln(' Logical | Port    |           | Port    | Hardware |       ');
  Writeln(' Port #  | Address | Interrupt | Exists? | FIFOs?   | Status');
  Writeln('---------|---------|-----------|---------|----------|--------');

  {Display status of logical ports}

  For ComPort := 1 To C_MaxCom Do
    Begin
      Write(ComPort:5,'    |  ');
      Write(Word2Hex(C_PortAddr[ComPort]),'h  |');
      Write(C_PortInt[ComPort]:6,'     |');
      If C_PortExist[ComPort] Then
        Begin
          Write('   YES   |');
          If C_FIFOExist[ComPort] Then Temp := 'YES' Else Temp := ' NO';
          Write(Temp:6,'    | ');
          PortStat := Port[C_PortAddr[ComPort] + C_MSR] And $F0;
          If PortStat > 0 Then Temp := 'Online' Else Temp := 'Offline';
          Writeln(Temp);
          Inc(AvailPorts);
        End
      Else
        Writeln('    NO   |   ---    | ------');
    End;

  Writeln(#13#10'Total ASYNC-compatable ports available: ',AvailPorts);
End.
