   (* BCDFIN.INC -- transcendental functions needed for financial *)
   (*               calculations in TURBOBCD                      *)
   (*                                                             *)
   (*   ln1:    real; -- returns ln of 1+argument                 *)
   (*   eton:   real; -- returns e raised to its argument         *)
   (*   sqroot: real --  returns square root of its argument      *)
   (*                                                             *)
   (*   ln1 and eton are from Abramowitz and Stegun, Handbook of  *)
   (*   Mathematical Functions, Dover, 1965                       *)
   (*   sqroot uses binary search                                 *)
   (*                                                             *)
   (*    Blaise away,                                             *)
   (*                        Bob Wooster, CIS 72415,1602          *)
   (*                        June 1985                            *)

   FUNCTION ln1(x : Real) : Real;
         { calculate ln(1+x) for 0<=x<=1 }
      VAR temp : Real;
      BEGIN {  ln1 }
         IF (x < 0) OR (x > 1) THEN ln1 := 0.0 ELSE BEGIN
            ln1 :=
            +0.9999964239*x
            -0.4998741238*x*x
            +0.3317990258*x*x*x
            -0.2407338084*x*x*x*x
            +0.1676540711*x*x*x*x*x
            -0.0953293897*x*x*x*x*x*x
            +0.0360884937*x*x*x*x*x*x*x
            -0.0064565442*x*x*x*x*x*x*x*x;
         END; {else}
      END; { ln1 }

   FUNCTION factorial(r : Real) : Real;
      BEGIN { function factorial(r: real) }
         IF r <= 1.0 THEN factorial := 1.0
         ELSE factorial := r*factorial(r-1.0);
      END; { function factorial(r: real) }

   FUNCTION ipower(r : Real; n : Integer) : Real;
      function ipower1(r: real; n:integer): real; {this one's recursive}
      begin   { ipower1 }
         if n = 1 then ipower1 := r
         else ipower1 := r*ipower1(r, n-1);
      end;    { ipower1 }

   var negative: boolean; temp : real;
      BEGIN { function ipower(r: real; n: integer): real }
         negative := n < 0;
         if negative then n := n*(1);
         if n = 0 then temp := 1
         else IF n = 1 THEN temp := r
         ELSE temp := r*ipower1(r, n-1);
         if negative then temp := 1.0/temp;
         ipower := temp;
      END; { function ipower(r: real; n: integer): real }

   FUNCTION nexp(r : Real) : Real;
         { calculate e^r }
      VAR i : Integer; t : Real;
      BEGIN { function nexp(r: real) }
         t := 1.0;
         FOR i := 1 TO 20 DO t := t+(ipower(r, i)/factorial(i));
         nexp := t;
      END; { function nexp(r: real) }

   FUNCTION sqroot(x : Real) : Real;
         { find square root by binary search }
      VAR guess, high, low, oldguess, err : Real;
      BEGIN { sqroot }
         guess := x/2.0; low := 0.01*x; high := x;
         REPEAT
            oldguess := guess;
            IF guess*guess < x THEN BEGIN
               low := guess; guess := (high+guess)/2;
            END {if}
            ELSE BEGIN
               high := guess; guess := (low+guess)/2;
            END; {else}
            err := abs(guess-oldguess);
         UNTIL err < 0.00000001;
         sqroot := guess;
      END; { sqroot }

(* end of file BCDFIN.PAS *)

