{$C-,V-,K-,R-,U-}

(*****************************************)
(*                                       *)
(*           Turbo Pascal 3.0A           *)
(*                                       *)
(*****************************************)

PROGRAM
   crc_80_bit;
TYPE
   STRING4       = STRING[4];
   STRING60      = STRING[60];
   STRING80      = STRING[80];
   STRING255     = STRING[255];
   CHARACTERS    = STRING[255];
   CRCREG        = ARRAY[1..5] OF INTEGER;
VAR
   crc_reg_1    : INTEGER;
   crc_reg_2    : INTEGER;
   crc_reg_3    : INTEGER;
   crc_reg_4    : INTEGER;
   crc_reg_5    : INTEGER;
   crc_input    : INTEGER;

   PROCEDURE
      crc80_calc;
   BEGIN
      inline($B9/>$08);			{	mov	cx,8		}
      inline($A1/crc_input);		{	mov	ax,crc_input	}
      inline($D0/$D8);			{  u12:	rcr	al,1		}
      inline($8B/$1E/crc_reg_5);	{	mov     bx,crc_reg_5	}
      inline($D1/$DB);			{	rcr     bx,1		}
      inline($89/$1E/crc_reg_5);	{	mov     crc_reg_5,bx	}
      inline($8B/$1E/crc_reg_4);	{	mov     bx,crc_reg_4	}
      inline($D1/$DB);			{	rcr     bx,1		}
      inline($89/$1E/crc_reg_4);	{	mov     crc_reg_4,bx	}
      inline($8B/$1E/crc_reg_3);	{	mov     bx,crc_reg_3	}
      inline($D1/$DB);			{	rcr     bx,1		}
      inline($89/$1E/crc_reg_3);	{	mov     crc_reg_3,bx	}
      inline($8B/$1E/crc_reg_2);	{	mov     bx,crc_reg_2	}
      inline($D1/$DB);			{	rcr     bx,1		}
      inline($89/$1E/crc_reg_2);	{	mov     crc_reg_2,bx	}
      inline($8B/$1E/crc_reg_1);	{	mov     bx,crc_reg_1	}
      inline($D1/$DB);			{	rcr     bx,1		}
      inline($89/$1E/crc_reg_1);	{	mov     crc_reg_1,bx	}
      inline($73/$03);			{	jnc	u22		}
      inline($EB/$06/$90);		{	jmp	u33		}
      inline($E2/$C5);			{  u22:	loop	u12             }
      inline($EB/$3F/$90);		{	jmp	u44		}
      inline($8B/$1E/crc_reg_1);	{  u33:	mov     bx,crc_reg_1	}
      inline($81/$F3/$8321);		{	xor	bx,8321h	}
      inline($89/$1E/crc_reg_1);	{	mov     crc_reg_1,bx	}
      inline($8B/$1E/crc_reg_2);	{	mov     bx,crc_reg_2	}
      inline($81/$F3/$5DB6);		{	xor	bx,5DB6h	}
      inline($89/$1E/crc_reg_2);	{	mov     crc_reg_2,bx	}
      inline($8B/$1E/crc_reg_3);	{	mov     bx,crc_reg_3	}
      inline($81/$F3/$2141);		{	xor	bx,2141h	}
      inline($89/$1E/crc_reg_3);	{	mov     crc_reg_3,bx	}
      inline($8B/$1E/crc_reg_4);	{	mov     bx,crc_reg_4	}
      inline($81/$F3/$7EA9);		{	xor	bx,7EA9h	}
      inline($89/$1E/crc_reg_4);	{	mov     crc_reg_4,bx	}
      inline($8B/$1E/crc_reg_5);	{	mov     bx,crc_reg_5	}
      inline($81/$F3/$1D54);		{	xor	bx,1D54h	}
      inline($89/$1E/crc_reg_5);	{	mov     crc_reg_5,bx	}
      inline($EB/$BD);			{	jmp     u22		}
      inline($90);			{  u44: nop                     }
   END;

   FUNCTION
      Hex( h : INTEGER ) : STRING4;
   VAR
      ans  : STRING4;
      hh   : INTEGER;
      dh   : INTEGER;
      i    : INTEGER;
   BEGIN
      ans:='    ';
      hh:=h;
      FOR i:=4 DOWNTO 1 DO BEGIN
         dh:=hh AND $000F;
         hh:=hh shr 4;
         IF dh<10 THEN
            ans[i]:=CHR(ORD('0')+dh)
         ELSE
            ans[i]:=CHR(ORD('A')+dh-10);
      END;
      Hex:=ans;
   END;

   PROCEDURE
       calculate(VAR s : CHARACTERS);
   VAR
       j    : INTEGER;
   BEGIN
       crc_reg_1:=0;
       crc_reg_2:=0;
       crc_reg_3:=0;
       crc_reg_4:=0;
       crc_reg_5:=0;
       FOR j:=1 TO Length(s) DO BEGIN
           crc_input:=ORD(s[j]);
           crc80_calc;
       END;
       crc_input:=0;
       FOR j:=1 TO 10 DO
           crc80_calc;
   END;

VAR
   pstr        : STRING255;
BEGIN
   lowvideo;
   clrscr;
   writeln('80 Bit CRC Engine.  For proposed use in GT POWER Netmail Software.');
   writeln('Copyright (c) 1988, by P&M Software Co.');
   writeln;
   REPEAT
       write('Enter string, or <CR> to end: ');
       readln(pstr);
       IF (Length(pstr)=0) THEN halt;
       calculate(pstr);
       writeln('The CRC is: ',Hex(crc_reg_1),'-',
                               Hex(crc_reg_2),'-',
                                Hex(crc_reg_3),'-',
                                 Hex(crc_reg_4),'-',
                                  Hex(crc_reg_5));
       writeln;
   UNTIL (FALSE);
END.
