{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{*  Containers Library demo                                               *}
{**************************************************************************}

program Arrays1;

{$X+}

{ Sample program for using a standard array }

uses Containr, ctArrays,
     {$ifdef Windows}
     WinCtr;
     {$else}
     Crt;
     {$endif}

type
  PWeatherInfo = ^TWeatherInfo;
  TWeatherInfo = record
    Location : string[20];
    Humidity : Integer;
    Rain : Integer;
  end; { TWeatherInfo }

procedure SetWeatherValues(ALocation : string; AHumidity, ARain : Integer;
  var WeatherRec : TWeatherInfo);
begin
  with WeatherRec do
  begin
    Location := ALocation;
    Humidity := AHumidity;
    Rain := ARain;
  end; { with }
end;

procedure DisplayWeatherData(WeatherData : PSequence);
var
  i : Integer;
begin
  with WeatherData^ do
    for i := FirstIndex to LastIndex do
      with PWeatherInfo(At(i))^ do
        writeln('Hour: ', i:2, ':00', '':3, Location, '':20 -
          Length(Location), Humidity, '':5, Rain:5);
end;

procedure FindLowHumidityValue(WeatherData : PSequence);
var
  Item : Pointer;
  Index : LongInt;

  function HasLowHumidity(Item : PWeatherInfo) : Boolean; far;
  begin
    HasLowHumidity := (Item^.Humidity < 22);
  end;

begin
  Item := WeatherData^.FirstThat(@HasLowHumidity, Index);
  writeln ('First with low humidity (H < 22):');
  with PWeatherInfo(Item)^ do
    writeln('Hour: ', Index:2, ':00', '':3, Location, '':20 -
      Length(Location), Humidity, '':5, Rain:5);
end;

var
  MorningWeatherData : PStdArray;
  WeatherInfo: TWeatherInfo;

begin
  ClrScr;

  { Create the array }
  MorningWeatherData := New(PStdArray, Init(7, 11, SizeOf(TWeatherInfo)));

  { Insert the items in the array }
  with MorningWeatherData^ do
  begin
    SetWeatherValues('Miami', 34, 0, WeatherInfo);
    AtInsert(7, @WeatherInfo);
    SetWeatherValues('Helsinski', 23, 3, WeatherInfo);
    AtInsert(8, @WeatherInfo);
    SetWeatherValues('Canada', 26, 2, WeatherInfo);
    AtInsert(9, @WeatherInfo);
    SetWeatherValues('Berlin', 28, 5, WeatherInfo);
    AtInsert(10, @WeatherInfo);
    SetWeatherValues('Melbourne', 20, 0, WeatherInfo);
    AtInsert(11, @WeatherInfo);
  end; { with }

  DisplayWeatherData(MorningWeatherData);
  writeln;
  FindLowHumidityValue(MorningWeatherData);

  { Dispose of the array }
  Dispose(MorningWeatherData, Done);
end.