{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{*  Containers Library demo                                               *}
{**************************************************************************}

program Arrays2;

{$X+}

{ Sample program for accesing directly a standard array }

uses Containr, ctArrays,
     {$ifdef Windows}
     WinCtr;
     {$else}
     Crt;
     {$endif}

type
  PWeatherInfo = ^TWeatherInfo;
  TWeatherInfo = record
    Location : string[20];
    Humidity : Integer;
    Rain : Integer;
  end; { TWeatherInfo }

procedure DisplayWeatherData(WeatherData : PSequence);
var
  i : Integer;
begin
  with WeatherData^ do
    for i := FirstIndex to LastIndex do
      with PWeatherInfo(At(i))^ do
        writeln('Hour: ', i:2, ':00', '':3, Location, '':20 -
          Length(Location), Humidity, '':5, Rain:5);
end;

procedure FindLowHumidityValue(WeatherData : PSequence);
var
  Item : Pointer;
  Index : LongInt;

  function HasLowHumidity(Item : PWeatherInfo) : Boolean; far;
  begin
    HasLowHumidity := (Item^.Humidity < 22);
  end;

begin
  Item := WeatherData^.FirstThat(@HasLowHumidity, Index);
  writeln ('First with low humidity (H < 22):');
  with PWeatherInfo(Item)^ do
    writeln('Hour: ', Index:2, ':00', '':3, Location, '':20 -
      Length(Location), Humidity, '':5, Rain:5);
end;

var
  MorningWeatherData : PHugeArray;
  WeatherInfo: TWeatherInfo;

begin
  ClrScr;

  { Create the array }
  MorningWeatherData := New(PHugeArray, Init(7, 11, SizeOf(TWeatherInfo)));

  { Insert the items in the array }
  with MorningWeatherData^ do
  begin
    with PWeatherInfo(At(7))^ do
    begin
      Location := 'Miami';
      Humidity := 34;
      Rain := 0;
    end;
    with PWeatherInfo(At(8))^ do
    begin
      Location := 'Helsinski';
      Humidity := 23;
      Rain := 3;
    end;
    with PWeatherInfo(At(9))^ do
    begin
      Location := 'Canada';
      Humidity := 26;
      Rain := 2;
    end;
    with PWeatherInfo(At(10))^ do
    begin
      Location := 'Berlin';
      Humidity := 28;
      Rain := 5;
    end;
    with PWeatherInfo(At(11))^ do
    begin
      Location := 'Melbourne';
      Humidity := 20;
      Rain := 0;
    end;
  end; { with }

  DisplayWeatherData(MorningWeatherData);
  writeln;
  FindLowHumidityValue(MorningWeatherData);

  { Dispose of the array }
  Dispose(MorningWeatherData, Done);
end.