{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{**************************************************************************}

unit ObjTests;

{$X+}

interface

uses Objects,
     ctCollec, ctArrays, ctBTrees, ctBpTree,
     Types;

{ Arrays }
procedure TestTStdArray;
procedure TestTResizableStdArray;
procedure TestTSortedStdArray;
procedure TestTStdObjectArray;
procedure TestTResizableStdObjectArray;
procedure TestTSortedStdObjectArray;
procedure TestTHugeArray;
procedure TestTResizableHugeArray;
procedure TestTSortedHugeArray;
procedure TestTHugeObjectArray;
procedure TestTResizableHugeObjectArray;
procedure TestTSortedHugeObjectArray;
procedure TestTStreamStdArray;
procedure TestTEmsStdArray;
procedure TestTStreamStdObjectArray;
procedure TestTEmsStdObjectArray;
procedure TestTStreamObjectArray;
procedure TestTEmsObjectArray;

{ Collections }
procedure TestTHugeCollection;
procedure TestTHugeSortedCollection;
procedure TestTHugeStringCollection;
procedure TestTHugeUnSortedStrCollection;

procedure TestTStreamCollection;
procedure TestTEmsCollection;
procedure TestTStreamSortedCollection;
procedure TestTEmsSortedCollection;
procedure TestTStreamStringCollection;
procedure TestTEmsStringCollection;
procedure TestTStreamUnSortedStrCollection;
procedure TestTEmsUnSortedStrCollection;

{ Linked Lists }
procedure TestTListSingle;
procedure TestTListDouble;
procedure TestTSortedListSingle;
procedure TestTSortedListDouble;

{ Tables }
procedure TestTTable;
procedure TestTObjectTable;

{ Queues }
procedure TestTQueue;
procedure TestTDoubleEndedQueue;

{ Stacks }
procedure TestTHugeCollectionStack;
procedure TestTArrayStack;
procedure TestTHugeArrayStack;
procedure TestTLinkedStack;
procedure TestTStreamStack;
procedure TestTEmsStack;

{ Binary trees }
procedure TestTBinaryTree;
procedure TestTAVLTree;

{ B Trees }
procedure TestTBTree;
procedure TestTObjectBTree;
procedure TestTBPlusTree;
procedure TestTObjectBPlusTree;

type
  PTestSortedStdArray = ^TTestSortedStdArray;
  TTestSortedStdArray = object(TSortedStdArray)
    function KeyOf(Item : Pointer) : Pointer; virtual;
  end; { TTestSortedStdArray }

type
  PTestSortedHugeArray = ^TTestSortedHugeArray;
  TTestSortedHugeArray = object(TSortedHugeArray)
    function KeyOf(Item : Pointer) : Pointer; virtual;
  end; { TTestSortedHugeArray }

type
  PTestSortedStdObjectArray = ^TTestSortedStdObjectArray;
  TTestSortedStdObjectArray = object(TSortedStdObjectArray)
    function KeyOf(Item : Pointer) : Pointer; virtual;
  end; { TTestSortedStdObjectArray }

type
  PTestSortedHugeObjectArray = ^TTestSortedHugeObjectArray;
  TTestSortedHugeObjectArray = object(TSortedHugeObjectArray)
    function KeyOf(Item : Pointer) : Pointer; virtual;
  end; { TTestSortedHugeObjectArray }

type
  PTestHugeSortedCollection = ^TTestHugeSortedCollection;
  TTestHugeSortedCollection = object(THugeSortedCollection)
    function KeyOf(Item : Pointer) : Pointer; virtual;
  end; { TTestHugeSortedCollection }

type
  PTestStreamSortedCollection = ^TTestStreamSortedCollection;
  TTestStreamSortedCollection = object(TStreamSortedCollection)
    function KeyOf(Item : Pointer) : Pointer; virtual;
  end; { TTestStreamSortedCollection }

type
  PTestEmsSortedCollection = ^TTestEmsSortedCollection;
  TTestEmsSortedCollection = object(TEmsSortedCollection)
    function KeyOf(Item : Pointer) : Pointer; virtual;
  end; { TTestEmsSortedCollection }

type
  PTestObjectBTree = ^TTestObjectBTree;
  TTestObjectBTree = object(TObjectBTree)
    function KeyOf(Item : Pointer) : Pointer; virtual;
  end; { TTestObjectBTree }

type
  PTestObjectBPlusTree = ^TTestObjectBPlusTree;
  TTestObjectBPlusTree = object(TObjectBPlusTree)
    function KeyOf(Item : Pointer) : Pointer; virtual;
  end; { TTestObjectBPlusTree }

const
  RTestHugeSortedCollection : TStreamRec = (
    ObjType : idTestHugeSortedCollection;
    VmtLink : Ofs(TypeOf(TTestHugeSortedCollection)^);
    Load    : @TTestHugeSortedCollection.Load;
    Store   : @TTestHugeSortedCollection.Store);

  RTestStreamSortedCollection : TStreamRec = (
    ObjType : idTestStreamSortedCollection;
    VmtLink : Ofs(TypeOf(TTestStreamSortedCollection)^);
    Load    : @TTestStreamSortedCollection.Load;
    Store   : @TTestStreamSortedCollection.Store);

  RTestEmsSortedCollection : TStreamRec = (
    ObjType : idTestEmsSortedCollection;
    VmtLink : Ofs(TypeOf(TTestEmsSortedCollection)^);
    Load    : @TTestEmsSortedCollection.Load;
    Store   : @TTestEmsSortedCollection.Store);


implementation

uses App, MsgBox,
     BsdTypes,
     ctLists, ctTables, ctFields, ctQueues, ctStacks, ctBiTree,
     Data, Display, Readers, Utils, TstScrpt;

{****************************************************************************}
{*                                                                          *}
{*                        EXPORTED OBJECT DECLARATIONS                      *}
{*                                                                          *}
{****************************************************************************}
{****************************************************************************}
{ TTestEMSSortedCollection object                                            }
{****************************************************************************}
{****************************************************************************}
{ TTestEMSSortedCollection.KeyOf                                             }
{****************************************************************************}
function TTestEmsSortedCollection.KeyOf(Item : Pointer) : Pointer;
begin
  KeyOf := PTestObject(Item)^.Text;
end;

{****************************************************************************}
{ TTestObjectBPlusTree object                                                }
{****************************************************************************}
{****************************************************************************}
{ TTestObjectBPlusTree.KeyOf                                                 }
{****************************************************************************}
function TTestObjectBPlusTree.KeyOf(Item : Pointer) : Pointer;
begin
  KeyOf := @PTestStaticObject(Item)^.Text;
end;

{****************************************************************************}
{ TTestObjectBTree object                                                    }
{****************************************************************************}
{****************************************************************************}
{ TTestObjectBTree.KeyOf                                                     }
{****************************************************************************}
function TTestObjectBTree.KeyOf(Item : Pointer) : Pointer;
begin
  KeyOf := @PTestStaticObject(Item)^.Text;
end;

{****************************************************************************}
{ TTestHugeSortedCollection object                                           }
{****************************************************************************}
{****************************************************************************}
{ TTestHugeSortedCollection.KeyOf                                            }
{****************************************************************************}
function TTestHugeSortedCollection.KeyOf(Item : Pointer) : Pointer;
begin
  KeyOf := PTestObject(Item)^.Text;
end;

{****************************************************************************}
{ TTestSortedHugeArray object                                                }
{****************************************************************************}
{****************************************************************************}
{ TTestSortedHugeArray.KeyOf                                                 }
{****************************************************************************}
function TTestSortedHugeArray.KeyOf(Item : Pointer) : Pointer;
begin
  KeyOf := @PTestRec(Item)^.Key;
end;

{****************************************************************************}
{ TTestSortedHugeObjectArray                                                 }
{****************************************************************************}
function TTestSortedHugeObjectArray.KeyOf(Item : Pointer) : Pointer;
begin
  KeyOf := @PTestStaticObject(Item)^.Text;
end;

{****************************************************************************}
{ TTestSortedStdArray object                                                 }
{****************************************************************************}
{****************************************************************************}
{ TTestSortedStdArray.KeyOf                                                  }
{****************************************************************************}
function TTestSortedStdArray.KeyOf(Item : Pointer) : Pointer;
begin
  KeyOf := @PTestRec(Item)^.Key;
end;

{****************************************************************************}
{ TTestSortedStdObjectArray                                                  }
{****************************************************************************}
function TTestSortedStdObjectArray.KeyOf(Item : Pointer) : Pointer;
begin
  KeyOf := @PTestStaticObject(Item)^.Text;
end;

{****************************************************************************}
{ TTestStreamSortedCollection object                                         }
{****************************************************************************}
{****************************************************************************}
{ TTestStreamSortedCollection.KeyOf                                          }
{****************************************************************************}
function TTestStreamSortedCollection.KeyOf(Item : Pointer) : Pointer;
begin
  KeyOf := PTestObject(Item)^.Text;
end;

{****************************************************************************}
{*                                                                          *}
{*                      EXPORTED FUNCTIONS AND PROCEDURES                   *}
{*                                                                          *}
{****************************************************************************}

{****************************************************************************}
{ TestTArrayStack                                                            }
{****************************************************************************}
procedure TestTArrayStack;
var
  Stack : PArrayStack;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  Stack := New(PArrayStack, Init(30, 50, SizeOf(TTestRec)));
  if Stack = nil
    then Exit;
  Reader := New(PTestRecReader, Init(Stack));
  Window := New(PResultsWindow, Init('TArrayStack test', Reader));
  InitTest(Reader, Window, nil);
  TestArrayStack(Stack);
  EndTest;
end;

{****************************************************************************}
{ TestTAVLTree                                                               }
{****************************************************************************}
procedure TestTAVLTree;
var
  Tree : PAVLTree;
  Reader : PTestAVLNodeReader;
  Window : PResultsWindow;
begin
  Tree := New(PAVLTree, Init);
  if Tree= nil
    then Exit;
  Reader := New(PTestAVLNodeReader, Init(Tree));
  Window := New(PResultsWindow, Init('TAVLTree test', Reader));
  InitTest(Reader, Window, CreateAVLNode);
  TestBinaryTree(Tree);
  EndTest;
end;

{****************************************************************************}
{ TestTBinaryTree                                                            }
{****************************************************************************}
procedure TestTBinaryTree;
var
  Tree : PBinaryTree;
  Reader : PTestBinaryNodeReader;
  Window : PResultsWindow;
begin
  Tree := New(PBinaryTree, Init);
  if Tree= nil
    then Exit;
  Reader := New(PTestBinaryNodeReader, Init(Tree));
  Window := New(PResultsWindow, Init('TBinaryTree test', Reader));
  InitTest(Reader, Window, CreateBinaryNode);
  TestBinaryTree(Tree);
  EndTest;
end;

{****************************************************************************}
{ TestTBPlusTree                                                             }
{****************************************************************************}
procedure TestTBPlusTree;
var
  Stream : PStream;
  Tree : PBPlusTree;
  Reader : PBTreeReader;
  Window : PResultsWindow;
  OldTotalItems : LongInt;
begin
  Stream := New(PBufStream, Init(TreesTempFileName, stCreate, 2048));
  if Stream = nil
    then begin
           Application^.OutOfMemory;
           Exit;
         end { if }
  else if Stream^.Status <> stOk
    then begin
           MessageBox('Error ocurred while initializing stream.',
             nil, mfError + mfOkButton);
           Dispose(Stream, Done);
           Exit;
         end; { if }
  Tree := New(PBPlusTree, Init(13, 20, SizeOf(TTestRec), SizeOf(String5),
            Stream, 50, 50));
  if Tree = nil
    then Exit;
  Reader := New(PBTreeReader, Init(Tree));
  Window := New(PResultsWindow, Init('TBPlusTree test', Reader));

  OldTotalItems := TotalItems;
  if TotalItems > 3000
    then begin
           Writeln(Window^.T, 'For speed, number of items has been reduced '+
             'to 3000.');
           Writeln(Window^.T);
           TotalItems := 3000;
         end; { if }
  Writeln(Window^.T, 'The size of the buffer is 12 Kb.');
  Writeln(Window^.T);

  InitTest(Reader, Window, nil);
  UseNonDynamicTestRec := True;
  TestGraph(Tree);
  UseNonDynamicTestRec := False;
  if PResultsWindow(Desktop^.Current) = Window
    then begin
           Dispose(Tree, Done);
           Reader^.Container := nil;
           NotifyDataChange;
           Window^.Redraw;
         end; { if }
  Dispose(Stream, Done);
  TotalItems := OldTotalItems;
  EndTest;
end;

{****************************************************************************}
{ TestTBTree                                                                 }
{****************************************************************************}
procedure TestTBTree;
var
  Stream : PStream;
  Tree : PBTree;
  Reader : PBTreeReader;
  Window : PResultsWindow;
  OldTotalItems : LongInt;
begin
  Stream := New(PBufStream, Init(TreesTempFileName, stCreate, 2048));
  if Stream = nil
    then begin
           Application^.OutOfMemory;
           Exit;
         end { if }
  else if Stream^.Status <> stOk
    then begin
           MessageBox('Error ocurred while initializing stream.',
             nil, mfError + mfOkButton);
           Dispose(Stream, Done);
           Exit;
         end; { if }
  Tree := New(PBTree, Init(15, SizeOf(TTestRec), Stream, 100));
  if Tree = nil
    then Exit;
  Reader := New(PBTreeReader, Init(Tree));
  Window := New(PResultsWindow, Init('TBTree test', Reader));

  OldTotalItems := TotalItems;
  if TotalItems > 3000
    then begin
           Writeln(Window^.T, 'For speed, number of items has been reduced '+
             'to 3000.');
           Writeln(Window^.T);
           TotalItems := 3000;
         end; { if }
  Writeln(Window^.T, 'The size of the buffer is 20 Kb.');
  Writeln(Window^.T);

  InitTest(Reader, Window, nil);
  UseNonDynamicTestRec := True;
  TestGraph(Tree);
  UseNonDynamicTestRec := False;
  if PResultsWindow(Desktop^.Current) = Window
    then begin
           Dispose(Tree, Done);
           Reader^.Container := nil;
           NotifyDataChange;
           Window^.Redraw;
         end; { if }
  Dispose(Stream, Done);
  TotalItems := OldTotalItems;
  EndTest;
end;

{****************************************************************************}
{ TestTDoubleEndedQueue                                                      }
{****************************************************************************}
procedure TestTDoubleEndedQueue;
var
  Queue : PDoubleEndedQueue;
  Reader : PTestListNodeReader;
  Window : PResultsWindow;
begin
  Queue := New(PDoubleEndedQueue, Init);
  if Queue = nil
    then Exit;
  Reader := New(PTestListNodeReader, Init(Queue));
  Window := New(PResultsWindow, Init('TDoubleEndedQueue test', Reader));
  InitTest(Reader, Window, CreateListNode);
  TestDoubleEndedQueue(Queue);
  EndTest;
end;

{****************************************************************************}
{ TestTEmsCollection                                                         }
{****************************************************************************}
procedure TestTEmsCollection;
var
  Collection : PEmsCollection;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  Collection := New(PEmsCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(Collection));
  Window := New(PResultsWindow, Init('TEmsCollection test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestSequence(Collection, Dynamic, UnSorted);
  EndTest;
end;

{****************************************************************************}
{ TestTEmsObjectArray                                                        }
{****************************************************************************}
procedure TestTEmsObjectArray;
var
  DemoArray: PEmsObjectArray;
  Reader : PTestStaticObjectReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PEmsObjectArray, Init(0, Pred(TotalItems),
    SizeOf(TTestStaticObject)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestStaticObjectReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TEmsObjectArray test', Reader));
  InitTest(Reader, Window, CreateStaticObject);
  TestArray(DemoArray);
  EndTest;
end;

{****************************************************************************}
{ TestTEmsSortedCollection                                                   }
{****************************************************************************}
procedure TestTEmsSortedCollection;
var
  Collection : PEmsSortedCollection;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  Collection := New(PTestEmsSortedCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(Collection));
  Window := New(PResultsWindow, Init('TEmsSortedCollection test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestSequence(Collection, Dynamic, Sorted);
  EndTest;
end;

{****************************************************************************}
{ TestTEmsStack                                                              }
{****************************************************************************}
procedure TestTEmsStack;
var
  Stack: PEmsStack;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  Stack := New(PEmsStack, Init(100, 10));
  if Stack = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(Stack));
  Window := New(PResultsWindow, Init('TEmsStack test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestStreamStack(Stack);
  EndTest;
end;

{****************************************************************************}
{ TestTEmsStdArray                                                           }
{****************************************************************************}
procedure TestTEmsStdArray;
var
  DemoArray: PEmsStdArray;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PEmsStdArray, Init(0, Pred(TotalItems),
    SizeOf(TTestRec)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestRecReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TEmsStdArray test', Reader));
  InitTest(Reader, Window, CreateTestRec);
  TestArray(DemoArray);
  EndTest;
end;

{****************************************************************************}
{ TestTEmsStdObjectArray                                                        }
{****************************************************************************}
procedure TestTEmsStdObjectArray;
var
  DemoArray: PEmsStdObjectArray;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PEmsStdObjectArray, Init(0, Pred(TotalItems),
    SizeOf(TTestObject)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TEmsStdObjectArray test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestArray(DemoArray);
  EndTest;
end;

{****************************************************************************}
{ TestTEmsStringCollection                                                   }
{****************************************************************************}
procedure TestTEmsStringCollection;
var
  Collection : PEmsStringCollection;
  Reader : PStringReader;
  Window : PResultsWindow;
begin
  Collection := New(PEmsStringCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PStringReader, Init(Collection));
  Window := New(PResultsWindow, Init('TEmsStringCollection test', Reader));
  InitTest(Reader, Window, CreateString);
  TestSequence(Collection, Dynamic, Sorted);
  EndTest;
end;

{****************************************************************************}
{ TestTEmsUnSortedStrCollection                                              }
{****************************************************************************}
procedure TestTEmsUnSortedStrCollection;
var
  Collection : PEmsUnSortedStrCollection;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  Collection := New(PEmsUnSortedStrCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(Collection));
  Window := New(PResultsWindow, Init('TEmsUnSortedStrCollection test',
    Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestSequence(Collection, Dynamic, UnSorted);
  EndTest;
end;

{****************************************************************************}
{ TestTHugeArray                                                             }
{****************************************************************************}
procedure TestTHugeArray;
var
  DemoArray: PHugeArray;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PHugeArray, Init(0, Pred(TotalItems),
    SizeOf(TTestRec)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestRecReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('THugeArray test', Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestRec := True;
  TestingMemArray := True;
  TestArray(DemoArray);
  UseNonDynamicTestRec := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTHugeArrayStack                                                        }
{****************************************************************************}
procedure TestTHugeArrayStack;
var
  Stack : PHugeArrayStack;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  Stack := New(PHugeArrayStack, Init(30, 50, SizeOf(TTestRec)));
  if Stack = nil
    then Exit;
  Reader := New(PTestRecReader, Init(Stack));
  Window := New(PResultsWindow, Init('THugeArrayStack test', Reader));
  InitTest(Reader, Window, nil);
  TestHugeArrayStack(Stack);
  EndTest;
end;

{****************************************************************************}
{ TestTHugeObjectArray                                                       }
{****************************************************************************}
procedure TestTHugeObjectArray;
var
  DemoArray: PHugeObjectArray;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PHugeObjectArray, Init(0, Pred(TotalItems),
    SizeOf(TTestObject)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('THugeObjectArray test', Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestObject := True;
  TestingMemArray := True;
  TestArray(DemoArray);
  UseNonDynamicTestObject := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTHugeCollection                                                        }
{****************************************************************************}
procedure TestTHugeCollection;
var
  Collection : PHugeCollection;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  Collection := New(PHugeCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(Collection));
  Window := New(PResultsWindow, Init('THugeCollection test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestSequence(Collection, Dynamic, UnSorted);
  EndTest;
end;

{****************************************************************************}
{ TestTHugeCollectionStack                                                   }
{****************************************************************************}
procedure TestTHugeCollectionStack;
var
  Stack : PHugeCollectionStack;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  Stack := New(PHugeCollectionStack, Init(30, 50));
  if Stack = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(Stack));
  Window := New(PResultsWindow, Init('THugeCollectionStack test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestHugeCollectionStack(Stack);
  EndTest;
end;

{****************************************************************************}
{ TestTHugeSortedCollection                                                  }
{****************************************************************************}
procedure TestTHugeSortedCollection;
var
  Collection : PHugeSortedCollection;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  Collection := New(PTestHugeSortedCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(Collection));
  Window := New(PResultsWindow, Init('THugeSortedCollection test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestSequence(Collection, Dynamic, Sorted);
  EndTest;
end;

{****************************************************************************}
{ TestTHugeStringCollection                                                  }
{****************************************************************************}
procedure TestTHugeStringCollection;
var
  Collection : PHugeStringCollection;
  Reader : PStringReader;
  Window : PResultsWindow;
begin
  Collection := New(PHugeStringCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PStringReader, Init(Collection));
  Window := New(PResultsWindow, Init('THugeStringCollection test', Reader));
  InitTest(Reader, Window, CreateString);
  TestSequence(Collection, Dynamic, Sorted);
  EndTest;
end;

{****************************************************************************}
{ TestTHugeUnSortedStrCollection                                             }
{****************************************************************************}
procedure TestTHugeUnSortedStrCollection;
var
  Collection : PHugeUnSortedStrCollection;
  Reader : PStringReader;
  Window : PResultsWindow;
begin
  Collection := New(PHugeUnSortedStrCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PStringReader, Init(Collection));
  Window := New(PResultsWindow, Init('THugeUnSortedStrCollection test',
    Reader));
  InitTest(Reader, Window, CreateString);
  TestSequence(Collection, Dynamic, UnSorted);
  EndTest;
end;

{****************************************************************************}
{ TestTLinkedStack                                                           }
{****************************************************************************}
procedure TestTLinkedStack;
var
  Stack: PLinkedStack;
  Reader : PTestListNodeReader;
  Window : PResultsWindow;
begin
  Stack := New(PLinkedStack, Init);
  if Stack = nil
    then Exit;
  Reader := New(PTestListNodeReader, Init(Stack));
  Window := New(PResultsWindow, Init('TLinkedStack test', Reader));
  InitTest(Reader, Window, CreateListNode);
  TestLinkedStack(Stack);
  EndTest;
end;

{****************************************************************************}
{ TestTListDouble                                                            }
{****************************************************************************}
procedure TestTListDouble;
var
  List : PDoubleList;
  Reader : PTestDoubleNodeReader;
  Window : PResultsWindow;
begin
  List := New(PDoubleList, Init);
  if List = nil
    then Exit;
  Reader := New(PTestDoubleNodeReader, Init(List));
  Window := New(PResultsWindow, Init('TDoubleList test', Reader));
  InitTest(Reader, Window, CreateDoubleNode);
  TestSequence(List, Dynamic, UnSorted);
  EndTest;
end;

{****************************************************************************}
{ TestTListSingle                                                            }
{****************************************************************************}
procedure TestTListSingle;
var
  List : PList;
  Reader : PTestListNodeReader;
  Window : PResultsWindow;
begin
  List := New(PList, Init);
  if List = nil
    then Exit;
  Reader := New(PTestListNodeReader, Init(List));
  Window := New(PResultsWindow, Init('TList test', Reader));
  InitTest(Reader, Window, CreateListNode);
  TestSequence(List, Dynamic, UnSorted);
  EndTest;
end;

{****************************************************************************}
{ TestTObjectBPlusTree                                                       }
{****************************************************************************}
procedure TestTObjectBPlusTree;
var
  Stream : PStream;
  Tree : PTestObjectBPlusTree;
  Reader : PObjectBTreeReader;
  Window : PResultsWindow;
  OldTotalItems : LongInt;
begin
  Stream := New(PBufStream, Init(TreesTempFileName, stCreate, 2048));
  if Stream = nil
    then begin
           Application^.OutOfMemory;
           Exit;
         end { if }
  else if Stream^.Status <> stOk
    then begin
           MessageBox('Error ocurred while initializing stream.',
             nil, mfError + mfOkButton);
           Dispose(Stream, Done);
           Exit;
         end; { if }
  Tree := New(PTestObjectBPlusTree, Init(13, 20, SizeOf(TTestStaticObject),
    SizeOf(String5), Stream, 50, 50));
  if Tree = nil
    then Exit;
  Reader := New(PObjectBTreeReader, Init(Tree));
  Window := New(PResultsWindow, Init('TObjectBPlusTree test', Reader));

  OldTotalItems := TotalItems;
  if TotalItems > 3000
    then begin
           Writeln(Window^.T, 'For speed, number of items has been reduced '+
             'to 3000.');
           Writeln(Window^.T);
           TotalItems := 3000;
         end; { if }
  Writeln(Window^.T, 'The size of the buffer is 22 Kb.');
  Writeln(Window^.T);

  InitTest(Reader, Window, CreateStaticObject);
  TestGraph(Tree);
  if PResultsWindow(Desktop^.Current) = Window
    then begin
           Dispose(Tree, Done);
           Reader^.Container := nil;
           NotifyDataChange;
           Window^.Redraw;
         end; { if }
  Dispose(Stream, Done);
  TotalItems := OldTotalItems;
  EndTest;
end;

{****************************************************************************}
{ TestTObjectBTree                                                           }
{****************************************************************************}
procedure TestTObjectBTree;
var
  Stream : PStream;
  Tree : PTestObjectBTree;
  Reader : PObjectBTreeReader;
  Window : PResultsWindow;
  OldTotalItems : LongInt;
begin
  Stream := New(PBufStream, Init(TreesTempFileName, stCreate, 2048));
  if Stream = nil
    then begin
           Application^.OutOfMemory;
           Exit;
         end { if }
  else if Stream^.Status <> stOk
    then begin
           MessageBox('Error ocurred while initializing stream.',
             nil, mfError + mfOkButton);
           Dispose(Stream, Done);
           Exit;
         end; { if }
  Tree := New(PTestObjectBTree, Init(15, SizeOf(TTestStaticObject),
    Stream, 100));
  if Tree = nil
    then Exit;
  Reader := New(PObjectBTreeReader, Init(Tree));
  Window := New(PResultsWindow, Init('TObjectBTree test', Reader));

  OldTotalItems := TotalItems;
  if TotalItems > 3000
    then begin
           Writeln(Window^.T, 'For speed, number of items has been reduced '+
             'to 3000.');
           Writeln(Window^.T);
           TotalItems := 3000;
         end; { if }
  Writeln(Window^.T, 'The size of the buffer is 20 Kb.');
  Writeln(Window^.T);

  InitTest(Reader, Window, CreateStaticObject);
  TestGraph(Tree);
  if PResultsWindow(Desktop^.Current) = Window
    then begin
           Dispose(Tree, Done);
           Reader^.Container := nil;
           NotifyDataChange;
           Window^.Redraw;
         end; { if }
  Dispose(Stream, Done);
  TotalItems := OldTotalItems;
  EndTest;
end;

{****************************************************************************}
{ TestTObjectTable                                                           }
{****************************************************************************}
procedure TestTObjectTable;
var
  Stream : PStream;
  Structure : PFieldStructure;
  Table : PObjectTable;
  Reader : PTestStaticObjectReader;
  Window : PResultsWindow;
begin
  Stream := New(PBufStream, Init(TablesTempFileName, stCreate, 1024));
  if Stream = nil
     then begin
            Application^.OutOfMemory;
            Exit;
          end; { if }
  Structure := New(PFieldStructure, Init(2, 1));
  if Structure = nil
     then begin
            Dispose(Stream, Done);
            Application^.OutOfMemory;
            Exit;
          end; { if }
  Structure^.Insert(NewStringField('String', 5));
  Structure^.Insert(NewIntegerField('Index'));

  Table := New(PObjectTable, Init(Structure, Stream));
  if Table = nil
     then begin
            Dispose(Structure,Done);
            Dispose(Stream,Done);
            Exit;
          end;

  Reader := New(PTestStaticObjectReader, Init(Table));
  Window := New(PResultsWindow, Init('TObjectTable test', Reader));
  InitTest(Reader, Window, CreateStaticObject);
  TestSequence(Table, Dynamic, UnSorted);
  if PResultsWindow(Desktop^.Current) = Window
    then begin
           Dispose(Table, Done);
           Reader^.Container := nil;
           NotifyDataChange;
           Window^.Redraw;
         end; { if }
  Dispose(Stream, Done);
  EndTest;
end;

{****************************************************************************}
{ TestTQueue                                                                 }
{****************************************************************************}
procedure TestTQueue;
var
  Queue : PQueue;
  Reader : PTestListNodeReader;
  Window : PResultsWindow;
begin
  Queue := New(PQueue, Init);
  if Queue = nil
    then Exit;
  Reader := New(PTestListNodeReader, Init(Queue));
  Window := New(PResultsWindow, Init('TQueue test', Reader));
  InitTest(Reader, Window, CreateListNode);
  TestQueue(Queue);
  EndTest;
end;

{****************************************************************************}
{ TestTResizableHugeArray                                                    }
{****************************************************************************}
procedure TestTResizableHugeArray;
var
  DemoArray: PResizableHugeArray;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PResizableHugeArray, Init(TotalItems, 100,
    SizeOf(TTestRec)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestRecReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TResizableHugeArray test', Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestRec := True;
  TestingMemArray := True;
  TestResizableArray(DemoArray);
  UseNonDynamicTestRec := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTResizableHugeObjectArray                                              }
{****************************************************************************}
procedure TestTResizableHugeObjectArray;
var
  DemoArray: PResizableHugeObjectArray;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PResizableHugeObjectArray, Init(TotalItems, 100,
    SizeOf(TTestRec)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TResizableHugeObjectArray test',
    Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestObject := True;
  TestingMemArray := True;
  TestResizableArray(DemoArray);
  UseNonDynamicTestObject := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTResizableStdArray                                                     }
{****************************************************************************}
procedure TestTResizableStdArray;
var
  DemoArray: PResizableStdArray;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PResizableStdArray, Init(TotalItems, 100,
    SizeOf(TTestRec)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestRecReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TResizableStdArray test', Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestRec := True;
  TestingMemArray := True;
  TestResizableArray(DemoArray);
  UseNonDynamicTestRec := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTResizableStdObjectArray                                               }
{****************************************************************************}
procedure TestTResizableStdObjectArray;
var
  DemoArray: PResizableStdObjectArray;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PResizableStdObjectArray, Init(TotalItems, 100,
    SizeOf(TTestRec)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TResizableStdObjectArray test',
    Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestObject := True;
  TestingMemArray := True;
  TestResizableArray(DemoArray);
  UseNonDynamicTestObject := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTSortedListDouble                                                      }
{****************************************************************************}
procedure TestTSortedListDouble;
var
  List : PSortedDoubleList;
  Reader : PTestDoubleNodeReader;
  Window : PResultsWindow;
  OldTotalItems : LongInt;
begin
  List := New(PSortedDoubleList, Init);
  if List = nil
    then Exit;
  Reader := New(PTestDoubleNodeReader, Init(List));
  Window := New(PResultsWindow, Init('TSortedDoubleList test',
    Reader));
  OldTotalItems := TotalItems;
  if TotalItems > 2000
    then begin
           Writeln(Window^.T, 'For speed, number of items has been reduced '+
             'to 2000.');
           Writeln(Window^.T);
           TotalItems := 2000;
         end; { if }
  InitTest(Reader, Window, CreateDoubleNode);
  TestSequence(List, Dynamic, Sorted);
  EndTest;
  TotalItems := OldTotalItems;
end;

{****************************************************************************}
{ TestTSortedListSingle                                                      }
{****************************************************************************}
procedure TestTSortedListSingle;
var
  List : PSortedList;
  Reader : PTestListNodeReader;
  Window : PResultsWindow;
  OldTotalItems : LongInt;
begin
  List := New(PSortedList, Init);
  if List = nil
    then Exit;
  Reader := New(PTestListNodeReader, Init(List));
  Window := New(PResultsWindow, Init('TSortedList test',
    Reader));
  OldTotalItems := TotalItems;
  if TotalItems > 2000
    then begin
           Writeln(Window^.T, 'For speed, number of items has been reduced '+
             'to 2000.');
           Writeln(Window^.T);
           TotalItems := 2000;
         end; { if }
  InitTest(Reader, Window, CreateListNode);
  TestSequence(List, Dynamic, Sorted);
  EndTest;
  TotalItems := OldTotalItems;
end;

{****************************************************************************}
{ TestTSortedHugeArray                                                       }
{****************************************************************************}
procedure TestTSortedHugeArray;
var
  DemoArray: PTestSortedHugeArray;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PTestSortedHugeArray, Init(TotalItems, 100,
    SizeOf(TTestRec)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestRecReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TSortedHugeArray test', Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestRec := True;
  TestingMemArray := True;
  TestSortedArray(DemoArray);
  UseNonDynamicTestRec := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTSortedHugeObjectArray                                                 }
{****************************************************************************}
procedure TestTSortedHugeObjectArray;
var
  DemoArray: PTestSortedHugeObjectArray;
  Reader : PTestStaticObjectReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PTestSortedHugeObjectArray, Init(TotalItems, 100,
    SizeOf(TTestStaticObject)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestStaticObjectReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TSortedHugeObjectArray test', Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestStaticObject := True;
  TestingMemArray := True;
  TestSortedArray(DemoArray);
  UseNonDynamicTestStaticObject := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTSortedStdArray                                                        }
{****************************************************************************}
procedure TestTSortedStdArray;
var
  DemoArray: PTestSortedStdArray;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PTestSortedStdArray, Init(TotalItems, 100,
    SizeOf(TTestRec)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestRecReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TSortedStdArray test', Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestRec := True;
  TestingMemArray := True;
  TestSortedArray(DemoArray);
  UseNonDynamicTestRec := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTSortedStdObjectArray                                                  }
{****************************************************************************}
procedure TestTSortedStdObjectArray;
var
  DemoArray: PTestSortedStdObjectArray;
  Reader : PTestStaticObjectReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PTestSortedStdObjectArray, Init(TotalItems, 100,
    SizeOf(TTestObject)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestStaticObjectReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TSortedStdObjectArray test', Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestStaticObject := True;
  TestingMemArray := True;
  TestSortedArray(DemoArray);
  UseNonDynamicTestStaticObject := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTStdArray                                                              }
{****************************************************************************}
procedure TestTStdArray;
var
  DemoArray: PStdArray;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PStdArray, Init(0, Pred(TotalItems),
    SizeOf(TTestRec)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestRecReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TStdArray test', Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestRec := True;
  TestingMemArray := True;
  TestArray(DemoArray);
  UseNonDynamicTestRec := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTStdObjectArray                                                        }
{****************************************************************************}
procedure TestTStdObjectArray;
var
  DemoArray: PStdObjectArray;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PStdObjectArray, Init(0, Pred(TotalItems),
    SizeOf(TTestObject)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TStdObjectArray test', Reader));
  InitTest(Reader, Window, nil);
  UseNonDynamicTestObject := True;
  TestingMemArray := True;
  TestArray(DemoArray);
  UseNonDynamicTestObject := False;
  TestingMemArray := False;
  EndTest;
end;

{****************************************************************************}
{ TestTStreamCollection                                                      }
{****************************************************************************}
procedure TestTStreamCollection;
var
  Collection : PStreamCollection;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  Collection := New(PStreamCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(Collection));
  Window := New(PResultsWindow, Init('TStreamCollection test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestSequence(Collection, Dynamic, UnSorted);
  EndTest;
end;

{****************************************************************************}
{ TestTStreamObjectArray                                                     }
{****************************************************************************}
procedure TestTStreamObjectArray;
var
  DemoArray: PStreamObjectArray;
  Reader : PTestStaticObjectReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PStreamObjectArray, Init(0, Pred(TotalItems),
    SizeOf(TTestStaticObject)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestStaticObjectReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TStreamObjectArray test', Reader));
  InitTest(Reader, Window, CreateStaticObject);
  TestArray(DemoArray);
  EndTest;
end;

{****************************************************************************}
{ TestTStreamSortedCollection                                                }
{****************************************************************************}
procedure TestTStreamSortedCollection;
var
  Collection : PStreamSortedCollection;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  Collection := New(PTestStreamSortedCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(Collection));
  Window := New(PResultsWindow, Init('TStreamSortedCollection test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestSequence(Collection, Dynamic, Sorted);
  EndTest;
end;

{****************************************************************************}
{ TestTStreamStack                                                           }
{****************************************************************************}
procedure TestTStreamStack;
var
  Stack: PStreamStack;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  Stack := New(PStreamStack, Init(100, 10));
  if Stack = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(Stack));
  Window := New(PResultsWindow, Init('TStreamStack test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestStreamStack(Stack);
  EndTest;
end;

{****************************************************************************}
{ TestTStreamStdArray                                                        }
{****************************************************************************}
procedure TestTStreamStdArray;
var
  DemoArray: PStreamStdArray;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PStreamStdArray, Init(0, Pred(TotalItems), SizeOf(TTestRec)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestRecReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TStreamStdArray test', Reader));
  InitTest(Reader, Window, CreateTestRec);
  TestArray(DemoArray);
  EndTest;
end;

{****************************************************************************}
{ TestTStreamStdObjectArray                                                  }
{****************************************************************************}
procedure TestTStreamStdObjectArray;
var
  DemoArray: PStreamStdObjectArray;
  Reader : PTestObjectReader;
  Window : PResultsWindow;
begin
  DemoArray := New(PStreamStdObjectArray, Init(0, Pred(TotalItems),
    SizeOf(TTestObject)));
  if DemoArray = nil
    then Exit;
  Reader := New(PTestObjectReader, Init(DemoArray));
  Window := New(PResultsWindow, Init('TStreamStdObjectArray test', Reader));
  InitTest(Reader, Window, CreateTestObject);
  TestArray(DemoArray);
  EndTest;
end;

{****************************************************************************}
{ TestTStreamStringCollection                                                }
{****************************************************************************}
procedure TestTStreamStringCollection;
var
  Collection : PStreamStringCollection;
  Reader : PStringReader;
  Window : PResultsWindow;
begin
  Collection := New(PStreamStringCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PStringReader, Init(Collection));
  Window := New(PResultsWindow, Init('TStreamStringCollection test', Reader));
  InitTest(Reader, Window, CreateString);
  TestSequence(Collection, Dynamic, Sorted);
  EndTest;
end;

{****************************************************************************}
{ TestTStreamUnSortedStrCollection                                           }
{****************************************************************************}
procedure TestTStreamUnSortedStrCollection;
var
  Collection : PStreamUnSortedStrCollection;
  Reader : PStringReader;
  Window : PResultsWindow;
begin
  Collection := New(PStreamUnSortedStrCollection, Init(TotalItems, 50));
  if Collection = nil
    then Exit;
  Reader := New(PStringReader, Init(Collection));
  Window := New(PResultsWindow, Init('TStreamUnSortedStrCollection test',
    Reader));
  InitTest(Reader, Window, CreateString);
  TestSequence(Collection, Dynamic, UnSorted);
  EndTest;
end;

{****************************************************************************}
{ TestTTable                                                                 }
{****************************************************************************}
procedure TestTTable;
var
  Stream : PStream;
  Structure : PFieldStructure;
  Table : PTable;
  Reader : PTestRecReader;
  Window : PResultsWindow;
begin
  Stream := New(PBufStream, Init(TablesTempFileName, stCreate, 1024));
  if Stream = nil
     then begin
            Application^.OutOfMemory;
            Exit;
          end; { if }
  Structure := New(PFieldStructure, Init(2, 1));
  if Structure = nil
     then begin
            Dispose(Stream, Done);
            Application^.OutOfMemory;
            Exit;
          end; { if }
  Structure^.Insert(NewStringField('String', 5));
  Structure^.Insert(NewIntegerField('Index'));

  Table := New(PTable, Init(Structure, Stream));
  if Table = nil
    then Exit;
  Reader := New(PTestRecReader, Init(Table));
  Window := New(PResultsWindow, Init('TTable test', Reader));
  InitTest(Reader, Window, CreateTestRec);
  TestSequence(Table, Dynamic, UnSorted);
  if PResultsWindow(Desktop^.Current) = Window
    then begin
           Dispose(Table, Done);
           Reader^.Container := nil;
           NotifyDataChange;
           Window^.Redraw;
         end; { if }
  Dispose(Stream, Done);
  EndTest;
end;

end.