{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{*  Containers Library demo                                               *}
{**************************************************************************}

program Stacks1;

{$X+}

{ Sample program for using an array based stack }

uses Objects, Containr, ctStacks,
     {$ifdef Windows}
     WinCtr;
     {$else}
     Crt;
     {$endif}

type
  PParserData = ^TParserData;
  TParserData = record
    State : Integer;
    Token : string[6];
  end; { TParserData }

procedure SetTokenValues(AState : Integer; AToken : string;
  var ParserRec : TParserData);
begin
  with ParserRec do
  begin
    State := AState;
    Token := AToken;
  end; { with }
end;

var
  TokenStack : PArrayStack;
  Token : TParserData;
  Item : Pointer;

begin
  ClrScr;

  { Create the stack }
  TokenStack := New(PArrayStack, Init(50, 10, SizeOf(TParserData)));

  { Insert items into the queue }
  with TokenStack^ do
  begin
    Writeln('Pushing:  State = 0, Token = if');
    SetTokenValues(0, 'if', Token);
    Push(@Token);
    Writeln('Pushing:  State = 2, Token = then');
    SetTokenValues(2, 'then', Token);
    Push(@Token);
    Writeln('Pushing:  State = 1, Token = else');
    SetTokenValues(1, 'else', Token);
    Push(@Token);
    Writeln('Pushing:  State = 4, Token = ;');
    SetTokenValues(4, ';', Token);
    Push(@Token);
  end; { with }
  Writeln;

  { Extract items from the queue }
  with TokenStack^ do
  begin
    repeat
      Item := Pop;
      with PParserData(Item)^ do
        Writeln('Popping:  State = ', State, ', Token = ', Token:4);
      FreeItem(Item);
    until Count = 0;
  end; { with }

  { Dispose of the stack }
  Dispose(TokenStack, Done);
end.