{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{*  Containers Library demo                                               *}
{**************************************************************************}

program Table1;

{$X+}

{ This program demonstrates how to create a field structure, use it to
initialize a table, insert a data item, and return results.  It contains all
examples described in the documentation chapter on tables. }

uses
  Objects, Crt, BsdTest, ctTypes, ctFields, ctTables;

const
  TempFile = 'test.dat';
  BufferSize = 2048;
  OpenedFromDisk: Boolean = False;

var
  FieldStructure: PFieldStructure;
  Table: PTable;

type
  PAddressRec = ^TAddressRec;
  TAddressRec = record
    Line1: string[50];
    Line2: string[50];
    City: string[50];
    State: string[50];
  end;  { of TAddressRec }


function AddressFieldStructure: PFieldStructure;
var
  FieldStructure: PFieldStructure;
  Field: PField;
  Name: TFieldName;
  i: Integer;
begin
  FieldStructure := New(PFieldStructure,Init(4,1));
  if (FieldStructure <> nil) then
    for i := 1 to 4 do
    begin
      case i of
        1: Name := 'Line1';
        2: Name := 'Line2';
        3: Name := 'City';
        4: Name := 'State';
      end;
      Field := New(PField,Init(Name,ftString,50,0));
      if (Field <> nil) then
        FieldStructure^.Insert(Field)
      else Error('Out of memory.  Could not create field ' + Name + '.');
    end;
  AddressFieldStructure := FieldStructure;
end;


procedure InsertAddresses;
var
  Address: PAddressRec;
begin
  GetMem(Address,SizeOf(TAddressRec));
  if Address = nil then
    Error('Out of memory.  Could not create address record.');
  Address^.Line1 := 'Mickey Mouse';
  Address^.Line2 := 'Disney World';
  Address^.City  := 'Orlando';
  Address^.State := 'Florida';
  Table^.Insert(Address);
end;

procedure ShowAddresses;
var
  RecNo: LongInt;
  procedure ShowAddress (Address: PAddressRec); far;
  begin
    WriteLn('Record Number = ',RecNo);
    with Address^ do
    begin
      WriteLn('   ',Line1);
      WriteLn('   ',Line2);
      WriteLn('   ',City,', ',State);
    end;
    WriteLn;
    Inc(RecNo);
  end;
begin
  with Table^ do
  begin
    if not OpenedFromDisk then
    begin
      WriteLn('Table''s Field Structure');
      Structure^.ShowInfo(OutPut);
      WriteLn;
    end;
    RecNo := 0;
    ForEach(@ShowAddress);
  end;
end;

var
  F: File;  { just used to delete table so we don't litter your disk }
  Size: LongInt;
  Stream: PStream;
begin
  ClrScr;
  RegisterType(RField);
  RegisterType(RFieldStructure);
  Size := MemAvail;
  FieldStructure := AddressFieldStructure;
  if (FieldStructure = nil) then
    Error('Error creating field structure.');
  Stream := New(PBufStream,Init(TempFile, stCreate, 2048));
  Table := New(PTable, Init(FieldStructure, Stream));
  if (Table = nil) then
  begin
      { Caution!!!! Don't dispose of the table structure if table
        initialization was successful.  It is used and will be disposed of by
        the table. }
    Dispose(FieldStructure, Done);
    Error('Error constructing table.');
  end;
  WriteLn('Table created successfully.');
  InsertAddresses;
  WriteLn('Addresses inserted successfully.');
  WriteLn;
  ShowAddresses;
  WriteLn('Closing table.');
  Dispose(Table, Done);
    { Tables don't dispose of the stream on which they are stored so that the
      stream can be used for other purposes within the application.  You must
      explicitly dispose of the table's stream when you are finished using it
      to prevent a memory leak and ensure all data is flushed from the
      stream's buffers. }
  Dispose(Stream,Done);
  WriteLn('Reopening table.');
  Stream := New(PBufStream, Init(TempFile, stOpen, BufferSize));
  Table := New(PTable, Open(Stream));
  if (Table = nil) then
    Error('Error opening table.')
  else begin
    WriteLn('Opened table successfully.');
    OpenedFromDisk := True;
  end;
  WriteLn;
  ShowAddresses;
  Dispose(Table,Done);
  Dispose(Stream,Done);
    { remove the table }
  Assign(F,TempFile);
  {$I-}
  Erase(F);
  {$I+}
  if (Size <> MemAvail) then
    WriteLn('Memory leak.');
  ReadLn;
end.