{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{**************************************************************************}

unit TstScrpt;

{$X+}

interface

uses Containr, ctArrays, ctQueues, ctStacks, ctTrees, ctBiTree;

procedure TestSequence (Sequence : PSequence; DynamicSequence,
  SortedSequence : Boolean);
{ Script used to test base TContainer and TSequence methods. }

procedure TestGraph (Graph : PGraph);
{ Script used to test base TContainer and TGraph methods. }

procedure TestArray (DemoArray : PDynamicArray);
procedure TestResizableArray (DemoArray : PDynamicArray);
procedure TestSortedArray (DemoArray : PDynamicArray);
procedure TestQueue (Queue : PQueue);
procedure TestDoubleEndedQueue (Queue : PDoubleEndedQueue);
procedure TestLinkedStack (Stack : PLinkedStack);
procedure TestStreamStack (Stack : PStreamStack);
procedure TestBinaryTree (Tree : PBinaryTree);
procedure TestHugeCollectionStack (Stack : PHugeCollectionStack);
procedure TestArrayStack(Stack : PArrayStack);
procedure TestHugeArrayStack(Stack : PHugeArrayStack);

implementation

uses BsdTypes,
     MtdTests, Types, Utils;

{****************************************************************************}
{ TestArray                                                                  }
{****************************************************************************}
procedure TestArray (DemoArray : PDynamicArray);
begin
  TestSequence(DemoArray, Static, UnSorted);
  TestArrayAtClear(DemoArray);
end;

{****************************************************************************}
{ TestArrayStack                                                             }
{****************************************************************************}
procedure TestArrayStack (Stack : PArrayStack);
begin
  TestArrayStackPush(Stack);
  TestArrayStackTop(Stack);
  TestArrayStackBottom(Stack);
  TestArrayStackPop(Stack);
end;

{****************************************************************************}
{ TestDoubleEndedQueue                                                       }
{****************************************************************************}
procedure TestDoubleEndedQueue (Queue : PDoubleEndedQueue);
begin
  TestQueueEnQueue(Queue);
  TestQueueFront(Queue);
  TestQueueRear(Queue);
  TestDoubleEndedQueueRemoveFirst(Queue);
  TestDoubleEndedQueueRemoveLast(Queue);
  TestQueueRemove(Queue);
end;

{****************************************************************************}
{ TestGraph                                                                  }
{****************************************************************************}
procedure TestGraph (Graph : PGraph);
var
  DuplicateKey : String5;
  DeleteKey, FreeKey, ReplaceKey : String5;
begin
  { TContainer methods }
  TestContainerInsert (Graph, TotalItems);
  TestContainerForEach (Graph);
  TestContainerForEachThat (Graph);
  TestGraphDelete (Graph);
  TestGraphFree (Graph);
  TestContainerDeleteAllThat (Graph);
  TestContainerFreeAllThat (Graph);
  TestContainerPack (Graph);
  TestContainerFreeAll (Graph);
  TestContainerInsert (Graph, TotalDeleteItems);
  TestGraphDeleteAll (Graph);
  if not ExitTesting
    then Graph^.Pack;
  TestContainerInsert (Graph, TotalItems);

  { TGraph methods }
  TestGraphFirst (Graph);
  TestGraphLast (Graph);
  TestGraphNext (Graph);
  TestGraphPrev (Graph);
  TestGraphFirstThat (Graph, DuplicateKey);
  TestGraphLastThat (Graph, DeleteKey);
  TestGraphNextThat (Graph, FreeKey);
  TestGraphPrevThat (Graph, ReplaceKey);
  TestGraphDuplicates (Graph, DuplicateKey);
  TestGraphKeyFirst (Graph, DuplicateKey);
  TestGraphNextExactMatch (Graph, DuplicateKey);
  TestGraphPrevExactMatch (Graph, DuplicateKey);
  TestGraphKeyLast (Graph, DuplicateKey);
  TestGraphKeyFirstThat(Graph, DuplicateKey);
  TestGraphKeyLastThat(Graph, DuplicateKey);
  TestGraphItemPut (Graph, ReplaceKey);
  TestGraphItemReplace (Graph, FreeKey);
  TestGraphFind (Graph, DuplicateKey);
  TestGraphFindThat (Graph, DuplicateKey);
end;

{****************************************************************************}
{ TestHugeArrayStack                                                         }
{****************************************************************************}
procedure TestHugeArrayStack (Stack : PHugeArrayStack);
begin
  TestHugeArrayStackPush(Stack);
  TestHugeArrayStackTop(Stack);
  TestHugeArrayStackBottom(Stack);
  TestHugeArrayStackPop(Stack);
end;

{****************************************************************************}
{ TestHugeCollectionStack                                                    }
{****************************************************************************}
procedure TestHugeCollectionStack (Stack : PHugeCollectionStack);
begin
  TestHugeCollectionStackPush(Stack);
  TestHugeCollectionStackTop(Stack);
  TestHugeCollectionStackBottom(Stack);
  TestHugeCollectionStackPop(Stack);
end;

{****************************************************************************}
{ TestLinkedStack                                                            }
{****************************************************************************}
procedure TestLinkedStack (Stack : PLinkedStack);
begin
  TestLinkedStackPush(Stack);
  TestLinkedStackTop(Stack);
  TestLinkedStackBottom(Stack);
  TestLinkedStackPop(Stack);
end;

{****************************************************************************}
{ TestQueue                                                                  }
{****************************************************************************}
procedure TestQueue (Queue : PQueue);
begin
  TestQueueEnQueue(Queue);
  TestQueueFront(Queue);
  TestQueueRear(Queue);
  TestQueueRemove(Queue);
end;

{****************************************************************************}
{ TestResizableArray                                                         }
{****************************************************************************}
procedure TestResizableArray (DemoArray : PDynamicArray);
begin
  TestSequence(DemoArray, Dynamic, Unsorted);
  TestArrayAtClear(DemoArray);
end;

{****************************************************************************}
{ TestSortedArray                                                            }
{****************************************************************************}
procedure TestSortedArray (DemoArray : PDynamicArray);
begin
  TestSequence(DemoArray, Dynamic, Sorted);
  TestArrayAtClear(DemoArray);
end;

{****************************************************************************}
{ TestStreamStack                                                            }
{****************************************************************************}
procedure TestStreamStack (Stack : PStreamStack);
begin
  TestStreamStackPush(Stack);
  TestStreamStackTop(Stack);
  TestStreamStackBottom(Stack);
  TestStreamStackPop(Stack);
end;

{****************************************************************************}
{ TestSequence                                                               }
{****************************************************************************}
procedure TestSequence (Sequence : PSequence; DynamicSequence,
  SortedSequence : Boolean);
begin
  { TContainer methods }
  if DynamicSequence
    then TestContainerInsert (Sequence, TotalItems)
    else TestStaticSequenceInsert (Sequence, TotalItems);
  TestContainerForEach (Sequence);
  TestContainerForEachThat (Sequence);
  TestSequenceDelete (Sequence);
  TestSequenceFree (Sequence);
  TestContainerDeleteAllThat (Sequence);
  TestContainerFreeAllThat (Sequence);
  TestContainerPack (Sequence);
  TestContainerFreeAll (Sequence);
  if DynamicSequence
    then TestContainerInsert (Sequence, TotalDeleteItems)
    else TestStaticSequenceInsert (Sequence, TotalDeleteItems);
  TestSequenceDeleteAll (Sequence);
  if not ExitTesting
    then Sequence^.Pack;
  if DynamicSequence
    then TestContainerInsert (Sequence, TotalItems)
    else TestStaticSequenceInsert (Sequence, TotalItems);
  { TSequence methods }
  TestSequenceAt (Sequence);
  TestSequenceAtDelete (Sequence);
  TestSequenceAtFree (Sequence);
  if not SortedSequence
    then begin
           if DynamicSequence
             then TestSequenceAtInsert (Sequence)
             else TestStaticSequenceAtInsert (Sequence);
           TestSequenceAtPut (Sequence);
         end; { if }
  TestSequenceFirst (Sequence);
  TestSequenceNext (Sequence);
  TestSequenceLast (Sequence);
  TestSequencePrev (Sequence);
  TestSequenceFirstThat (Sequence);
  TestSequenceNextThat (Sequence);
  TestSequenceLastThat (Sequence);
  TestSequencePrevThat (Sequence);
  if SortedSequence
    then TestSequenceSearch (Sequence);
end;

{****************************************************************************}
{ TestBinaryTree                                                             }
{****************************************************************************}
procedure TestBinaryTree (Tree : PBinaryTree);
begin
  TestGraph (Tree);
  TestTreeTraverse (Tree);
  TestTreeTraverseThat (Tree);
end;

end.