{**************************************************************************}
{*  BitSoft Development, L.L.C.                                           *}
{*  Copyright (C) 1995, 1996 BitSoft Development, L.L.C.                  *}
{*  All rights reserved.                                                  *}
{**************************************************************************}

unit Types;

interface

uses Objects,
     BsdTypes;

const
  TotalItems : LongInt = 5000;
  { Number of items that must be inserted in the container being tested. }

  TotalDuplicates : Integer = 15;
  { Number of duplicates to insert when testing handling of duplicate items. }

  TotalDeleteItems = 100;
  { Number of items that will be inserted for the DeleteAll method. }

  TotalDisplayItems = 500;
  { Number of items that will be displayed in a list box. }

type
  TCreateFunction = function(Key : String5; Index : Integer): pointer;
  { Functions of this type are used to create the items that will be
    inserted in a container. }

const
  Dynamic = True;
  { Indicates if a container is dynamically sized. }
  Static = False;
  { Indicates if a container is static (i.e. not dynamically sized). }

  DoublyLinked = True;
  { Indicates if a linked list is doubly-linked }
  SinglyLinked = False;
  { Indicates if a linked list is singly-linked }

  Sorted = True;
  { Indicates if a container is sorted }
  UnSorted = False;
  { Indicates if a container is not sorted }

const
  TablesTempFileName = 'tables.dat';
  { File name of the temporary file used to test the tables. }

  TreesTempFileName = 'btrees.dat';
  { File name of the temporary file used to test the B trees. }

const
  { Command constants }
  cmPrint = 100;
  cmStreamStdArray = 101;
  cmStreamStdObjectArray = 102;
  cmStreamObjectArray = 103;
  cmEmsStdArray = 104;
  cmEmsStdObjectArray = 105;
  cmEmsObjectArray = 106;
  cmStreamCollection = 107;
  cmStreamSortedCollection = 108;
  cmStreamStringCollection = 109;
  cmStreamUnSortedStrCollection = 110;
  cmEmsCollection = 111;
  cmEmsSortedCollection = 112;
  cmEmsStringCollection = 113;
  cmEmsUnSortedStrCollection = 114;
  cmListSingle = 115;
  cmListdouble = 116;
  cmSortedListSingle = 117;
  cmSortedListDouble = 118;
  cmQueue = 119;
  cmDoubleEndedQueue = 120;
  cmStreamStack = 121;
  cmLinkedStack = 122;
  cmContiguousStack = 123;
  cmEmsStack = 124;
  cmTable = 125;
  cmObjectTable = 126;
  cmBinaryTree = 127;
  cmAvlTree = 128;
  cmContents = 129;
  cmRegistering = 130;
  cmIms = 131;
  cmAbout = 132;
  cmRefresh = 133;
  cmVideoMode = 134;
  cmTotalItems = 135;
  cmSequenceListBox = 136;
  cmSortedListBox = 137;
  cmTotalDuplicates = 138;
  cmHugeCollection = 139;
  cmHugeSortedCollection = 140;
  cmHugeStringCollection = 141;
  cmHugeUnSortedStrCollection = 142;
  cmHugeArray = 143;
  cmHugeObjectArray = 144;
  cmStdArray = 145;
  cmStdObjectArray = 146;
  cmSortedStdArray = 147;
  cmSortedHugeArray = 148;
  cmSortedStdObjectArray = 149;
  cmSortedHugeObjectArray = 150;
  cmResizableStdArray = 151;
  cmResizableStdObjectArray = 152;
  cmResizableHugeArray = 153;
  cmResizableHugeObjectArray = 154;
  cmHugeCollectionStack = 155;
  cmArrayStack = 156;
  cmHugeArrayStack = 157;
  cmBTree = 158;
  cmObjectBTree = 159;
  cmBPlusTree = 160;
  cmObjectBPlusTree = 161;

const
  { Help context constants }
  hcFileMenu = 5;
  hcPrint = 6;
  hcQuit = 7;
  hcSequencesMenu = 8;
  hcArraysMenu = 9;
  hcCollectionsMenu = 10;
  hcListsMenu = 11;
  hcQueuesMenu = 12;
  hcStacksMenu = 13;
  hcTablesMenu = 14;
  hcGraphsMenu = 15;
  hcBTreesMenu = 16;
  hcStreamStdArray = 17;
  hcStreamStdObjectArray = 18;
  hcStreamObjectArray = 19;
  hcEmsStdArray = 20;
  hcEmsStdObjectArray = 21;
  hcEmsObjectArray = 22;
  hcStreamCollection = 23;
  hcStreamSortedCollection = 24;
  hcStreamStringCollection = 25;
  hcStreamUnSortedStrCollection = 26;
  hcEmsCollection = 27;
  hcEmsSortedCollection = 28;
  hcEmsStringCollection = 29;
  hcEmsUnSortedStrCollection = 30;
  hcListSingle = 31;
  hcListdouble = 32;
  hcSortedListSingle = 33;
  hcSortedListDouble = 34;
  hcQueue = 35;
  hcDoubleEndedQueue = 36;
  hcStreamStack = 37;
  hcLinkedStack = 38;
  hcContiguousStack = 39;
  hcEmsStack = 40;
  hcTable = 41;
  hcObjectTable = 42;
  hcBinaryTree = 43;
  hcAvlTree = 44;
  hcContents = 45;
  hcRegistering = 46;
  hcIms = 47;
  hcAbout = 48;
  hcWindowMenu = 49;
  hcTile = 50;
  hcCascade = 51;
  hcClose = 52;
  hcCloseAll = 53;
  hcRefresh = 54;
  hcResize = 55;
  hcZoom = 56;
  hcNext = 57;
  hcPrev = 58;
  hcVideoMode = 59;
  hcOptionsMenu = 60;
  hcTotalItems = 61;
  hcListBoxesMenu = 62;
  hcSequenceListBox = 63;
  hcSortedListBox = 64;
  hcTotalDuplicates = 65;
  hcHugeCollection = 66;
  hcHugeSortedCollection = 67;
  hcHugeStringCollection = 68;
  hcHugeUnSortedStrCollection = 69;
  hcHugeArray = 70;
  hcHugeObjectArray = 71;
  hcStdArray = 72;
  hcStdObjectArray = 73;
  hcSortedStdArray = 74;
  hcSortedHugeArray = 75;
  hcSortedStdObjectArray = 76;
  hcSortedHugeObjectArray = 77;
  hcResizableStdArray = 78;
  hcResizableStdObjectArray = 79;
  hcResizableHugeArray = 80;
  hcResizableHugeObjectArray = 81;
  hcStdArraysMenu = 82;
  hcHugeArraysMenu = 83;
  hcStreamArraysMenu = 84;
  hcHugeCollectionStack = 85;
  hcArrayStack = 86;
  hcHugeArrayStack = 87;
  hcBTree = 88;
  hcObjectBTree = 89;
  hcBPlusTree = 90;
  hcObjectBPlusTree = 91;

const
  { Object ID constants }
  idTestBinaryNode = 1000;
  idTestAVLNode = 1001;
  idTestObject =1002;
  idTestStreamSortedCollection = 1003;
  idTestListNode = 1004;
  idTestDoubleNode = 1005;
  idTestStaticObject = 1006;
  idTestEmsSortedCollection = 1007;
  idTestHugeSortedCollection = 1008;

implementation
end.