{$R-,S-,I-,D-,T-,F-,V-,B-,N-,L+ }
{$M 65500,0,0 }

unit modem;

interface

uses crt,dos;

const RBR=$3F8; THR=$3F8; DLL=$3F8; DLM=$3F9; IER=$3F9;
      IIR=$3FA; LCR=$3FB; MCR=$3FC; LSR=$3FD; MSR=$3FE;
      intnum=255;

var icomoffset:integer;

procedure mfunc (var r:registers; ahval,alval:byte);
procedure sendchar (k:char);
function numchars:integer;
function getchar:char;
procedure hangup;
procedure setoutbuffer (size:integer);
procedure setparam (comnum:byte; baud:integer; parity:boolean);
function carrier:boolean;
function driverpresent:boolean;
procedure setterminalready (b:boolean);
procedure dontanswer;
procedure doanswer;

implementation

procedure mfunc (var r:registers; ahval,alval:byte);
begin
  r.ax:=alval+(ahval shl 8);
  intr (intnum,r)
end;

procedure sendchar (k:char);
var r:registers;
begin
  mfunc (r,3,ord(k))
end;

function numchars:integer;
var r:registers;
begin
  mfunc (r,1,0);
  numchars:=r.ax
end;

function getchar:char;
var r:registers;
begin
  mfunc (r,2,0);
  getchar:=chr(r.ax and 255)
end;

procedure hangup;
var r:registers;
begin
  mfunc (r,6,0);
  delay (200)
end;

procedure setoutbuffer (size:integer);
var r:registers;
begin
  r.bx:=size;
  mfunc (r,8,0)
end;

procedure setparam (comnum:byte; baud:integer; parity:boolean);
var r:registers;
    p:byte;
begin
  mfunc (r,0,comnum);
  r.bx:=baud;
  if parity then p:=1 else p:=0;
  mfunc (r,7,p);
  setoutbuffer (baud div 30);
  case comnum of
    1:icomoffset:=0;
    2:icomoffset:=-256
  end
end;

function carrier:boolean;
begin
  carrier:=(port[msr+icomoffset] and 128)=128
end;

function driverpresent:boolean;
begin
  driverpresent:=memw[memw[0:intnum*4+2]:memw[0:intnum*4]]=7686
end;

procedure setterminalready (b:boolean);
begin
  port [icomoffset+mcr]:=ord(b) or 8
end;

procedure dontanswer;
begin
  setterminalready (false)
end;

procedure doanswer;
begin
  setterminalready (true)
end;

begin
end.

