/*****************************************************************************
 nbdetect.c

 Developed November 1991 by Larry Reeve

 A TurboC program to detect the presence of NetBIOS.
******************************************************************************/
#include <dos.h>
#include <stdio.h>

#define USGC                unsigned char
#define DOS_INT_21          0x21
#define DOS_INT_2A          0x2A
#define DOS_INT_2F          0x2F

#define PC_LAN_PGM_CHECK    0xB800
#define DOS_FETCH_VERSION   0x30
#define GET_MACHINE_NAME    0x5E00

#define REDIRECTOR_FLAG     0x0008
#define RECEIVER_FLAG       0x0080
#define MESSENGER_FLAG      0x0004
#define SERVER_FLAG         0x0040

int  CheckDosVersion(void);
void CheckForIBMLanProgram(void);
void GetMachineName(void);

void main (void)

{
    printf("NBDETECT 1.0 - NetBIOS & IBM PC LAN PROGRAM Detector");

    if (CheckDosVersion() == 0)
      CheckForIBMLanProgram();

    printf("\n");
}

int CheckDosVersion()
{
    union REGS InRegs,OutRegs;
    InRegs.h.ah = DOS_FETCH_VERSION;
    int86(DOS_INT_21,&InRegs,&OutRegs);
    printf("\n -DOS version is %u.%u",OutRegs.h.al,OutRegs.h.ah);

    if (OutRegs.h.al < 3)
      return (-1);

    if (OutRegs.h.al == 3)
      if (OutRegs.h.ah < 10)
        return (-1);

    InRegs.h.ah = 0;
    int86(DOS_INT_2A,&InRegs,&OutRegs);
    if (OutRegs.h.ah != 0)
      printf("\n -The INT2A NetBIOS interface is available.");
    else
      printf("\n -The INT2A NetBIOS interface is not available.");

    return (0);
}

void CheckForIBMLanProgram()
{
    USGC    temp;
    union   REGS    InRegs,OutRegs;

    InRegs.x.ax = PC_LAN_PGM_CHECK;
    int86(DOS_INT_2F,&InRegs,&OutRegs);
    if (OutRegs.h.al == 0)
    {
        printf("\n -The IBM PC Lan program is not installed.");
        return;
    }
    printf("\n -The IBM PC Lan program is installed.");
    printf("\n -This station is operating as a ");
    temp = OutRegs.h.bl & (REDIRECTOR_FLAG | RECEIVER_FLAG |
                           MESSENGER_FLAG | SERVER_FLAG);

    if (SERVER_FLAG & temp)
      printf("server.");
    else if (MESSENGER_FLAG & temp)
      printf("messenger.");
    else if (RECEIVER_FLAG & temp)
      printf("receiver.");
    else if (REDIRECTOR_FLAG & temp)
      printf("redirector.");
    else
    {
        printf("UNKNOWN CONFIGURATION! \n");
        return;
    }
    GetMachineName();
}


void GetMachineName()
{
    struct  SREGS   SegRegs;
    union   REGS    InRegs,OutRegs;
    char    Buffer[16];
    char    *BufferPtr = Buffer;

    InRegs.x.ax = GET_MACHINE_NAME;
    SegRegs.ds  = FP_SEG(BufferPtr);
    InRegs.x.dx = FP_OFF(BufferPtr);
    int86x(DOS_INT_21,&InRegs,&OutRegs,&SegRegs);

    if (OutRegs.h.ch != 0)
    {
        printf("\n -The machine name   is '%s'",Buffer);
        printf("\n -The machine number is %u.",OutRegs.h.cl);
    }
    else
        printf("\n -The machine name is not defined.");

}
