{ Fido Pascal Conference  PASCAL 
Msg  : 344 of 422
From : David Drzyzga                       1:3612/220.0         05 Jun 93  06:53
To   : Josh Whitt                          1:2260/170.0
Subj : tsr's

 TS> terminate your program and stay resident.
 JW> I have looked at it, but that's all it does - I need a way to intercept a
 JW> JW> key-press for a TSR notepad I'm writing.  Maybe this is what I should
 JW> JW> have asked about?

Here's a small scrreen blanker program. Notes: It will not run correctly in
Hercules or DESQview. Maybe not in mono either, but it does show how to
redefine the keyboard and timer interrupts.  Basically the program will swap
video pages if there is keyboard inactivity for 5 minutes or the amount of time
specified on the command line ( >0 and <11 ).}

{$M 2000,0,0}
{$R-,S-,I-,D+,F+,V-,B-,N-,L+}
program blankit;

uses
  dos;

const
  TimerInt    : byte = $08;
  KbdInt      : byte = $09;
  TimeLimit   : word = 5460;

var
  Regs        : registers;
  Cnt         : word;
  OldKbdVec   : pointer;
  OldTimerVec : pointer;
  Time        : real;
  Code        : word;

procedure calloldint(sub:pointer);
begin
  inline($9C/$FF/$5E/$06);
end;

procedure keyboard(flags,cs,ip,ax,bx,cx,dx,si,di,ds,es,bp : word); interrupt;

begin
  calloldint(oldkbdvec);
  if cnt >= timelimit then begin
    regs.ax := $0500;
    intr($10,regs);
  end;
  cnt := 0;
  inline($FB);
end;

procedure clock(flags,cs,ip,ax,bx,cx,dx,si,di,ds,es,bp : word); interrupt;
begin
  calloldint(oldtimervec);
  if cnt >= timelimit then begin
    regs.ax := $0501;
    intr($10,regs);
  end
  else
    inc(cnt,1);
  inline($FB);
end;

begin
  if paramcount = 1 then begin
    val(paramstr(1),time,code);
    if (code=0) and (time>0) and (time <11) then
      timelimit := trunc(time*18.2*60);
  end;
  getintvec(kbdint,oldkbdvec);
  getintvec(timerint,oldtimervec);
  setintvec(timerint,@clock);
  setintvec(kbdint,@keyboard);
  cnt := 0;
  keep(0);
end.