{ Fido Pascal Conference  PASCAL 
Msg  : 227 of 323
From : Nicholas Kirsch                     1:355/515.0          03 Jun 93  11:55
To   : Laurent Chartinier
Subj : Here is some source for using CD-ROMs.

Here is some source for using CD-ROM's with Pascal, if you get TP7, it's still
compatible.}

{ Copyright 1993 by Michael W. Armstrong.
                    2800 Skipwith Rd
                    Richmond, VA 23294
 
  Compuserve ID 72740, 1145
  This program is entered as Shareware.  If you find it useful, a small
  donation would be appreciated.  Feel free to incorporate the code into
  your own programs.
}
 
{$X+}
program CDPlay;
 
{$IfDef Windows}
{$C PRELOAD}
uses CD_Vars, CDUnit_P, WinCRT, WinProcs;
{$Else}
uses CD_Vars, CDUnit_P, CRT, Drivers;
{$EndIf}
 
Type
  TotPlayRec = Record
     Frames,
     Seconds,
     Minutes,
     Nada     : Byte;
  End;
 
Var
  GoodDisk : Boolean;
  SaveExit   : Pointer;
  OldMode    : Word;
  CurrentTrack,
  StartTrack,
  EndTrack   : Integer;
  TotPlay    : TotPlayRec;
  TrackInfo  : Array[1..99] of PAudioTrackInfo;
 
function LeadingZero(w: Word): String;
var s: String;
begin
  Str(w:0, s);
  LeadingZero := Copy('00', 1, 2 - Length(s)) + s;
end;
 
 
procedure DrawScreen;
Const TStr = '%03d:%02d';
      VStr = '%1d.%2d';
Var   FStr : PChar;
      NStr : String;
      Param: Array[1..2] of LongInt;
      Code : Integer;
begin
  WriteLn('CD ROM Audio Disk Player');
  WriteLn('Copyright 1992 by M. W. ARMSTRONG');
  Param[1] := MSCDEX_Version.Major;
  Param[2] := MSCDEX_Version.Minor;

{$IfDef Windows}
  wvsPrintf(FStr, VStr, Param);
{$Else}
  FormatStr(NStr, VStr, Param);
{$EndIf}
 
  WriteLn('MSCDEX Version ', NStr);
  Str(NumberOfCD, NStr);
  WriteLn('Number of CD ROM Drives is: '+Nstr);
  WriteLn('First CD Drive Letter is  : '+Chr(FirstCD+65));
  WriteLn('There are ' + LeadingZero(EndTrack - StartTrack + 1) + ' Tracks on 
this disk');
  Code := 1;
end;
{***********************************************************************}
 
{***********************************************************************}
 
 
procedure Setup;
Var
  LeadOut,
  StartP,
  TotalPlayTime    : LongInt;
  I     : Integer;
  A,B,C : LongInt;
  Track : Byte;
  EA    : Array[1..4] of Byte;
  SP,EP : LongInt;
 
Begin
  FillChar(AudioDiskInfo, SizeOf(AudioDiskInfo), #0);
  DeviceStatus;
  If Audio THEN
  Begin
    Audio_Disk_Info;
    TotalPlayTime := 0;
    LeadOut := AudioDiskInfo.LeadOutTrack;
 
    StartTrack := AudioDiskInfo.LowestTrack;
    EndTrack := AudioDiskInfo.HighestTrack;
    CurrentTrack := StartTrack;
    I := StartTrack-1;
 
    Repeat               { Checks if Audio Track or Data Track }
        Inc(I);
        Track := I;
        Audio_Track_Info(StartP, Track);
    Until (Track AND 64 = 0) OR (I = EndTrack);
 
    StartTrack := I;
 
    For I := StartTrack to EndTrack DO
      Begin
        Track := I;
        Audio_Track_Info(StartP, Track);
        New(TrackInfo[I]);
        FillChar(TrackInfo[I]^, SizeOf(TrackInfo[I]^), #0);
        TrackInfo[I]^.Track := I;
        TrackInfo[I]^.StartPoint := StartP;
        TrackInfo[I]^.TrackControl := Track;
      End;
 
    For I := StartTrack to EndTrack - 1 DO
        TrackInfo[I]^.EndPoint := TrackInfo[I+1]^.StartPoint;
    TrackInfo[EndTrack]^.EndPoint := LeadOut;
 
    For I := StartTrack to EndTrack DO
        Move(TrackInfo[I]^.EndPoint, TrackInfo[I]^.Frames, 4);
 
    TrackInfo[StartTrack]^.PlayMin := TrackInfo[StartTrack]^.Minutes;
    TrackInfo[StartTrack]^.PlaySec := TrackInfo[StartTrack]^.Seconds - 2;
 
    For I := StartTrack + 1 to EndTrack DO
      Begin
        EP := (TrackInfo[I]^.Minutes * 60) + TrackInfo[I]^.Seconds;
        SP := (TrackInfo[I-1]^.Minutes * 60) + TrackInfo[I-1]^.Seconds;
        EP := EP - SP;
        TrackInfo[I]^.PlayMin := EP DIV 60;
        TrackInfo[I]^.PlaySec := EP Mod 60;
      End;
 
    TotalPlayTime := AudioDiskInfo.LeadOutTrack - 
TrackInfo[StartTrack]^.StartPoint;
    Move(TotalPlayTime, TotPlay, 4);
  End;
end;
 
{***********************************************************************}
 
 
Begin
  Setup;
  If Audio THEN
  If Playing THEN
     StopAudio
  ELSE
     Begin
       StopAudio;
       Play_Audio(TrackInfo[StartTrack]^.StartPoint,
             TrackInfo[EndTrack]^.EndPoint);
       Audio_Status_Info;
       DrawScreen;
     End
  ELSE
      WriteLn('This is not an Audio CD');
  WriteLn('UPC Code is: ', UPC_Code);
end.