{ Fido Pascal Conference  PASCAL 
Msg  : 421 of 436
From : Sean Palmer                         1:104/123.0          26 Jun 93  03:58
To   : Jim Coyle
Subj : Hey!

JC>I'm looking for some really good routines to access the fossil driver, can
JC>someone tell me a BBS where I could call or FREQ them from at 9600 v32 baud?

I think this is small enough to post..}

{$A-,B-,D+,E-,F-,G+,I-,L+,N-,O-,R-,S-,V-,X+}
unit fossil;
interface

const
 curPort:word=0;  {0=COM1,1=COM2,$FF=none}
 maxFunct:byte=0;
 fossilVersion:byte=0;


 statusOutEmpty  =$4000;  {masks for status}
 statusOutNotFull=$2000;
 statusInOverrun =$0200;
 statusInWaiting =$0100;
 statusCarrier   =$0080;

 flowRemXON=1; flowLocXON=8; flowRTSCTS=2;

 on=1; off=2; check=$FF;  {for boolean set/check functions like DTR}

type hook=procedure;

 function init:boolean;
 procedure close;
 function setBaud(s:byte):word;
 function dtr(b:byte):boolean;
 function carrier:boolean;
 function received:boolean;
 function status:word;
 function get:char;
 function put(c:char):word;
 function next:char;
 procedure purgeOut;
 procedure purgeIn;
 procedure flushOut;
 procedure flow(f:byte);
 procedure break(b:boolean);
 procedure xmit(b:boolean);
 procedure write(s:string);
 function writeBlock(var b;n:word):word;
 function readBlock(var b;n:word):word;
 function watch(p:hook;add:boolean):boolean;

implementation

function setBaud(s:byte):word;assembler;asm
 mov dx,curPort; mov al,s; mov ah,0; int $14; {returns status bits}
 end;

function put(c:char):word;assembler;asm
 mov dx,curPort; mov al,c; mov ah,1; int $14; {returns status bits}
 end;

procedure write(s:string);var i:byte;begin
 for i:=1 to length(s) do put(s[i]);
 end;

function get:char;assembler;asm  {waits if none}
 mov dx,curPort; mov ah,2; int $14;  {returns char}
 end;

function status:word;assembler;asm
 mov dx,curPort; mov ah,3; int $14;   {returns status bits}
 end;

function carrier:boolean;assembler;asm
 mov dx,curPort; mov ah,3; int $14; and ax,statusCarrier;
 end;

function received:boolean;assembler;asm
 mov dx,curPort; mov ah,3; int $14; and ax,statusInWaiting; mov al,ah;
 end;

function init:boolean;assembler;asm {raises DTR, preserves baud if successful}
 mov dx,curPort; xor bx,bx; mov ah,4; int $14;  {bx<>$BF50}
 cmp ax,$1954; jne @FAIL; mov maxFunct,bl; mov fossilVersion,bh; jmp @X;
@FAIL: xor ax,ax;
@X:
 end;

procedure close;assembler;asm
 mov dx,curPort; mov ah,5; int $14;  {doesn't change DTR}
 end;

function dtr(b:byte):boolean;assembler;asm
 mov dx,curPort; mov al,b; mov ah,6; int $14; {returns current DTR setting}
 end;

procedure flushOut;assembler;asm
 mov dx,curPort; mov ah,8; int $14;
 end;

procedure purgeOut;assembler;asm
 mov dx,curPort; mov ah,9; int $14;
 end;

procedure purgeIn;assembler;asm
 mov dx,curPort; mov ah,$A; int $14;
 end;

function next:char;assembler;asm {returns pending char, or #0 if none}
 mov dx,curPort; mov ah,$C; int $14; {doesn't remove from buffer!!}
 not ah; and al,ah; {if ax=$FF(no char) then set al=0}
 end;

procedure flow(f:byte);assembler;asm
 mov dx,curPort; mov al,f; mov ah,$F; int $14;
 end;

procedure xmit(b:boolean);assembler;asm  {enable/disable transmitting}
 mov dx,curPort; mov al,b; or al,al; jz @S; mov al,2; @S:
 mov ah,$10; int $14;
 end;

function watch(p:hook;add:boolean):boolean;assembler;asm {insert/delete timer t
 les dx,p; mov al,add; or al,al; jz @S; mov al,1; @S:
 mov ah,$16; int $14;  {returns 0 if success, $FFFF if not}
 xor ax,ax; {fix boolean so true means success}
 end;

function readBlock(var b;n:word):word;assembler;asm {won't wait for chars to be
 mov dx,curPort; les di,b; mov cx,n; mov ah,$18; int $14; {returns chars read}
 end;

function writeBlock(var b;n:word):word;assembler;asm {will only send as many as
 mov dx,curPort; les di,b; mov cx,n; mov ah,$19; int $14; {returns chars sent}
 end;

procedure break(b:boolean);assembler;asm {start/stop sending break}
 mov dx,curPort; mov al,b; or al,al; jz @S; mov al,1; @S:
 mov ah,$1A; int $14;
 end;

end.