{ Fido Pascal Conference  PASCAL 
Msg  : 348 of 389
From : Dj Murdoch                          1:249/99.5           16 Jun 93  08:31
To   : Chris Jantzen
Subj : DPMI & BP7

 CJ> Does anyone know how to configure virtual disk memory
 CJ> using the BP7 DPMI interface? I know that the IDE is doing
 CJ> it, because you can specify a swap file size and get more
 CJ> working memory space, and the IDE *is* written using BP7,
 CJ> so it can be done... It should be a call to one of the
 CJ> pseudo-DLLs in RTM.EXE, shouldn't it?

Here's a unit I got 3rd hand on Compuserve.  It's supposed to have been written
by someone at Borland.  I haven't tried it, but others have told me it works.}

 unit RTMSwap;

 interface

 const
   rtmOK          = $0;
   rtmNoMemory    = $1;
   rtmFileIOError = $22;

 function MemInitSwapFile(FileName: PChar; FileSize: Longint): Integer;
   {  Opens a swapfile of the specified size.  If a swapfile
      already exists, and the new size is larger, the swapfile
      will grow, otherwise the previous swap file parameters are
      used.

      Returns:   rtmOK           - Successful
                 rtmNoMemory     - Not enough disk space
                 rtmFileIOError  - Could not open/grow file
   }


 function MemCloseSwapFile(var Delete: Integer): Integer;
   {  Closes the swapfile if it was created by the current task.
      If the value returned in "Delete" is non-zero, the swapfile
      was deleted.

      Returns:   rtmOK           - Successful
                 rtmNoMemory     - Not enough physical memory to run
                                   without the swap file
                 rtmFileIOError  - Could not close/delete the file
   }

 implementation

   function MemInitSwapFile;  external 'RTM' index 35;
   function MemCloseSwapFile; external 'RTM' index 36;

 end.