{ Fido Pascal Conference  PASCAL 
Msg  : 331 of 374
From : Sean Palmer                         1:104/123.0          25 May 93  00:00
To   : All
Subj : MultiTasking,Threads

Lot of talk going on about multitasking lately.

Here's some source to do simple task switching:}

{create a new process thread}
{needs the process's start address, a stack buffer, and the size of that
 stack}
{processes must be far procedures with no parameters}

function newProcess(process,stack:pointer;stackSize:word):pointer;begin
 inc(word(stack),stackSize-12); {room for p1,p2,far return adr}
 pointer(stack^):=process;   {fake far return adr}
 dec(word(stack),2);
 word(stack^):=word(stack);  {fake pushed bp}
 newProcess:=stack;
 end;

{transfer control from one process to another}

procedure transfer(var p1,p2:pointer);far;assembler;asm
 mov ax,ds
 lds si,p1       {store old process' stack}
 mov [si],sp
 mov [si+2],ss
 lds si,p2       {get next process' stack}
 mov ss,[si+2]
 mov bp,[si]     {epilog will move this to sp}
 mov ds,ax
 end;

{test code}

var
 p0,             {main program's saved stack pointer}
 p1,p2:pointer;  {processes' saved stack pointers}
 stack1,stack2:array[0..255]of byte; {processes' stacks}

procedure proc1;far;var i:integer;begin
 for i:=0 to 7 do begin
  writeln('First');
  transfer(p1,p2);
  end;
 transfer(p1,p0);  {return}
 end;

procedure proc2;far;label _LOOP;begin
_LOOP:
 writeln('Second');
 transfer(p2,p1);
 writeln('Third');
 transfer(p2,p1);
 goto _LOOP;
 end;

begin
 p1:=newProcess(@proc1,@stack1,256);
 p2:=newProcess(@proc2,@stack2,256);
 transfer(p0,p1);
 end.