{ Fido Pascal Conference  PASCAL 
Msg  : 468 of 619
From : Sean Palmer                         1:104/123.0          08 Jun 93  17:35
To   : All
Subj : XorSum / hashing

KS> SC> (more than I thought I would have).  There were 190 collisions
KS> SC> out of 572 names.

KS>The solution would be to use a better hashing algorythm, simply
KS>adding up the ascii characters is not unique enough.  You best
KS>approach would be to generate a CRC value for your hashing table
KS>rather then the checksum approach.

Or try this xorsum method (my own invention, have to plug for it... 8)

Lots faster than a crc with no table, with similar results.

NOT compatible with a crc.

This xorsum algorithm is hereby standardized and if anyone wants to use
it you should make sure your xorsum routines give the same results.}

function XorSum16(var data;size:word;prevSum:word):word;assembler;asm
 push ds
 lds si,data
 mov cx,size
 mov bx,prevSum
 mov dx,$ABCD
 cld
 jcxz @X
@L:lodsb
 rol bx,1
 xor bx,dx
 xor bl,al
 loop @L
@X: mov ax,bx
 pop ds
 end;

to use on a string, for instance:

const s:string='this is a test';

 writeln(xorsum16(s,length(s)+1,0));

send 0 as prevSum if you're not accumulating a result...otherwise send
the result from the previous buffer.