{ Fido Pascal Conference  PASCAL 
Msg  : 417 of 448                                                               
From : Bernie Pallek                       1:247/128.0          24 Jul 93  11:11 
To   : Matthew Mclin                                                             
Subj : (1/2) Digital Sound                                                    

MM> Does anybody know the format of .MOD/.SAM/.WAV/.VOC file?
MM> Info on any of those formats (how to read/write/play them
MM> using a PC Speaker or LPT 1 with a mono DAC) would be
MM> greatly appreciated. I would also like info on raw sound
MM> data and how to edit/play it. Note that these .MOD and
MM> .SAM files are in the Amiga Module format (just in case
    ^^^^^^^^^^^^^^^^^^^^^^^^^^^
MM> there are any others). Oh, there's
MM> also the .SND files. Or even .MID/.MDI files if you can play
MM> them thru a DAC on an LPT port or the PC Speaker. Note that I
MM> don't have a Sound Blaster (or any other sound card). Thanks.

Well, Matt, digital sound is a complicated subject, but I can tell
you a few things.
First of all, .SAM files don't have a special format; they are just
files with raw data.  The program that plays them has to determine
the playback speed, etc.
Now, about playing them back on a DAC.  Here is some information I
collected, and added to.  The code is theoretic and untested!
- - - 8<- - - - - - - - -S-N-I-P- -L-I-N-E- - - - - - - ->8 - - - -
To output to a DAC, all you have to do is this:}

Port[$0378] := byteVal;  { byteVal could be read from a .VOC or .WAV file }
{ the port value is for LPT1; LPT2 may be $0388... not sure }
{
The data is best sent with a hi-res timer to even the flow.
For example:}

{ theoretic code to play TEST.SAM }
CONST
     LPT1         = $0378;
     SoundName    = 'TEST.SAM';   { raw sample }
     MaxSoundSize = 9999;  { max. file size of sound data }
                           { this may be adjusted as necessary }

VAR
   soundArray : ARRAY[0..MaxSoundSize] OF Byte;
   soundLen   : LongInt;  { actual length of sound in bytes }
   soundFile  : File;
   result     : LongInt;
   j          : LongInt;

BEGIN
     Assign(soundFile, SoundName);
     soundLen := GetFileSizeOf(SoundName);
     Reset(soundFile, 1);   { record size of 1 }
     BlockRead(soundFile, soundArray[0], soundLen, result);
     Close(soundFile);
     FOR j := 0 TO soundLen DO BEGIN
         Port[LPT1] := soundArray[j];
         { AccurateDelay;    <-- it's your job to write this :')  }
     END;
END.
- - - 8<- - - - - - - - -S-N-I-P- -L-I-N-E- - - - - - - ->8 - - - -
OK, I hope this helps you.  You may play .VOC files with the program
(if it works :'), but note that they will have a static-sounding
bit of garbage at the beginning, because of headers.  If you'd like,
I can post you the .VOC header information, or I can put it on a
board that you can call if you desperately need the info; I don't
think UUencoding is allowed on this echo, or I'd send it to you
that way.