; Fido Pascal Conference  PASCAL 
;Msg  : 67 of 157
;From : Wilbert van Leijen                  2:281/256.14         13 Jul 93  22:05
;To   : Charles Lumia                       1:150/320.0
;Subj : Mouse pointers
;
;06 Jul 93, Charles Lumia writes to All:
;
; CL> How can I allow it to accept any # of variables and any type to pass them
; CL> to writeln, like the real writeln? * SPITFIRE v3.3
;
;That's only feasible by using the C calling convention, or in external
;assembler code using tricky code that fiddles with the stack.  The first is not
;an option in Borland Pascal (it is, however, supported in TopSpeed Pascal).
;The latter assumes having mastered the Zen of assembly language.  Nevertheless,
;the rules of the Pascal calling convention still apply: called routine must
;remove arguments from the stack - or kaboom!
;
;Here follows an example of an ASM module that exports three routines, all
;sharing a common exit point.  Two of the three, HexByte and HexWord, allocate
;10 bytes on the stack (6 bytes thereof are parameters, 4 bytes make up the
;return address when called Far), whereas HexLongInt pushes 12 bytes.  On exit,
;in each case the value of the SP register is properly restored.
;
;Sample usage:
;
;Var
;  buf : Array[0..9] of Char;     { PChar scratch pad }
;
;Begin  WriteLn(HexLongInt(MaxLongInt, buf))); end.
;
;HEXPCHAR.ASM:
;
;  Written by Wilbert van Leijen.  Released to the public domain.
;  Use TASM to assemble:  TASM -m2 -zi HEXPCHAR
;
           MODEL   LARGE       ; don't specify a language!
.CODE
           PUBLIC  HexByte, HexWord, HexLongInt

;  Function HexLongInt(l : LongInt; Result : PChar) : PChar; Far;
;  Function HexWord(w : Word; Result : PChar) : PChar; Far;
;  Function HexByte(b : Byte; Result : PChar) : PChar; Far;

HexDigitWord PROC  Near
           PUSH    AX
           XCHG    AH, AL
           CALL    HexDigitByte
           POP     AX

HexDigitByte:
           PUSH    AX
           MOV     CL, 4
           SHR     AL, CL
           CALL    HexDigitNibble
           POP     AX
           AND     AL, 00001111b

HexDigitNibble:
           ADD     AL, 90h
           DAA
           ADC     AL, 40h
           DAA
           STOSB
           RETN
HexDigitWord ENDP

HexLongInt PROC
           ARG     ResultString : DWord, LoWord, HiWord : Word = ArgSize

           MOV     DX, Offset HexDigitWord
           STC                         ;  CF = display two words
           JMP     Short @@2

HexWord:   MOV     DX, Offset HexDigitWord
           JMP     Short @@1

HexByte:   MOV     DX, Offset HexDigitByte

@@1:       CLC
@@2:       PUSH    BP
           MOV     BP, SP
           LES     DI, ResultString
           PUSH    DI
           MOV     BX, ArgSize-2
           JNC     @@3

           MOV     AX, HiWord
           CALL    DX
           INC     BX                  ;  remove 2 bytes more from stack
           INC     BX

@@3:       MOV     AX, LoWord
           CALL    DX

           XOR     AL, AL              ;  Trailing null
           STOSB
           POP     AX                  ;  Return pointer to result string
           MOV     DX, ES
           POP     BP
           POP     DI  ES              ;  Save return address
           ADD     SP, BX              ;  Remove parameters from the stack
           PUSH    ES  DI              ;  Restore return address
           RET
HexLongInt ENDP

           END