{ Fido Pascal Conference  PASCAL 
Msg  : 82 of 109                                                                
From : Jon Taylor                          1:363/640.0          29 Jun 93  12:34 
To   : Lou Duchez                          1:157/200.0                           
Subj : Timers                                                                 

* In a message originally to John Linden, Lou Duchez said:

 > BO>JL>How do you put a timer that changes every second on the screen
 > without movin
 > BO>JL>the cursor all the tim. For instance, I am writing a terminal and

 > My two cents: if you want to do direct video writes, here's
 > my contribution;

And I'll add my two cents--The routine looks good but it (like alot of "quick
write" routines) assumes an 80 column display.  I have a 132 column display--so
I modified your routine to dynamically adjust to the width of the
screen:}
procedure qwrite(x, y: byte; s: string; f, b: byte);

  type  videolocation = record    { the layout of a two-byte vidcell }       
videodata: char;        { character displayed }
        videoattribute: byte;   { attributes }
        end;

var cnter: byte;
    videosegment: word;         { the location of video memory }
    monosystem: boolean;        { mono vs. color }
    vidptr: ^videolocation;     { pointer to video locations }
    cols: byte;                 { Number of columns! }
 begin 
   monosystem := (lastmode in [0,2,7]);
   if monosystem then videosegment := $b000 else videosegment := $b800;
   ASM mov ah, 0fh; int 10h; mov cols, ah; END; { Get # of cols! }   vidptr := 
ptr(videosegment, 2*(cols*(y - 1) + (x - 1))); {Note cols!}   for cnter := 1 to
length(s) do begin
     vidptr^.videoattribute := (b shl 4) + f; { high nibble=bg; lo nibble=fg }
     vidptr^.videodata := s[cnter];            { put character at location }
     inc(vidptr);                              { go to next video location }
     end;
   end;

I know most people don't have displays with more than 80 columns, but the
modification is easy when done this way (but not so easy when you use the
MEM/MEMW approach to video memory, or define a big RECORD for all of video
memory).