{ Fido Pascal Conference  PASCAL 
Msg  : 336 of 353                                                               
From : Brian McCormick                     1:3821/1.0           24 Jul 93  09:58 
To   : Gary Morris                                                               
Subj : Fermat's Theorem 2/2                                                   

This program generates triples satisfying x**2 + y**2 = z**2 using a method
that eliminates floating point calculations and most multiplications.  It can
be fairly easily adjusted to accomodate cubes or higher order powers.  If
anyone has any suggestions or improvements to this algorithm, let me know.  It 
runs in O(n**2) time, just like the brute force method involving a pair of
nested loops, however, it eliminates all floating point calculations and checks
fewer values and is thus dramatically faster.

Triples generated by this program are sorted by Z, not by X or Y as they are
using the obvious algorithm.}

program pythag;

{ The display can be made faster by adding the line }
{  uses crt;                                        }
{ here.                                             }

const MAXINLIST = 1200;

type p_squarelist = ^t_squarelist;
     t_squarelist = array[1..MAXINLIST] of longint;

var out     : text;
    a, b, c : longint;
    sl1     : p_squarelist;

procedure writetriple( a, b, c: longint );
   begin
      writeln( a:7, b:7, c:7 );
   end;

procedure checkforpyth( c: word );
   var a, b    : word;
       check   : longint;
       sum     : longint;
   begin
      a := 1;
      b := c-1;
      check := sl1^[c];
      while a < b do begin
         sum := sl1^[a] + sl1^[b];
         if sum = check then begin
            writetriple( a, b, c );
            inc(a);
            end
         else if sum > check then
            dec(b)
         else
            inc(a);
         end;
   end;

procedure initsquarelist( var sl: p_squarelist; start: integer );
   var loop: integer;
       stop: integer;
   begin
      new( sl );
      if start + MAXINLIST - 1 < 0 then
         stop := maxint
      else
         stop := start + MAXINLIST - 1;
      for loop := start to stop do
         sl^[loop-start+1] := longint(loop)*loop;
   end;

begin
   writeln( 'Generating list of squares' );
   initsquarelist( sl1, 1 );
   for a := 3 to MAXINLIST do
      checkforpyth( a );
   writeln;
end.