{ Fido Pascal Conference  PASCAL 
Msg  : 276 of 295                                                               
From : Bryce Ostenson                      1:282/4028.0         27 Jun 93  17:40
To   : John Linden                                                               
Subj : Timers            1/                                                   

JL>BO> Output the time directly to the screen using a absolute memory location.
JL>BO> This does NOT use the cursor and is EASILY implemented in a TSR...  Just
JL>BO> a thought...  On the timer interrupt...  It's called 18.2 times per
JL>BO> second (approx.) and the error would add up... If the user was in your
JL>BO> program too long the error WOULD become evident.  So I suggest perhaps,
JL>BO> hooking onto the timer interrupt and obtaining the time such as through
JL>BO> GETTIME() (I think that's right but I don't use it too much).  So the
JL>BO> time is updated 18.2 times per second and yet is much more accurate,

JL>Do you have some code on doing this? So how do you write to the absolute?

JL>PrintTimer : STRING ABSOLUTE $B800: ???

JL>Then if you say PrintTimer := 5 will it print at at the location?? I'm
JL>confused...

JL>C-Ya...}

Unit TBDisplay;

                                                                INTERFACE

Const
        { Colors }
        Black = 0;
        Blue = 1;
        Green = 2;
        Cyan = 3;
        Red = 4;
        Magenta = 5;
        Brown = 6;
        White = 7;
        Gray = 8;
        BrightBlue = 9;
        BrightGreen = 10;
        BrightCyan = 11;
        BrightRed = 12;
        BrightMagenta = 13;
        BrightYellow = 14;
        BrightWhite = 15;

Type
        CharData = Record
                AsciiCode : Byte;
                Attribute : Byte;
                End;
        DisplayCursor = Record
                X, Y : Byte;
                End;

Var { Global Variables }
        DispArray : Array[1..2000] of CharData ABSOLUTE $B800:0000;
        WordWrap : Boolean;
        CurrentAttrib : Byte;
        DispCrsr : DisplayCursor;

Procedure OutStr_DVid(OutStr : String; PosX, PosY : Byte);
Procedure SetAttr_DVid(Blink : Boolean; Background : Byte;
                                                Foreground : Byte);
Procedure ClrScr_DVid;
Procedure SetCrsrPos_DVid(X, Y : Byte);
Procedure GetCrsrPos_DVid(Var X, Y : Byte);
Procedure ColorLine_DVid(LineNum, Color : Byte);

                                                          IMPLEMENTATION

Function StrToChar(SourceStr : String;
                   Index : Byte) : Char;

Var
        Temp_char : String[1];
        Overlap : ^Word;

Begin
        Temp_char := Copy(SourceStr,Index,1);
        Overlap := @Temp_char;
        StrToChar := Chr(Overlap^ DIV $FF);
End;

Procedure ClrScr_DVid;

Var
        Index : Word;

Begin
        For Index := 1 to 2000 do
        Begin
                DispArray[Index].AsciiCode := 32;
                DispArray[Index].Attribute := CurrentAttrib;
        End;
End;

Procedure OutStr_DVid(OutStr : String; PosX, PosY : Byte);

Var
        Index : Integer;
        Ch : Byte;
        ArrayPos : Word;

Begin
        For Index := 1 to Length(OutStr) do
        Begin
                Ch := Ord(StrToChar(OutStr,Index));
                ArrayPos := PosY * 80 + PosX + Index;
                If (PosX = $FF) AND (PosY = $FF) then
                Begin
                        DispArray[DispCrsr.X + DispCrsr.Y * 80].AsciiCode :=
ch;
                        DispArray[DispCrsr.X + DispCrsr.Y * 80].Attribute :=
Cur
                        DispCrsr.X := DispCrsr.X + 1;
                        If DispCrsr.X > 79 then
                        Begin
                                DispCrsr.X := 0;
                                DispCrsr.Y := DispCrsr.Y + 1;
                        End;
                End
                Else
                Begin
                        DispArray[ArrayPos].AsciiCode := ch;
                        DispArray[ArrayPos].Attribute := CurrentAttrib;
                End;
                If (WordWrap = False) AND ((Index + PosX) > 80) then
                        Exit;
        End;
End;

Procedure SetAttr_DVid(Blink : Boolean; Background : Byte;
                                                Foreground : Byte);

Begin
        If Blink = true then
                CurrentAttrib := $80
        Else
                CurrentAttrib := 0;
        CurrentAttrib := CurrentAttrib + $10 * (Background AND $07);
        CurrentAttrib := CurrentAttrib + Foreground;
End;

Procedure SetCrsrPos_DVid(X, Y : Byte);

Begin
        DispCrsr.X := X;
        DispCrsr.Y := Y;
End;

Procedure GetCrsrPos_DVid(Var X, Y : Byte);

Begin
        X := DispCrsr.X;
        Y := DispCrsr.Y;
End;

Procedure ColorLine_DVid(LineNum, Color : Byte);

Var
        Index : Byte;

Begin
        For Index := 1 to 80 do
                DispArray[LineNum*80 + Index].Attribute := (Color AND $07) *
16;
End;

Begin
        WordWrap := True;  { Initalize word wrap to true. }
        CurrentAttrib := $07; { Set current text colors to White on black. }
End.

Here's the unit I use, I decided to just import it.

Program TestTimer;

Uses
        TBDisp;

Begin
        {First get the time, you can do that}
        {Create the string to be displayed, again I'll let you do that.}
        {Set the text color for the display}
        SetAttr_DVid(False,Blue,Yellow);
        {Display the text}
        OutStr_DVid(TimeStr,70,25);
        {That's it}
End.

Ok, it will display TimeStr in Yellow type on a blue background at row
25, column 70.  Sorry, but I didn't use many comments in the unit as you
are the first person that I've given it to, and since I wrote it and use
it very often, I know it.  A small note, If you use the OutStr_DVid
procedure and supply it with text positions of 255($FF) for it column
and 255($FF) for it's row, it will display the text at IT'S cursor
position not the cursor position as used by GotoXY or Write(ln), etc...
In other words it HAS it's own cursor, but it's purely logical, not
actually displayed on the screen.  One other thing, SetAttr_DVid,
changes this UNITS, text color and background color, not the ones used
by Writeln, etc...  I hope this helps...